/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnHelper;

public class InOpenWaterCondition
implements ILootCondition {
    private static final InOpenWaterCondition INSTANCE = new InOpenWaterCondition();
    public static final String RL = "tombstone:in_open_water";
    public static final Serializer SERIALIZER = new Serializer();

    private InOpenWaterCondition() {
    }

    public boolean test(LootContext context) {
        Entity hook = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        return hook != null && InOpenWaterCondition.isOpenWaterAround(hook.field_70170_p, hook.func_233580_cy_());
    }

    private static boolean isOpenWater(World world, BlockPos pos, boolean inStillWater) {
        BlockState state = world.func_180495_p(pos);
        FluidState fluidState = state.func_204520_s();
        if (inStillWater) {
            return fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && fluidState.func_206889_d() && state.func_177230_c() != Blocks.field_203203_C && Helper.hasNoCollision((IBlockReader)world, pos, state);
        }
        return state.isAir((IBlockReader)world, pos) || state.func_177230_c() == Blocks.field_196651_dG || Helper.hasNoCollision((IBlockReader)world, pos, state);
    }

    public static boolean isOpenWaterAround(World world, BlockPos pos) {
        int inStillWater = pos.func_177956_o();
        return SpawnHelper.getAllInBox(pos.func_177982_a(-2, -2, -2), pos.func_177982_a(2, 1, 2)).allMatch(aPos -> InOpenWaterCondition.isOpenWater(world, aPos, aPos.func_177956_o() <= inStillWater));
    }

    public static ILootCondition.IBuilder builder() {
        return () -> INSTANCE;
    }

    public LootConditionType func_230419_b_() {
        return ModTombstone.OPEN_WATER;
    }

    private static class Serializer
    implements ILootSerializer<InOpenWaterCondition> {
        private Serializer() {
        }

        public void serialize(JsonObject json, InOpenWaterCondition condition, JsonSerializationContext context) {
        }

        public InOpenWaterCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return INSTANCE;
        }
    }
}

