/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class ItemGraveKey
extends ItemGraveMagic {
    public ItemGraveKey() {
        super("grave_key", () -> SharedConfigTombstone.allowed_magic_items.allowGraveKey.get());
        this.withSoulboundInfo();
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        String id = this.isEnchanted(stack) ? "2" : "1";
        this.addItemDesc(tooltip, id, new Object[0]);
        this.addItemDesc(tooltip, "3", new Object[0]);
        Location location = this.getTombPos(stack);
        if (!location.isOrigin()) {
            this.addItemPosition(tooltip, location);
        }
        this.addItemUse(tooltip, id, new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTStackHelper.setLocation(stack, "tombPos", location);
            return true;
        }
        return false;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, "tombPos");
        }
        return Location.ORIGIN;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.func_201670_d() && EntityHelper.isValidPlayer(entity) && stack.func_77973_b() == this) {
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && TimeHelper.atInterval(entity, TimeHelper.tickFromSecond(isSelected && entity.func_70092_e((double)location.getPos().func_177958_n(), (double)location.getPos().func_177956_o(), (double)location.getPos().func_177952_p()) < 100.0 ? 10 : 120))) {
                if (!location.isSameDimension(world)) {
                    return;
                }
                if (!World.func_189509_E((BlockPos)location.getPos())) {
                    if (!world.func_175667_e(location.getPos())) {
                        world.func_180495_p(location.getPos());
                    }
                    isBadKey = !(world.func_175625_s(location.getPos()) instanceof TileEntityPlayerGrave);
                } else {
                    isBadKey = true;
                }
            }
            if (isBadKey) {
                stack.func_190918_g(1);
                ((PlayerEntity)entity).field_71069_bz.func_75142_b();
            }
        }
    }

    public boolean removeKeyForGraveInInventory(PlayerEntity player, Location graveLoc) {
        return InventoryHelper.removeFirstInInventory(player, stack -> stack.func_77973_b() == this && this.getTombPos((ItemStack)stack).equals(graveLoc));
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_CANT_ENCHANT_GRAVE_KEY.getText(new Object[0]);
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        if (!location.isSameDimension((World)world) && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        ServerWorld targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (targetWorld == null || !Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", false);
        CallbackHandler.addCallback(1, () -> {
            PlayerEntity newPlayer = (PlayerEntity)Helper.teleportToGrave(player, location, targetWorld);
            if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeTeleportWithKey.get()).booleanValue()) {
                EffectHelper.capDuration((LivingEntity)newPlayer, ModEffects.ghostly_shape, 200);
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
            ModTriggers.TELEPORT_TO_GRAVE.trigger(player);
        });
        return true;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    public void reenchantOnDeath(PlayerEntity player, ItemStack key) {
        int chanceEnchantedKey;
        if (key.func_77973_b() == this && (chanceEnchantedKey = ((Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get()).intValue()) >= 0 && ((chanceEnchantedKey += EntityHelper.getPerkLevelWithBonus(player, ModPerks.jailer) * 20) >= 100 || chanceEnchantedKey > 0 && Helper.getRandom(1, 100) <= chanceEnchantedKey)) {
            NBTStackHelper.setBoolean(key, "enchant", true);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || ModBlocks.isPlayerGrave(state.func_177230_c());
    }
}

