/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.TieredItem;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.CompatibilityEnigmatic;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.PlayerPreference;

public class InventoryHelper {
    private static final IItemHandler EMPTY_ITEM_HANDLER = new ItemStackHandler(NonNullList.func_191196_a());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean autoequip(ItemStack stack, PlayerEntity player) {
        boolean bl;
        if (stack.func_190926_b()) return false;
        if (stack.func_77976_d() != 1) return false;
        if (CompatibilityEnigmatic.instance.isDenied(stack)) return false;
        if (InventoryHelper.isPowerSuit(stack)) {
            return false;
        }
        if (EnchantHelper.getEnchantmentLevel(Enchantments.field_190941_k, stack) > 0) {
            return false;
        }
        if (((Boolean)ConfigTombstone.compatibility.allowCurioAutoEquip.get()).booleanValue() && SupportMods.CURIOS.isLoaded() && CompatibilityCurio.instance.autoEquip(stack, player)) {
            return true;
        }
        if (player.func_184592_cb().func_190926_b()) {
            if (InventoryHelper.isBattleSign(stack) && player.func_174820_d(99, stack.func_77946_l())) {
                return true;
            }
            if (stack.func_77973_b().isShield(stack, (LivingEntity)player) && player.func_174820_d(99, stack.func_77946_l())) {
                return true;
            }
        }
        EquipmentSlotType slot = stack.func_77973_b().getEquipmentSlot(stack);
        boolean isElytra = false;
        if (slot == null) {
            if (stack.func_77973_b() instanceof ArmorItem) {
                slot = ((ArmorItem)stack.func_77973_b()).func_185083_B_();
            } else {
                if (!InventoryHelper.isElytra(stack)) return false;
                slot = EquipmentSlotType.CHEST;
                isElytra = true;
            }
        } else if (slot == EquipmentSlotType.CHEST) {
            isElytra = stack.func_77973_b() instanceof ElytraItem;
        }
        int slotId = slot.func_188454_b();
        ItemStack stackInSlot = (ItemStack)player.field_71071_by.field_70460_b.get(slotId);
        if (stackInSlot.func_190926_b()) {
            player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
            return true;
        }
        if (slot != EquipmentSlotType.CHEST) {
            return false;
        }
        boolean equipElytraInPriority = PlayerPreference.get(player.func_110124_au()).equipElytraInPriority();
        if (InventoryHelper.isElytra(stackInSlot)) {
            if (isElytra) return false;
            if (equipElytraInPriority) return false;
            bl = true;
        } else {
            if (!isElytra) return false;
            if (!equipElytraInPriority) return false;
            bl = true;
        }
        boolean canEquip = bl;
        if (!canEquip) return false;
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stackInSlot.func_77946_l());
        player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
        return true;
    }

    public static ItemStack findItemInMainInventory(PlayerEntity player, Predicate<ItemStack> predic) {
        return player.field_71071_by.field_70462_a.stream().filter(predic).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static boolean isElytra(ItemStack stack) {
        return stack.func_77973_b() instanceof ElytraItem || InventoryHelper.isWing(stack);
    }

    private static boolean isWing(ItemStack stack) {
        return SupportMods.WINGS.isLoaded() && Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(rl -> SupportMods.WINGS.func_176610_l().equals(rl.func_110624_b()) && rl.func_110623_a().endsWith("_wings")).orElse(false) != false;
    }

    public static boolean isTool(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77976_d() == 1 && (stack.func_77973_b() instanceof TieredItem || stack.func_77973_b() instanceof FishingRodItem || stack.func_77973_b() instanceof ShearsItem);
    }

    private static boolean isPowerSuit(ItemStack stack) {
        return SupportMods.POWERSUITS.isLoaded() && Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(rl -> "powersuits".equals(rl.func_110624_b())).orElse(false) != false;
    }

    private static boolean isBattleSign(ItemStack stack) {
        return SupportMods.TCONSTRUCT.isLoaded() && Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(rl -> "tconstruct".equals(rl.func_110624_b()) && "battlesign".equals(rl.func_110623_a())).orElse(false) != false;
    }

    public static IItemHandler getItemHandler(Entity entity) {
        return (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EMPTY_ITEM_HANDLER);
    }

    public static ItemStack findFirstInInventory(@Nullable PlayerEntity player, Item item) {
        return InventoryHelper.findFirstInInventory(player, (ItemStack stack) -> stack.func_77973_b() == item);
    }

    public static ItemStack findFirstInInventory(@Nullable PlayerEntity player, Predicate<ItemStack> predic) {
        if (player != null) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            return IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(predic).findFirst().orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean removeFirstInInventory(PlayerEntity player, Predicate<ItemStack> predic) {
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!predic.test(stack)) continue;
            itemHandler.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static boolean hasEnoughSlots(IItemHandler itemHandler, int count) {
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots() && count > found; ++i) {
            if (!itemHandler.getStackInSlot(i).func_190926_b()) continue;
            ++found;
        }
        return count <= found;
    }

    public static boolean hasAllSlotsEmpty(IItemHandler itemHandler) {
        return IntStream.range(0, itemHandler.getSlots()).allMatch(i -> itemHandler.getStackInSlot(i).func_190926_b());
    }
}

