/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import ovh.corail.tombstone.api.magic.ModDamages;

public enum DamageType implements IStringSerializable
{
    SUFFOCATION,
    BURN,
    LIGHTNING,
    FALL,
    DARKNESS,
    COLD,
    LIGHT,
    UNKNOWN;

    private static final Map<String, DamageType> DAMAGE_STRINGS;
    private final String name = this.name().toLowerCase(Locale.US);

    public boolean is(DamageSource s) {
        return DamageType.of(s) == this;
    }

    public static DamageType of(DamageSource s) {
        if (s.func_76347_k()) {
            return BURN;
        }
        if (s == DamageSource.field_180137_b) {
            return LIGHTNING;
        }
        if (s == DamageSource.field_76369_e || s == DamageSource.field_76368_d || s == DamageSource.field_191291_g || s == DamageSource.field_76366_f) {
            return SUFFOCATION;
        }
        if (s == DamageSource.field_76379_h || s == DamageSource.field_188406_j) {
            return FALL;
        }
        if (s == DamageSource.field_82727_n || s == ModDamages.BEYOND_THE_GRAVE || s == DamageSource.field_188407_q) {
            return DARKNESS;
        }
        String type = s.func_76355_l().toLowerCase(Locale.US);
        return DAMAGE_STRINGS.computeIfAbsent(type, DamageType::fromString);
    }

    private static DamageType fromString(String type) {
        if (DamageType.contains(type, "fire", "fiery", "torched", "heat")) {
            return BURN;
        }
        if (DamageType.contains(type, "lightning", "electr", "discharg")) {
            return LIGHTNING;
        }
        if (DamageType.contains(type, "spore", "poison")) {
            return SUFFOCATION;
        }
        if (DamageType.contains(type, "lich", "haunt", "darkness")) {
            return DARKNESS;
        }
        if (DamageType.contains(type, "fall")) {
            return FALL;
        }
        if (type.startsWith("ice") || DamageType.contains(type, "chill", "frost", "froz", "freez", "snow", "cold")) {
            return COLD;
        }
        return UNKNOWN;
    }

    private static boolean contains(String type, String ... containWords) {
        return Arrays.stream(containWords).anyMatch(type::contains);
    }

    public String func_176610_l() {
        return this.name;
    }

    static {
        DAMAGE_STRINGS = new HashMap<String, DamageType>();
    }
}

