/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import ovh.corail.tombstone.entity.ai.LookAtTradingPlayerGoal;
import ovh.corail.tombstone.entity.ai.TradeWithPlayerGoal;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemLollipop;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class AbstractMerchant
extends CreatureEntity
implements IMerchant {
    private static final DataParameter<Byte> TRADE_LEVEL = EntityDataManager.func_187226_a(AbstractMerchant.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TRADE_XP = EntityDataManager.func_187226_a(AbstractMerchant.class, (IDataSerializer)DataSerializers.field_187192_b);
    @Nullable
    protected PlayerEntity tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    protected long lastRestockGameTime;
    protected TimeHelper.SpecialEvent specialEvent = TimeHelper.SpecialEvent.NONE;
    private boolean updateSeekerRod;
    private static final Int2ObjectMap<VillagerTrades.ITrade[]> TRADES;
    private static final Int2ObjectMap<VillagerTrades.ITrade[]> HALLOWEEN_TRADES;
    private static final Int2ObjectMap<VillagerTrades.ITrade[]> CHRISTMAS_TRADES;

    public AbstractMerchant(EntityType<? extends AbstractMerchant> merchant, World level) {
        super(merchant, level);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRADE_LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(TRADE_XP, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, new TradeWithPlayerGoal<AbstractMerchant>(this));
        this.field_70714_bg.func_75776_a(1, new LookAtTradingPlayerGoal<AbstractMerchant>(this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.tradingPlayer;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null || this.specialEvent != TimeHelper.getSpecialEvent() || !this.updateSeekerRod) {
            this.initTrades();
        }
        return this.offers;
    }

    private void initTrades() {
        this.offers = new MerchantOffers();
        this.specialEvent = TimeHelper.getSpecialEvent();
        this.updateSeekerRod = true;
        this.addBasicTrades(TradeType.COMMON, 5);
        int tradeLevel = this.getTradeLevel();
        if (tradeLevel > 1) {
            this.addBasicTrades(TradeType.UNCOMMON, tradeLevel);
        }
        if (tradeLevel > 3) {
            this.addBasicTrades(TradeType.RARE, tradeLevel - 2);
        }
        if (this.specialEvent == TimeHelper.SpecialEvent.HALLOWEEN) {
            this.addHalloweenTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addHalloweenTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addHalloweenTrades(TradeType.RARE);
            }
        }
        if (this.specialEvent == TimeHelper.SpecialEvent.CHRISTMAS) {
            this.addChristmasTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addChristmasTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addChristmasTrades(TradeType.RARE);
            }
        }
        if (TimeHelper.isDateAroundChristmas() || LocalDate.now().get(ChronoField.MONTH_OF_YEAR) == 2) {
            this.func_213706_dY().add((Object)new TradeForItems(() -> new ItemStack((IItemProvider)ModItems.essence_of_undeath), () -> new ItemStack((IItemProvider)ModItems.christmas_hat), 1, 10).func_221182_a((Entity)this, this.field_70146_Z));
        }
    }

    private void addBasicTrades(TradeType tradeType, int toAdd) {
        Optional.ofNullable(tradeType.getBasicTrades()).filter(trades -> ((VillagerTrades.ITrade[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ITrade[])trades, toAdd));
    }

    private void addHalloweenTrades(TradeType tradeType) {
        Optional.ofNullable(tradeType.getHalloweenTrades()).filter(trades -> ((VillagerTrades.ITrade[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ITrade[])trades, ((VillagerTrades.ITrade[])trades).length));
    }

    private void addChristmasTrades(TradeType tradeType) {
        Optional.ofNullable(tradeType.getChristmasTrades()).filter(trades -> ((VillagerTrades.ITrade[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ITrade[])trades, ((VillagerTrades.ITrade[])trades).length));
    }

    private void addTrades(VillagerTrades.ITrade[] trades, int toAdd) {
        if (toAdd >= trades.length) {
            Arrays.stream(trades).map(trade -> trade.func_221182_a((Entity)this, this.field_70146_Z)).filter(Objects::nonNull).forEach(arg_0 -> this.func_213706_dY().add(arg_0));
        } else {
            List ids = IntStream.range(0, trades.length).boxed().collect(Collectors.toList());
            Collections.shuffle(ids, this.field_70146_Z);
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                MerchantOffer offer = trades[id].func_221182_a((Entity)this, this.field_70146_Z);
                if (offer == null) continue;
                this.func_213706_dY().add((Object)offer);
                if (--toAdd > 0) continue;
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213702_q(int xp) {
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187866_fi : SoundEvents.field_187868_fj, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        if (EntityHelper.isValidServerPlayer(this.tradingPlayer)) {
            boolean isFirstSlot;
            ServerPlayerEntity player = (ServerPlayerEntity)this.tradingPlayer;
            assert (player != null);
            ModTriggers.TRADE_GRAVE_GUARDIAN.trigger(player);
            boolean bl = isFirstSlot = offer.func_222218_a().func_77973_b() == ModItems.lollipop;
            if (isFirstSlot || offer.func_222202_c().func_77973_b() == ModItems.lollipop) {
                ModTriggers.TRADE_LOLLIPOP.trigger(player, (isFirstSlot ? offer.func_222218_a() : offer.func_222202_c()).func_190916_E());
                if (offer.func_222200_d().func_77973_b() == ModItems.essence_of_undeath) {
                    ModTriggers.TRADE_LOLLIPOP_FOR_ESSENCE.trigger(player);
                }
            }
        }
        this.field_70757_a = -this.func_70627_aG();
        boolean isLevelUp = this.increaseLevel(offer.func_222210_n());
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), this.field_70146_Z.nextInt(4) + (isLevelUp ? 8 : 3)));
        }
    }

    private boolean increaseLevel(int offerXp) {
        int tradeLevel = this.getTradeLevel();
        this.setVillagerXp(this.func_213708_dV() + offerXp);
        if (tradeLevel < 5 && this.func_213708_dV() >= VillagerData.func_221127_c((int)tradeLevel)) {
            int newTradeLevel = tradeLevel + 1;
            this.setTradeLevel(newTradeLevel);
            this.initTrades();
            Optional.ofNullable(this.func_70931_l_()).ifPresent(player -> player.func_213818_a(player.field_71070_bA.field_75152_c, this.func_213706_dY(), newTradeLevel, this.func_213708_dV(), this.func_213705_dZ(), this.func_223340_ej()));
            return true;
        }
        return false;
    }

    @Nullable
    public Entity changeDimension(ServerWorld level, ITeleporter teleporter) {
        this.func_70932_a_(null);
        return super.changeDimension(level, teleporter);
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.func_70932_a_(null);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.func_70089_S() && this.tradingPlayer == null) {
            if (hand == Hand.MAIN_HAND && EntityHelper.isValidServerPlayer(player)) {
                ModTriggers.TALK_GRAVE_GUARDIAN.trigger((ServerPlayerEntity)player);
            }
            if (!(this.field_70170_p.field_72995_K || this.func_213706_dY().isEmpty() || EntityHelper.targetAnEnemy((LivingEntity)this))) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), this.getTradeLevel());
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public int func_213708_dV() {
        return (Integer)this.field_70180_af.func_187225_a(TRADE_XP);
    }

    public void setVillagerXp(int tradeXp) {
        this.field_70180_af.func_187227_b(TRADE_XP, (Object)tradeXp);
    }

    public int getTradeLevel() {
        return (Byte)this.field_70180_af.func_187225_a(TRADE_LEVEL) & 0xFF;
    }

    public void setTradeLevel(int tradeLevel) {
        this.field_70180_af.func_187227_b(TRADE_LEVEL, (Object)((byte)tradeLevel));
    }

    public boolean func_213705_dZ() {
        return true;
    }

    public boolean func_223340_ej() {
        return true;
    }

    public void restock() {
        for (MerchantOffer offer : this.func_213706_dY()) {
            boolean hasImpregnatedDiamondB;
            boolean hasImpregnatedDiamondA = offer.func_222218_a().func_77973_b() == ModItems.impregnated_diamond;
            boolean bl = hasImpregnatedDiamondB = offer.func_222202_c().func_77973_b() == ModItems.impregnated_diamond;
            if ((hasImpregnatedDiamondA || hasImpregnatedDiamondB) && (offer.func_222213_g() > 0 || this.field_70146_Z.nextInt(31) == 0)) {
                if (hasImpregnatedDiamondA) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.func_222218_a());
                }
                if (hasImpregnatedDiamondB) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.func_222202_c());
                }
            }
            if (offer.func_222218_a().func_77973_b() == ModItems.lollipop && this.field_70146_Z.nextInt(31) == 0) {
                ModItems.lollipop.setColor(offer.func_222218_a(), ItemLollipop.ModelColor.getRandom());
            }
            offer.func_222203_h();
        }
    }

    public void func_70071_h_() {
        long worldTicks;
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d() && this.tradingPlayer == null && this.func_223340_ej() && TimeHelper.minuteElapsed(worldTicks = TimeHelper.worldTicks(this.field_70170_p), this.lastRestockGameTime) >= 60L) {
            this.lastRestockGameTime = worldTicks + (long)TimeHelper.tickFromHour(1);
            this.restock();
        }
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_190035_gx;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        MerchantOffers offers = this.func_213706_dY();
        if (!offers.isEmpty()) {
            compound.func_218657_a("Offers", (INBT)offers.func_222199_a());
        }
        compound.func_74777_a("special_event", (short)this.specialEvent.ordinal());
        compound.func_74757_a("update_seeker_rod", this.updateSeekerRod);
        compound.func_74774_a("trade_level", ((Byte)this.field_70180_af.func_187225_a(TRADE_LEVEL)).byteValue());
        compound.func_74768_a("trade_xp", this.func_213708_dV());
        compound.func_74772_a("last_restock", this.lastRestockGameTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("special_event", 2)) {
            this.specialEvent = TimeHelper.SpecialEvent.byId(compound.func_74765_d("special_event"));
        } else if (compound.func_150297_b("is_halloween", 1)) {
            this.specialEvent = compound.func_74767_n("is_halloween") ? TimeHelper.SpecialEvent.HALLOWEEN : TimeHelper.SpecialEvent.NONE;
        }
        this.updateSeekerRod = compound.func_74767_n("update_seeker_rod");
        if (compound.func_150297_b("trade_level", 1)) {
            this.setTradeLevel(compound.func_74771_c("trade_level"));
        }
        if (compound.func_150297_b("trade_xp", 3)) {
            this.setVillagerXp(compound.func_74762_e("trade_xp"));
        }
        if (compound.func_150297_b("last_restock", 4)) {
            this.lastRestockGameTime = compound.func_74763_f("last_restock");
        }
    }

    static {
        VillagerTrades.ITrade[] iTradeArray = new VillagerTrades.ITrade[7];
        iTradeArray[0] = new TradeForItems(() -> new ItemStack((IItemProvider)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_slab : ModBlocks.dark_marble_slab), 64), ModItems.tablet_of_recall::createAncient, 1, 10);
        iTradeArray[1] = new TradeForItems(() -> new ItemStack((IItemProvider)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_slab : ModBlocks.dark_marble_slab), 64), ModItems.tablet_of_home::createAncient, 1, 10);
        iTradeArray[2] = new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_205158_fa, 5), () -> ModItems.voodoo_poppet.createWithRandomProtections(6), 1, 10);
        iTradeArray[3] = new TradeForItems(() -> ModItems.impregnated_diamond.impregnate(new ItemStack((IItemProvider)ModItems.impregnated_diamond), TameableType.getRandomSummonableEntityTypeString()), () -> new ItemStack((IItemProvider)ModItems.grave_dust, 30), 1, 10);
        iTradeArray[4] = new TradeForItems(() -> new ItemStack((IItemProvider)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_wall : ModBlocks.dark_marble_wall), 64), () -> new ItemStack((IItemProvider)ModItems.essence_of_undeath), 1, 15);
        iTradeArray[5] = new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_196183_dw, 30), () -> new ItemStack((IItemProvider)ModItems.soul_receptacle), 1, 15);
        iTradeArray[6] = new TradeForItems(() -> {
            ItemStack familiarReceptacle = new ItemStack((IItemProvider)ModItems.familiar_receptacle);
            CompoundNBT deadPetTag = new CompoundNBT();
            deadPetTag.func_74778_a("id", Helper.RANDOM.nextBoolean() ? "minecraft:skeleton_horse" : "minecraft:zombie_horse");
            familiarReceptacle.func_196082_o().func_218657_a("dead_pet", (INBT)deadPetTag);
            return familiarReceptacle;
        }, () -> new ItemStack((IItemProvider)ModItems.essence_of_undeath), 1, 20);
        TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_151103_aS, 10), () -> new ItemStack((IItemProvider)ModItems.grave_dust), 5, 1), new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_151078_bh, 10), () -> new ItemStack((IItemProvider)ModItems.grave_dust), 5, 1), new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_151016_H, 3), () -> new ItemStack((IItemProvider)ModItems.dust_of_vanishing), 5, 1), new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_179556_br), () -> new ItemStack((IItemProvider)ModItems.seeker_rod), 1, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new TradeForItems(() -> new ItemStack((IItemProvider)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_stairs : ModBlocks.dark_marble_stairs), 20), () -> new ItemStack((IItemProvider)ModItems.lost_tablet), 1, 5), new TradeForItems(() -> ModItems.impregnated_diamond.impregnate(new ItemStack((IItemProvider)ModItems.impregnated_diamond), TameableType.getRandomTameableEntityTypeString()), () -> new ItemStack((IItemProvider)ModItems.grave_dust, 12), 1, 5), new TradeForItems(() -> ModItems.impregnated_diamond.impregnate(new ItemStack((IItemProvider)ModItems.impregnated_diamond), TameableType.getRandomTameableEntityTypeString()), () -> new ItemStack((IItemProvider)ModItems.grave_dust, 12), 1, 5), new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_196183_dw), () -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().orElse(new ItemStack((IItemProvider)Items.field_151153_ao)), 3, 5)}, (Object)3, (Object)iTradeArray));
        VillagerTrades.ITrade[] iTradeArray2 = new VillagerTrades.ITrade[4];
        iTradeArray2[0] = new TradeForItems(ModItems.lollipop::getRandom, () -> new ItemStack((IItemProvider)ModItems.grave_dust), 5, 1);
        iTradeArray2[1] = new TradeForItems(ModItems.lollipop::getRandom, () -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().orElse(new ItemStack((IItemProvider)Items.field_185157_bK)), 3, 1);
        iTradeArray2[2] = new TradeForItems(ModItems.lollipop::getRandom, () -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().orElse(new ItemStack((IItemProvider)Items.field_151153_ao)), 3, 1);
        iTradeArray2[3] = new TradeForItems(ModItems.lollipop::getRandom, () -> ModItems.scroll_of_knowledge.createWithXp(100), 5, 1);
        HALLOWEEN_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)iTradeArray2, (Object)2, (Object)new VillagerTrades.ITrade[]{new TradeForItems(() -> ModItems.lollipop.getRandom(5), () -> new ItemStack((IItemProvider)ModItems.lost_tablet), 1, 5), new TradeForItems(() -> ModItems.lollipop.getRandom(10), () -> ModItems.voodoo_poppet.createWithRandomProtections(3), 1, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new TradeForItems(() -> ModItems.lollipop.getRandom(64), () -> new ItemStack((IItemProvider)ModItems.essence_of_undeath), 1, 15), new TradeForItems(() -> ModItems.lollipop.getRandom(20), () -> ModItems.voodoo_poppet.createWithRandomProtections(6), 1, 10)}));
        VillagerTrades.ITrade[] iTradeArray3 = new VillagerTrades.ITrade[4];
        iTradeArray3[0] = new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_151121_aF), () -> new ItemStack((IItemProvider)Items.field_196136_br), () -> new ItemStack((IItemProvider)ModItems.villager_gift), 1, 0);
        iTradeArray3[1] = new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_222068_kQ, 10), ModItems.lollipop::getRandom, 5, 1);
        iTradeArray3[2] = new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_151044_h, 10), ModItems.lollipop::getRandom, 5, 1);
        iTradeArray3[3] = new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_151121_aF, 10), ModItems.lollipop::getRandom, 5, 1);
        CHRISTMAS_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)iTradeArray3, (Object)2, (Object)new VillagerTrades.ITrade[]{new TradeForItems(() -> new ItemStack((IItemProvider)Items.field_221734_cc, 30), () -> new ItemStack((IItemProvider)ModItems.soul_receptacle), 1, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[0]));
    }

    private static class TradeForItems
    implements VillagerTrades.ITrade {
        private final Supplier<ItemStack> requestItem1;
        private final Supplier<ItemStack> requestItem2;
        private final Supplier<ItemStack> rewardItem;
        private final int maxUses;
        private final int villagerXp;

        private TradeForItems(Supplier<ItemStack> requestItem, Supplier<ItemStack> rewardItem, int maxUses, int villagerXp) {
            this(requestItem, () -> ItemStack.field_190927_a, rewardItem, maxUses, villagerXp);
        }

        private TradeForItems(Supplier<ItemStack> requestItem1, Supplier<ItemStack> requestItem2, Supplier<ItemStack> rewardItem, int maxUses, int villagerXp) {
            this.requestItem1 = requestItem1;
            this.requestItem2 = requestItem2;
            this.rewardItem = rewardItem;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            return new MerchantOffer(this.requestItem1.get(), this.requestItem2.get(), this.rewardItem.get(), 0, this.maxUses, this.villagerXp, 0.0f, 0);
        }
    }

    private static enum TradeType {
        COMMON,
        UNCOMMON,
        RARE;


        @Nullable
        private VillagerTrades.ITrade[] getBasicTrades() {
            return (VillagerTrades.ITrade[])TRADES.get(this.ordinal() + 1);
        }

        @Nullable
        private VillagerTrades.ITrade[] getHalloweenTrades() {
            return (VillagerTrades.ITrade[])HALLOWEEN_TRADES.get(this.ordinal() + 1);
        }

        @Nullable
        private VillagerTrades.ITrade[] getChristmasTrades() {
            return (VillagerTrades.ITrade[])CHRISTMAS_TRADES.get(this.ordinal() + 1);
        }
    }
}

