/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.spawner.CustomVillageSiege;

public class CommandTBSiege
extends TombstoneCommand {
    public CommandTBSiege(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbsiege";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(SubCommand.START.literal().executes(this::startSiege))).then(SubCommand.STOP.literal().executes(this::stopSiege));
    }

    private int startSiege(CommandContext<CommandSource> context) {
        CustomVillageSiege villageSiege;
        if (!((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue()) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        CommandSource sender = (CommandSource)context.getSource();
        ServerWorld overworld = sender.func_197028_i().func_241755_D_();
        if (overworld.func_72912_H().func_176130_y() == Difficulty.PEACEFUL) {
            throw LangKey.MESSAGE_DIFFICULTY_PEACEFUL.asCommandException(new Object[0]);
        }
        if (overworld.func_72935_r()) {
            sender.func_197028_i().func_212370_w().forEach(w -> w.func_241114_a_(18001L));
        }
        if (!(villageSiege = this.getVillageSiege(overworld)).startSiege(100)) {
            throw LangKey.MESSAGE_START_SIEGE_FAILED.asCommandException(new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_START_SIEGE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private int stopSiege(CommandContext<CommandSource> context) {
        if (!((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue()) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        CommandSource sender = (CommandSource)context.getSource();
        ServerWorld overworld = sender.func_197028_i().func_241755_D_();
        CustomVillageSiege villageSiege = this.getVillageSiege(overworld);
        boolean stopped = villageSiege.stopSiege();
        List entities = overworld.func_217482_a(EntityType.field_200725_aD, z -> z.getPersistentData().func_74767_n("siege"));
        entities.forEach(Entity::func_70106_y);
        if (!stopped && entities.size() == 0) {
            throw LangKey.MESSAGE_STOP_SIEGE_FAILED.asCommandException(new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_STOP_SIEGE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private CustomVillageSiege getVillageSiege(ServerWorld world) {
        return world.field_241104_N_.stream().filter(CustomVillageSiege.class::isInstance).map(CustomVillageSiege.class::cast).findFirst().orElseThrow(() -> new CommandException((ITextComponent)new StringTextComponent("The spawner for Village Siege wasn't found")));
    }

    private static enum SubCommand implements ISubCommand
    {
        START,
        STOP;

    }
}

