/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.network;

import com.blakebr0.cucumber.network.message.LoginMessage;
import com.blakebr0.cucumber.network.message.Message;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class BaseNetworkHandler {
    private final SimpleChannel channel;
    private int id = 0;

    public BaseNetworkHandler(ResourceLocation id) {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)id, () -> "1.0", s -> true, s -> true);
    }

    public SimpleChannel getChannel() {
        return this.channel;
    }

    public <T extends Message<T>> void register(Class<T> clazz, Message<T> message) {
        this.channel.messageBuilder(clazz, this.id++).encoder(message::write).decoder(message::read).consumer(message::onMessage).add();
    }

    public <T extends LoginMessage<T>> void register(Class<T> clazz, LoginMessage<T> message) {
        this.channel.messageBuilder(clazz, this.id++).encoder(message::write).decoder(message::read).consumer((loginMessage, context) -> {
            BiConsumer<LoginMessage, Supplier> handler = ((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer() ? FMLHandshakeHandler.indexFirst((handshake, msg, ctx) -> message.onMessage(msg, (Supplier<NetworkEvent.Context>)ctx)) : message::onMessage;
            handler.accept((LoginMessage)loginMessage, (Supplier)context);
        }).loginIndex(LoginMessage::getLoginIndex, LoginMessage::setLoginIndex).markAsLoginPacket().add();
    }

    public <M> void sendToServer(M message) {
        this.channel.sendToServer(message);
    }

    public <M> void sendTo(M message, NetworkManager manager, NetworkDirection direction) {
        this.channel.sendTo(message, manager, direction);
    }

    public <M> void send(PacketDistributor.PacketTarget target, M message) {
        this.channel.send(target, message);
    }

    public <M> void reply(M message, NetworkEvent.Context context) {
        this.channel.reply(message, context);
    }
}

