/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class GutterTall
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape TOP_WEST = Block.func_208617_a((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape TOP_EAST = Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0);
    private static final VoxelShape TOP_NORTH = Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)16.0);
    private static final VoxelShape TOP_SOUTH = Block.func_208617_a((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape MIDDLE_WEST = Block.func_208617_a((double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0, (double)17.0);
    private static final VoxelShape MIDDLE_EAST = Block.func_208617_a((double)6.0, (double)0.0, (double)-1.0, (double)10.0, (double)16.0, (double)3.0);
    private static final VoxelShape MIDDLE_NORTH = Block.func_208617_a((double)-1.0, (double)0.0, (double)6.0, (double)3.0, (double)16.0, (double)10.0);
    private static final VoxelShape MIDDLE_SOUTH = Block.func_208617_a((double)13.0, (double)0.0, (double)6.0, (double)17.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0, (double)17.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)6.0, (double)0.0, (double)-1.0, (double)10.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)-1.0, (double)0.0, (double)6.0, (double)3.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)13.0, (double)0.0, (double)6.0, (double)17.0, (double)16.0, (double)10.0);
    private static final VoxelShape WEST = Block.func_208617_a((double)6.0, (double)0.0, (double)9.0, (double)10.0, (double)4.0, (double)17.0);
    private static final VoxelShape EAST = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)7.0);
    private static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)7.0, (double)4.0, (double)10.0);
    private static final VoxelShape SOUTH = Block.func_208617_a((double)9.0, (double)0.0, (double)6.0, (double)17.0, (double)4.0, (double)10.0);
    private static final VoxelShape BOT_WEST = VoxelShapes.func_197872_a((VoxelShape)SHAPE_WEST, (VoxelShape)WEST);
    private static final VoxelShape BOT_EAST = VoxelShapes.func_197872_a((VoxelShape)SHAPE_EAST, (VoxelShape)EAST);
    private static final VoxelShape BOT_NORTH = VoxelShapes.func_197872_a((VoxelShape)SHAPE_NORTH, (VoxelShape)NORTH);
    private static final VoxelShape BOT_SOUTH = VoxelShapes.func_197872_a((VoxelShape)SHAPE_SOUTH, (VoxelShape)SOUTH);
    public static final BooleanProperty ABOVE = BooleanProperty.func_177716_a((String)"above");
    public static final BooleanProperty BELOW = BooleanProperty.func_177716_a((String)"below");
    private static final BooleanProperty WATER = BooleanProperty.func_177716_a((String)"water");

    public GutterTall(BlockState state, AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ABOVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BELOW, (Comparable)Boolean.valueOf(false)));
    }

    private BlockState GutterState(BlockState state, IWorld p_196271_4_, BlockPos pos) {
        boolean above = p_196271_4_.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean below = p_196271_4_.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        return (BlockState)((BlockState)state.func_206870_a((Property)ABOVE, (Comparable)Boolean.valueOf(above))).func_206870_a((Property)BELOW, (Comparable)Boolean.valueOf(below));
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState statetwo, boolean bolean) {
        if (!statetwo.func_203425_a(state.func_177230_c())) {
            this.GutterState(state, (IWorld)world, pos);
        }
    }

    public void setPlacedBy(World world, BlockPos pos, BlockState state, @Nullable Entity entity, ItemStack stack) {
        this.GutterState(state, (IWorld)world, pos);
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState bstate, IWorld world, BlockPos pos, BlockPos postwo) {
        return this.GutterState(state, world, pos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.GutterState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public void placeAt(IWorld world, BlockPos pos, int into) {
        world.func_180501_a(pos, this.func_176223_P(), into);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        boolean above = (Boolean)state.func_177229_b((Property)ABOVE);
        boolean below = (Boolean)state.func_177229_b((Property)BELOW);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                if (!above && !below) {
                    return BOT_WEST;
                }
                if (above && !below) {
                    return BOT_WEST;
                }
                if (!above && below) {
                    return TOP_WEST;
                }
                if (above && below) {
                    return MIDDLE_WEST;
                }
            }
            case EAST: {
                if (!above && !below) {
                    return BOT_EAST;
                }
                if (above && !below) {
                    return BOT_EAST;
                }
                if (!above && below) {
                    return TOP_EAST;
                }
                if (above && below) {
                    return MIDDLE_EAST;
                }
            }
            case SOUTH: {
                if (!above && !below) {
                    return BOT_SOUTH;
                }
                if (above && !below) {
                    return BOT_SOUTH;
                }
                if (!above && below) {
                    return TOP_SOUTH;
                }
                if (above && below) {
                    return MIDDLE_SOUTH;
                }
            }
            case NORTH: {
                if (!above && !below) {
                    return BOT_NORTH;
                }
                if (above && !below) {
                    return BOT_NORTH;
                }
                if (!above && below) {
                    return TOP_NORTH;
                }
                if (!above || !below) break;
                return MIDDLE_NORTH;
            }
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        Boolean i = (Boolean)state.func_177229_b((Property)WATER);
        if (item == Items.field_151131_as && !i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            itemstack.func_190918_g(1);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
        }
        if (item == Items.field_151133_ar && i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            itemstack.func_190918_g(1);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
        }
        if (item == Items.field_151069_bo && i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            player.func_184611_a(hand, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b));
        }
        return ActionResultType.PASS;
    }

    public void onBroken(World worldIn, BlockPos pos) {
        worldIn.func_217379_c(1029, pos, 0);
    }

    protected boolean isRainingday(World world, BlockPos pos) {
        return world.func_175727_C(pos);
    }

    public boolean func_149653_t(BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
            // empty if block
        }
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177981_b(30);
        if (!((Boolean)state.func_177229_b((Property)ABOVE)).booleanValue() || !((Boolean)state.func_177229_b((Property)BELOW)).booleanValue()) {
            if (world.func_175727_C(blockpos) && !((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(true)));
            }
            if (!world.func_175727_C(blockpos) && ((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ABOVE, BELOW, WATER});
    }
}

