/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.util.StructureSearchWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ResourceLocation getKeyForStructure(Structure<?> structure) {
        return ForgeRegistries.STRUCTURE_FEATURES.getKey(structure);
    }

    public static Structure<?> getStructureForKey(ResourceLocation key) {
        return (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(key);
    }

    public static List<Structure<?>> getAllowedStructures() {
        ArrayList structures = new ArrayList();
        for (Structure structure : ForgeRegistries.STRUCTURE_FEATURES) {
            if (structure == null || StructureUtils.getStructureForKey(structure.getRegistryName()) == null || StructureUtils.getKeyForStructure(structure) == null || StructureUtils.structureIsBlacklisted(structure)) continue;
            structures.add(structure);
        }
        return structures;
    }

    public static void searchForStructure(ServerWorld world, PlayerEntity player, ItemStack stack, Structure<?> structure, BlockPos startPos) {
        StructureSearchWorker worker = new StructureSearchWorker(world, player, stack, structure, startPos);
        worker.start();
    }

    public static int getDistanceToStructure(PlayerEntity player, int biomeX, int biomeZ) {
        return StructureUtils.getDistanceToStructure(player.func_233580_cy_(), biomeX, biomeZ);
    }

    public static int getDistanceToStructure(BlockPos startPos, int structureX, int structureZ) {
        return (int)MathHelper.func_76133_a((double)startPos.func_177951_i((Vector3i)new BlockPos(structureX, startPos.func_177956_o(), structureZ)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureName(Structure<?> structure) {
        if (StructureUtils.getKeyForStructure(structure) == null) {
            return "";
        }
        String name = StructureUtils.getKeyForStructure(structure).toString();
        if (((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = I18n.func_135052_a((String)Util.func_200697_a((String)"structure", (ResourceLocation)StructureUtils.getKeyForStructure(structure)), (Object[])new Object[0]);
        }
        if (name.equals(Util.func_200697_a((String)"structure", (ResourceLocation)StructureUtils.getKeyForStructure(structure))) || !((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = StructureUtils.getKeyForStructure(structure).toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureName(ResourceLocation key) {
        return StructureUtils.getStructureName(StructureUtils.getStructureForKey(key));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureSource(Structure<?> structure) {
        if (StructureUtils.getKeyForStructure(structure) == null) {
            return "";
        }
        String registryEntry = StructureUtils.getKeyForStructure(structure).toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static List<ResourceLocation> getStructureDimensions(ServerWorld serverWorld, Structure<?> structure) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        for (ServerWorld world : serverWorld.func_73046_m().func_212370_w()) {
            ChunkGenerator chunkGenerator = world.func_72863_F().func_201711_g();
            if (chunkGenerator.func_235957_b_().func_236197_a_(structure) == null || !chunkGenerator.func_202090_b().func_205004_a(structure)) continue;
            dimensions.add(world.func_234923_W_().func_240901_a_());
        }
        return dimensions;
    }

    public static Map<Structure<?>, List<ResourceLocation>> getDimensionsForAllowedStructures(ServerWorld serverWorld) {
        HashMap dimensionsForAllowedStructures = new HashMap();
        for (Structure<?> structure : StructureUtils.getAllowedStructures()) {
            dimensionsForAllowedStructures.put(structure, StructureUtils.getStructureDimensions(serverWorld, structure));
        }
        return dimensionsForAllowedStructures;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String structureDimensionsToString(List<ResourceLocation> dimensions) {
        String str = "";
        if (dimensions != null && dimensions.size() > 0) {
            str = StructureUtils.getDimensionName(dimensions.get(0));
            for (int i = 1; i < dimensions.size(); ++i) {
                str = str + ", " + StructureUtils.getDimensionName(dimensions.get(i));
            }
        }
        return str;
    }

    public static boolean structureIsBlacklisted(Structure<?> structure) {
        List structureBlacklist = (List)ConfigHandler.GENERAL.structureBlacklist.get();
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getKeyForStructure(structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getDimensionName(ResourceLocation dimensionKey) {
        String name = I18n.func_135052_a((String)Util.func_200697_a((String)"dimension", (ResourceLocation)dimensionKey), (Object[])new Object[0]);
        if (name.equals(Util.func_200697_a((String)"dimension", (ResourceLocation)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    private static String convertToRegex(String glob) {
        String regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? regex + ".*" : (c == '?' ? regex + "." : (c == '.' ? regex + "\\." : regex + c));
        }
        regex = regex + "$";
        return regex;
    }
}

