/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import dev.ftb.mods.ftbranks.impl.TextComponentParser;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.AndCondition;
import dev.ftb.mods.ftbranks.impl.condition.CreativeModeCondition;
import dev.ftb.mods.ftbranks.impl.condition.DimensionCondition;
import dev.ftb.mods.ftbranks.impl.condition.FakePlayerCondition;
import dev.ftb.mods.ftbranks.impl.condition.NotCondition;
import dev.ftb.mods.ftbranks.impl.condition.OPCondition;
import dev.ftb.mods.ftbranks.impl.condition.OrCondition;
import dev.ftb.mods.ftbranks.impl.condition.PlaytimeCondition;
import dev.ftb.mods.ftbranks.impl.condition.RankAddedCondition;
import dev.ftb.mods.ftbranks.impl.condition.SpawnCondition;
import dev.ftb.mods.ftbranks.impl.condition.StatCondition;
import dev.ftb.mods.ftbranks.impl.condition.XorCondition;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.server.ServerWorld;

public class FTBRanksAPIImpl
extends FTBRanksAPI {
    public static RankManagerImpl manager;

    @Override
    public RankManager getManager() {
        return manager;
    }

    public static void serverAboutToStart(MinecraftServer server) {
        manager = new RankManagerImpl(server);
    }

    public static void serverStarted(MinecraftServer server) {
        try {
            manager.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void serverStopped(MinecraftServer server) {
        manager = null;
    }

    public static void worldSaved(ServerWorld event) {
        if (manager != null) {
            manager.saveRanksNow();
            manager.savePlayersNow();
        }
    }

    public static void serverStarting(MinecraftServer server) {
        manager.registerCondition("always_active", (rank, json) -> AlwaysActiveCondition.INSTANCE);
        manager.registerCondition("rank_added", RankAddedCondition::new);
        manager.registerCondition("not", NotCondition::new);
        manager.registerCondition("or", OrCondition::new);
        manager.registerCondition("and", AndCondition::new);
        manager.registerCondition("xor", XorCondition::new);
        manager.registerCondition("op", (rank, tag) -> new OPCondition());
        manager.registerCondition("spawn", (rank, tag) -> new SpawnCondition());
        manager.registerCondition("dimension", (rank, tag) -> new DimensionCondition(tag));
        manager.registerCondition("playtime", (rank, tag) -> new PlaytimeCondition(tag));
        manager.registerCondition("stat", (rank, tag) -> new StatCondition(tag));
        manager.registerCondition("fake_player", (rank, tag) -> new FakePlayerCondition());
        manager.registerCondition("creative_mode", (rank, tag) -> new CreativeModeCondition());
    }

    public static ActionResult<ITextComponent> serverChat(ServerPlayerEntity player, String eventMessage, ITextComponent component) {
        StringTextComponent cachedNameForChat;
        String format = FTBRanksAPI.getPermissionValue(player, "ftbranks.name_format").asString().orElse("");
        if (format.isEmpty()) {
            return ActionResult.func_226250_c_((Object)component);
        }
        StringTextComponent main = new StringTextComponent("");
        try {
            cachedNameForChat = TextComponentParser.parse(format, s -> {
                if (s.equals("name")) {
                    return player.func_145748_c_();
                }
                return null;
            });
        }
        catch (Exception ex) {
            String s2 = "Error parsing " + format + ": " + ex;
            FTBRanks.LOGGER.error(s2);
            cachedNameForChat = new StringTextComponent("BrokenFormatting");
            cachedNameForChat.func_240699_a_(TextFormatting.RED);
            cachedNameForChat.func_230530_a_(cachedNameForChat.func_150256_b().func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(s2))));
        }
        main.func_230529_a_((ITextComponent)cachedNameForChat);
        main.func_240702_b_(" ");
        String message = eventMessage.trim();
        ITextComponent textWithLinks = TextComponentUtils.withLinks((String)message);
        StringTextComponent text = textWithLinks instanceof StringTextComponent ? (StringTextComponent)textWithLinks : new StringTextComponent(message);
        TextFormatting color = TextFormatting.func_96300_b((String)FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.color").asString().orElse(null));
        if (color != null) {
            text.func_230530_a_(text.func_150256_b().func_240721_b_(color));
        }
        if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.bold").asBooleanOrFalse()) {
            text.func_230530_a_(text.func_150256_b().func_240721_b_(TextFormatting.BOLD));
        }
        if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.italic").asBooleanOrFalse()) {
            text.func_230530_a_(text.func_150256_b().func_240721_b_(TextFormatting.ITALIC));
        }
        if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.underlined").asBooleanOrFalse()) {
            text.func_230530_a_(text.func_150256_b().func_240721_b_(TextFormatting.UNDERLINE));
        }
        if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.strikethrough").asBooleanOrFalse()) {
            text.func_230530_a_(text.func_150256_b().func_240721_b_(TextFormatting.STRIKETHROUGH));
        }
        if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.obfuscated").asBooleanOrFalse()) {
            text.func_230530_a_(text.func_150256_b().func_240721_b_(TextFormatting.OBFUSCATED));
        }
        main.func_230529_a_((ITextComponent)text);
        return ActionResult.func_226248_a_((Object)main);
    }
}

