/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import yalter.mousetweaks.Config;
import yalter.mousetweaks.IGuiScreenHandler;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.MouseButton;
import yalter.mousetweaks.Reflection;
import yalter.mousetweaks.WheelSearchOrder;
import yalter.mousetweaks.api.IMTModGuiContainer3;
import yalter.mousetweaks.api.IMTModGuiContainer3Ex;
import yalter.mousetweaks.handlers.GuiContainerCreativeHandler;
import yalter.mousetweaks.handlers.GuiContainerHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer3ExHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer3Handler;

public class Main {
    public static Config config;
    private static Minecraft mc;
    private static IGuiScreenHandler handler;
    private static boolean disableWheelForThisContainer;
    private static Slot oldSelectedSlot;
    private static double accumulatedScrollDelta;
    private static boolean canDoLMBDrag;
    private static boolean canDoRMBDrag;
    private static boolean initialized;

    public static void initialize() {
        Logger.Log("Main.initialize()");
        if (initialized) {
            return;
        }
        mc = Minecraft.func_71410_x();
        config = new Config(Main.mc.field_71412_D + File.separator + "config" + File.separator + "MouseTweaks.cfg");
        config.read();
        Reflection.reflectGuiContainer();
        Logger.Log("Initialized.");
        initialized = true;
    }

    public static void onGuiOpen(Screen newScreen) {
        handler = null;
        oldSelectedSlot = null;
        accumulatedScrollDelta = 0.0;
        canDoLMBDrag = false;
        canDoRMBDrag = false;
        if (newScreen != null) {
            Logger.DebugLog("You have just opened a " + newScreen.getClass().getSimpleName() + ".");
            config.read();
            handler = Main.findHandler(newScreen);
            if (handler == null) {
                Logger.DebugLog("No valid handler found; Mouse Tweaks is disabled.");
            } else {
                boolean disableForThisContainer = handler.isMouseTweaksDisabled();
                disableWheelForThisContainer = handler.isWheelTweakDisabled();
                Logger.DebugLog("Handler: " + handler.getClass().getSimpleName() + "; Mouse Tweaks is " + (disableForThisContainer ? "disabled" : "enabled") + "; wheel tweak is " + (disableWheelForThisContainer ? "disabled" : "enabled") + ".");
                if (disableForThisContainer) {
                    handler = null;
                }
            }
        }
    }

    public static boolean onMouseClicked(double x, double y, MouseButton button) {
        Slot selectedSlot;
        if (handler == null) {
            return false;
        }
        oldSelectedSlot = selectedSlot = handler.getSlotUnderMouse(x, y);
        ItemStack stackOnMouse = Main.mc.field_71439_g.field_71071_by.func_70445_o();
        if (button == MouseButton.LEFT) {
            if (stackOnMouse.func_190926_b()) {
                canDoLMBDrag = true;
            }
        } else if (button == MouseButton.RIGHT) {
            if (stackOnMouse.func_190926_b()) {
                return false;
            }
            if (!Main.config.rmbTweak) {
                return false;
            }
            canDoRMBDrag = true;
            if (selectedSlot != null) {
                Main.rmbTweakNewSlot(selectedSlot, stackOnMouse);
            }
            return true;
        }
        return false;
    }

    private static void rmbTweakNewSlot(Slot selectedSlot, ItemStack stackOnMouse) {
        assert (selectedSlot != null);
        assert (!stackOnMouse.func_190926_b());
        if (handler.isIgnored(selectedSlot)) {
            return;
        }
        if (handler.isCraftingOutput(selectedSlot)) {
            return;
        }
        ItemStack selectedSlotStack = selectedSlot.func_75211_c();
        if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
            return;
        }
        if (selectedSlotStack.func_190916_E() == selectedSlotStack.func_77976_d()) {
            return;
        }
        handler.clickSlot(selectedSlot, MouseButton.RIGHT, false);
    }

    public static boolean onMouseReleased(double x, double y, MouseButton button) {
        if (handler == null) {
            return false;
        }
        if (button == MouseButton.LEFT) {
            canDoLMBDrag = false;
        } else if (button == MouseButton.RIGHT && canDoRMBDrag) {
            canDoRMBDrag = false;
            return true;
        }
        return false;
    }

    public static boolean onMouseDrag(double x, double y, MouseButton button) {
        if (handler == null) {
            return false;
        }
        Slot selectedSlot = handler.getSlotUnderMouse(x, y);
        if (selectedSlot == oldSelectedSlot) {
            return false;
        }
        oldSelectedSlot = selectedSlot;
        if (selectedSlot == null) {
            return false;
        }
        if (handler.isIgnored(selectedSlot)) {
            return false;
        }
        ItemStack stackOnMouse = Main.mc.field_71439_g.field_71071_by.func_70445_o();
        if (button == MouseButton.LEFT) {
            boolean shiftIsDown;
            if (!canDoLMBDrag) {
                return false;
            }
            ItemStack selectedSlotStack = selectedSlot.func_75211_c();
            if (selectedSlotStack.func_190926_b()) {
                return false;
            }
            boolean bl = shiftIsDown = InputMappings.func_216506_a((long)mc.func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)mc.func_228018_at_().func_198092_i(), (int)344);
            if (stackOnMouse.func_190926_b()) {
                if (!Main.config.lmbTweakWithoutItem || !shiftIsDown) {
                    return false;
                }
                handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
            } else {
                if (!Main.config.lmbTweakWithItem) {
                    return false;
                }
                if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                    return false;
                }
                if (shiftIsDown) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                } else {
                    if (stackOnMouse.func_190916_E() + selectedSlotStack.func_190916_E() > stackOnMouse.func_77976_d()) {
                        return false;
                    }
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    if (!handler.isCraftingOutput(selectedSlot)) {
                        handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    }
                }
            }
        } else if (button == MouseButton.RIGHT) {
            if (!canDoRMBDrag) {
                return false;
            }
            if (stackOnMouse.func_190926_b()) {
                return false;
            }
            Main.rmbTweakNewSlot(selectedSlot, stackOnMouse);
        }
        return false;
    }

    public static boolean onMouseScrolled(double x, double y, double scrollDelta) {
        Slot targetSlot;
        ItemStack selectedSlotStack;
        boolean pushItems;
        if (handler == null || disableWheelForThisContainer || !Main.config.wheelTweak) {
            return false;
        }
        Slot selectedSlot = handler.getSlotUnderMouse(x, y);
        if (selectedSlot == null || handler.isIgnored(selectedSlot)) {
            return false;
        }
        double scaledDelta = Main.config.scrollItemScaling.scale(scrollDelta);
        if (accumulatedScrollDelta != 0.0 && Math.signum(scaledDelta) != Math.signum(accumulatedScrollDelta)) {
            accumulatedScrollDelta = 0.0;
        }
        int delta = (int)(accumulatedScrollDelta += scaledDelta);
        accumulatedScrollDelta -= (double)delta;
        if (delta == 0) {
            return true;
        }
        List<Slot> slots = handler.getSlots();
        int numItemsToMove = Math.abs(delta);
        boolean bl = pushItems = delta < 0;
        if (Main.config.wheelScrollDirection.isPositionAware() && Main.otherInventoryIsAbove(selectedSlot, slots)) {
            boolean bl2 = pushItems = !pushItems;
        }
        if (Main.config.wheelScrollDirection.isInverted()) {
            boolean bl3 = pushItems = !pushItems;
        }
        if ((selectedSlotStack = selectedSlot.func_75211_c()).func_190926_b()) {
            return true;
        }
        ItemStack stackOnMouse = Main.mc.field_71439_g.field_71071_by.func_70445_o();
        if (handler.isCraftingOutput(selectedSlot)) {
            if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                return true;
            }
            if (stackOnMouse.func_190926_b()) {
                List<Slot> targetSlots;
                if (!pushItems) {
                    return true;
                }
                while (numItemsToMove-- > 0 && (targetSlots = Main.findPushSlots(slots, selectedSlot, selectedSlotStack.func_190916_E(), true)) != null) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    for (int i = 0; i < targetSlots.size(); ++i) {
                        Slot slot = targetSlots.get(i);
                        if (i == targetSlots.size() - 1) {
                            handler.clickSlot(slot, MouseButton.LEFT, false);
                            continue;
                        }
                        int clickTimes = slot.func_75211_c().func_77976_d() - slot.func_75211_c().func_190916_E();
                        while (clickTimes-- > 0) {
                            handler.clickSlot(slot, MouseButton.RIGHT, false);
                        }
                    }
                }
            } else {
                while (numItemsToMove-- > 0) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                }
            }
            return true;
        }
        if (!stackOnMouse.func_190926_b() && Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
            return true;
        }
        if (pushItems) {
            if (!stackOnMouse.func_190926_b() && !selectedSlot.func_75214_a(stackOnMouse)) {
                return true;
            }
            numItemsToMove = Math.min(numItemsToMove, selectedSlotStack.func_190916_E());
            List<Slot> targetSlots = Main.findPushSlots(slots, selectedSlot, numItemsToMove, false);
            assert (targetSlots != null);
            if (targetSlots.isEmpty()) {
                return true;
            }
            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            for (Slot slot : targetSlots) {
                int clickTimes = slot.func_75211_c().func_77976_d() - slot.func_75211_c().func_190916_E();
                clickTimes = Math.min(clickTimes, numItemsToMove);
                numItemsToMove -= clickTimes;
                while (clickTimes-- > 0) {
                    handler.clickSlot(slot, MouseButton.RIGHT, false);
                }
            }
            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            return true;
        }
        int maxItemsToMove = selectedSlotStack.func_77976_d() - selectedSlotStack.func_190916_E();
        numItemsToMove = Math.min(numItemsToMove, maxItemsToMove);
        while (numItemsToMove > 0 && (targetSlot = Main.findPullSlot(slots, selectedSlot)) != null) {
            int numItemsInTargetSlot = targetSlot.func_75211_c().func_190916_E();
            if (handler.isCraftingOutput(targetSlot)) {
                if (maxItemsToMove < numItemsInTargetSlot) break;
                numItemsToMove = Math.min(numItemsToMove - 1, maxItemsToMove -= numItemsInTargetSlot);
                if (!stackOnMouse.func_190926_b() && !selectedSlot.func_75214_a(stackOnMouse)) break;
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                handler.clickSlot(targetSlot, MouseButton.LEFT, false);
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                continue;
            }
            int numItemsToMoveFromTargetSlot = Math.min(numItemsToMove, numItemsInTargetSlot);
            maxItemsToMove -= numItemsToMoveFromTargetSlot;
            numItemsToMove -= numItemsToMoveFromTargetSlot;
            if (!stackOnMouse.func_190926_b() && !targetSlot.func_75214_a(stackOnMouse)) break;
            handler.clickSlot(targetSlot, MouseButton.LEFT, false);
            if (numItemsToMoveFromTargetSlot == numItemsInTargetSlot) {
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            } else {
                for (int i = 0; i < numItemsToMoveFromTargetSlot; ++i) {
                    handler.clickSlot(selectedSlot, MouseButton.RIGHT, false);
                }
            }
            handler.clickSlot(targetSlot, MouseButton.LEFT, false);
        }
        return true;
    }

    private static boolean otherInventoryIsAbove(Slot selectedSlot, List<Slot> slots) {
        boolean selectedIsInPlayerInventory = selectedSlot.field_75224_c == Main.mc.field_71439_g.field_71071_by;
        for (Slot slot : slots) {
            if (slot.field_75224_c == Main.mc.field_71439_g.field_71071_by == selectedIsInPlayerInventory || slot.field_75221_f >= selectedSlot.field_75221_f) continue;
            return true;
        }
        return false;
    }

    private static IGuiScreenHandler findHandler(Screen currentScreen) {
        if (currentScreen instanceof IMTModGuiContainer3Ex) {
            return new IMTModGuiContainer3ExHandler((IMTModGuiContainer3Ex)currentScreen);
        }
        if (currentScreen instanceof IMTModGuiContainer3) {
            return new IMTModGuiContainer3Handler((IMTModGuiContainer3)currentScreen);
        }
        if (currentScreen instanceof CreativeScreen) {
            return new GuiContainerCreativeHandler((CreativeScreen)currentScreen);
        }
        if (currentScreen instanceof ContainerScreen) {
            return new GuiContainerHandler((ContainerScreen)currentScreen);
        }
        return null;
    }

    private static boolean areStacksCompatible(ItemStack a, ItemStack b) {
        return a.func_190926_b() || b.func_190926_b() || a.func_77969_a(b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private static Slot findPullSlot(List<Slot> slots, Slot selectedSlot) {
        int direction;
        int endIndex;
        int startIndex;
        if (Main.config.wheelSearchOrder == WheelSearchOrder.FIRST_TO_LAST) {
            startIndex = 0;
            endIndex = slots.size();
            direction = 1;
        } else {
            startIndex = slots.size() - 1;
            endIndex = -1;
            direction = -1;
        }
        ItemStack selectedSlotStack = selectedSlot.func_75211_c();
        boolean findInPlayerInventory = selectedSlot.field_75224_c != Main.mc.field_71439_g.field_71071_by;
        for (int i = startIndex; i != endIndex; i += direction) {
            ItemStack stack;
            boolean slotInPlayerInventory;
            Slot slot = slots.get(i);
            if (handler.isIgnored(slot)) continue;
            boolean bl = slotInPlayerInventory = slot.field_75224_c == Main.mc.field_71439_g.field_71071_by;
            if (findInPlayerInventory != slotInPlayerInventory || (stack = slot.func_75211_c()).func_190926_b() || !Main.areStacksCompatible(selectedSlotStack, stack)) continue;
            return slot;
        }
        return null;
    }

    private static List<Slot> findPushSlots(List<Slot> slots, Slot selectedSlot, int itemCount, boolean mustDistributeAll) {
        Slot slot;
        int i;
        ItemStack selectedSlotStack = selectedSlot.func_75211_c();
        boolean findInPlayerInventory = selectedSlot.field_75224_c != Main.mc.field_71439_g.field_71071_by;
        ArrayList<Slot> rv = new ArrayList<Slot>();
        ArrayList<Slot> goodEmptySlots = new ArrayList<Slot>();
        for (i = 0; i != slots.size() && itemCount > 0; ++i) {
            boolean slotInPlayerInventory;
            slot = slots.get(i);
            if (handler.isIgnored(slot)) continue;
            boolean bl = slotInPlayerInventory = slot.field_75224_c == Main.mc.field_71439_g.field_71071_by;
            if (findInPlayerInventory != slotInPlayerInventory || handler.isCraftingOutput(slot)) continue;
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b()) {
                if (!slot.func_75214_a(selectedSlotStack)) continue;
                goodEmptySlots.add(slot);
                continue;
            }
            if (!Main.areStacksCompatible(selectedSlotStack, stack) || stack.func_190916_E() >= stack.func_77976_d()) continue;
            rv.add(slot);
            itemCount -= Math.min(itemCount, stack.func_77976_d() - stack.func_190916_E());
        }
        for (i = 0; i != goodEmptySlots.size() && itemCount > 0; itemCount -= Math.min(itemCount, slot.func_75211_c().func_77976_d() - slot.func_75211_c().func_190916_E()), ++i) {
            slot = (Slot)goodEmptySlots.get(i);
            rv.add(slot);
        }
        if (mustDistributeAll && itemCount > 0) {
            return null;
        }
        return rv;
    }

    static {
        handler = null;
        disableWheelForThisContainer = false;
        oldSelectedSlot = null;
        accumulatedScrollDelta = 0.0;
        canDoLMBDrag = false;
        canDoRMBDrag = false;
        initialized = false;
    }
}

