/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerConfig;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.UnknownPartEvent;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.PartTypeRegistry;
import org.cyclops.integrateddynamics.core.part.PartTypes;

public class PartHelpers {
    public static LazyOptional<IPartContainer> getPartContainer(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, PartContainerConfig.CAPABILITY);
    }

    public static LazyOptional<IPartContainer> getPartContainer(DimPos dimPos, @Nullable Direction side) {
        return TileHelpers.getCapability((DimPos)dimPos, (Direction)side, PartContainerConfig.CAPABILITY);
    }

    public static IPartContainer getPartContainerChecked(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return (IPartContainer)PartHelpers.getPartContainer(world, pos, side).orElseThrow(() -> new IllegalStateException("Could not get a part container"));
    }

    public static IPartContainer getPartContainerChecked(DimPos dimPos, @Nullable Direction side) {
        return (IPartContainer)PartHelpers.getPartContainer(dimPos, side).orElseThrow(() -> new IllegalStateException("Could not find a part container at " + dimPos.toString()));
    }

    public static IPartContainer getPartContainerChecked(PartPos pos) {
        return PartHelpers.getPartContainerChecked(pos.getPos(), pos.getSide());
    }

    public static IPartType validatePartType(INetwork network, String partTypeName, @Nullable IPartType partType) {
        if (network != null && partType == null) {
            UnknownPartEvent event = new UnknownPartEvent(network, partTypeName);
            network.getEventBus().post(event);
            partType = event.getPartType();
        }
        return partType;
    }

    public static void writePartTypeToNBT(CompoundNBT partTag, Direction side, IPartType partType) {
        partTag.func_74778_a("__partType", partType.getUniqueName().toString());
        partTag.func_74778_a("__side", side.func_176610_l());
    }

    public static boolean writePartToNBT(BlockPos pos, CompoundNBT partTag, Pair<Direction, PartStateHolder<?, ?>> partData) {
        IPartType part = ((PartStateHolder)partData.getValue()).getPart();
        Object partState = ((PartStateHolder)partData.getValue()).getState();
        PartHelpers.writePartTypeToNBT(partTag, (Direction)partData.getKey(), part);
        try {
            part.toNBT(partTag, partState);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IntegratedDynamics.clog(Level.ERROR, String.format("The part %s at position %s was errored and is removed.", part.getUniqueName(), pos));
            return false;
        }
    }

    public static void writePartsToNBT(BlockPos pos, CompoundNBT tag, Map<Direction, PartStateHolder<?, ?>> partData) {
        ListNBT partList = new ListNBT();
        Iterator<Map.Entry<Direction, PartStateHolder<?, ?>>> iterator = partData.entrySet().iterator();
        while (iterator.hasNext()) {
            CompoundNBT partTag = new CompoundNBT();
            Map.Entry<Direction, PartStateHolder<?, ?>> entry = iterator.next();
            if (!PartHelpers.writePartToNBT(pos, partTag, Pair.of((Object)entry.getKey(), entry.getValue()))) continue;
            partList.add((Object)partTag);
        }
        tag.func_218657_a("parts", (INBT)partList);
    }

    public static Pair<Direction, IPartType> readPartTypeFromNBT(@Nullable INetwork network, BlockPos pos, CompoundNBT partTag) {
        String partTypeName = partTag.func_74779_i("__partType");
        IPartType partType = PartHelpers.validatePartType(network, partTypeName, PartTypes.REGISTRY.getPartType(new ResourceLocation(partTypeName)));
        if (partType != null) {
            Direction side = Direction.func_176739_a((String)partTag.func_74779_i("__side"));
            if (side != null) {
                return Pair.of((Object)side, (Object)partType);
            }
            IntegratedDynamics.clog(Level.WARN, String.format("The part %s at position %s was at an invalid side and removed.", partType.getUniqueName(), pos));
        } else {
            IntegratedDynamics.clog(Level.WARN, String.format("The part %s at position %s was unknown and removed.", partTypeName, pos));
        }
        return null;
    }

    public static Pair<Direction, ? extends PartStateHolder<?, ?>> readPartFromNBT(@Nullable INetwork network, BlockPos pos, CompoundNBT partTag) {
        Pair<Direction, IPartType> partData = PartHelpers.readPartTypeFromNBT(network, pos, partTag);
        if (partData != null) {
            Object partState = ((IPartType)partData.getValue()).fromNBT(partTag);
            return Pair.of((Object)partData.getKey(), PartStateHolder.of((IPartType)partData.getValue(), partState));
        }
        return null;
    }

    public static void readPartsFromNBT(@Nullable INetwork network, BlockPos pos, CompoundNBT tag, Map<Direction, PartStateHolder<?, ?>> partData, @Nullable World world) {
        ImmutableMap oldPartData = ImmutableMap.copyOf(partData);
        partData.clear();
        ListNBT partList = tag.func_150295_c("parts", 10);
        for (int i = 0; i < partList.size(); ++i) {
            CompoundNBT partTag = partList.func_150305_b(i);
            Pair<Direction, ? extends PartStateHolder<?, ?>> part = PartHelpers.readPartFromNBT(network, pos, partTag);
            if (part == null) continue;
            partData.put((Direction)part.getKey(), (PartStateHolder<?, ?>)part.getValue());
        }
        if (world != null && world.func_201670_d()) {
            boolean triggerBlockRenderUpdate = false;
            for (Direction side : Direction.values()) {
                Object newPartState;
                PartStateHolder oldData = (PartStateHolder)oldPartData.get(side);
                PartStateHolder<?, ?> newData = partData.get(side);
                if (oldData == null && newData == null) continue;
                IPartType oldPartType = oldData != null ? oldData.getPart() : null;
                IPartType<?, ?> newPartType = newData != null ? newData.getPart() : null;
                Object oldPartState = oldData != null ? (Object)oldData.getState() : null;
                Object s = newPartState = newData != null ? (Object)newData.getState() : null;
                if (oldPartType == newPartType && !oldPartType.shouldTriggerBlockRenderUpdate(oldPartState, newPartState)) continue;
                triggerBlockRenderUpdate = true;
                break;
            }
            if (triggerBlockRenderUpdate) {
                BlockHelpers.markForUpdate((World)world, (BlockPos)pos);
            }
        }
    }

    public static boolean removePart(World world, BlockPos pos, Direction side, @Nullable PlayerEntity player, boolean destroyIfEmpty, boolean dropMainElement, boolean saveState) {
        boolean removeCompletely;
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((IBlockReader)world, pos, side);
        ICableFakeable cableFakeable = (ICableFakeable)CableHelpers.getCableFakeable((IBlockReader)world, pos, side).orElse(null);
        partContainer.removePart(side, player, dropMainElement, saveState);
        boolean bl = removeCompletely = destroyIfEmpty && (cableFakeable == null || !cableFakeable.isRealCable()) && !partContainer.hasParts();
        if (removeCompletely) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        } else {
            world.func_195593_d(pos, world.func_180495_p(pos).func_177230_c());
            if (CableHelpers.getCable((IBlockReader)world, pos.func_177972_a(side), side.func_176734_d()).isPresent()) {
                CableHelpers.updateConnections((IBlockReader)world, pos, side);
                CableHelpers.updateConnections((IBlockReader)world, pos.func_177972_a(side), side.func_176734_d());
                NetworkHelpers.initNetwork(world, pos, side);
            }
        }
        return !removeCompletely;
    }

    public static boolean addPart(World world, BlockPos pos, Direction side, IPartType partType, ItemStack itemStack) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((IBlockReader)world, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!world.func_201670_d()) {
                partContainer.setPart(side, partType, partType.getState(itemStack));
            }
            return true;
        }
        return false;
    }

    public static boolean addPart(World world, BlockPos pos, Direction side, IPartType partType, IPartState partState) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((IBlockReader)world, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!world.func_201670_d()) {
                partContainer.setPart(side, partType, partState);
            }
            return true;
        }
        return false;
    }

    public static boolean setPart(@Nullable INetwork network, World world, BlockPos pos, Direction side, IPartType part, IPartState partState, IPartStateHolderCallback callback) {
        callback.onSet(PartStateHolder.of(part, partState));
        if (network != null) {
            IPartContainer partContainer = PartHelpers.getPartContainerChecked((IBlockReader)world, pos, side);
            INetworkElement networkElement = part.createNetworkElement(partContainer, DimPos.of((World)world, (BlockPos)pos), side);
            if (!network.addNetworkElement(networkElement, false)) {
                partState = part.getDefaultState();
                callback.onSet(PartStateHolder.of(part, partState));
                IntegratedDynamics.clog(Level.WARN, "A part already existed in the network, this is possibly a result from item duplication.");
                network.addNetworkElement(networkElement, false);
            }
            return true;
        }
        return false;
    }

    public static boolean canInteractWith(PartTarget target, PlayerEntity player, IPartContainer expectedPartContainer) {
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer(target.getCenter().getPos(), target.getCenter().getSide()).orElse(null);
        return partContainer == expectedPartContainer;
    }

    @Nullable
    public static PartStateHolder<?, ?> getPart(PartPos partPos) {
        Direction side = partPos.getSide();
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer(partPos.getPos(), partPos.getSide()).orElse(null);
        if (partContainer != null && partContainer.hasPart(side)) {
            return PartStateHolder.of(partContainer.getPart(side), partContainer.getPartState(side));
        }
        return null;
    }

    public static ActionResultType openContainerPart(ServerPlayerEntity player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProvider(pos).map(containerProvider -> {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> partType.writeExtraGuiData((PacketBuffer)packetBuffer, pos, player));
            return ActionResultType.SUCCESS;
        }).orElse(ActionResultType.PASS);
    }

    public static boolean openContainerPartSettings(ServerPlayerEntity player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProviderSettings(pos).map(containerProvider -> {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> partType.writeExtraGuiDataSettings((PacketBuffer)packetBuffer, pos, player));
            return true;
        }).orElse(false);
    }

    public static void openContainerAspectSettings(ServerPlayerEntity player, PartPos pos, IAspect<?, ?> aspect) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)aspect.getPropertiesContainerProvider(pos), packetBuffer -> packetBuffer.func_180714_a(aspect.getUniqueName().toString()));
    }

    public static Triple<IPartContainer, PartTypeBase, PartTarget> getContainerPartConstructionData(PartPos pos) {
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer(pos.getPos(), pos.getSide()).orElse(null);
        if (partContainer == null) {
            IntegratedDynamics.clog(Level.WARN, String.format("The tile at %s is not a valid part container.", pos));
            return null;
        }
        IPartType partType = partContainer.getPart(pos.getSide());
        if (partType == null || !(partType instanceof PartTypeBase)) {
            IntegratedDynamics.clog(Level.WARN, String.format("The part container at %s side %s does not have a valid part.", pos, pos.getSide()));
            return null;
        }
        PartTarget target = partType.getTarget(pos, partContainer.getPartState(pos.getSide()));
        return Triple.of((Object)partContainer, (Object)((PartTypeBase)partType), (Object)target);
    }

    public static PartTarget readPartTarget(PacketBuffer packetBuffer) {
        return PartTarget.fromCenter((PartPos)PacketCodec.read((PacketBuffer)packetBuffer, PartPos.class));
    }

    public static <P extends IPartType<P, S>, S extends IPartState<P>> P readPart(PacketBuffer packetBuffer) {
        String name = packetBuffer.func_218666_n();
        return (P)Objects.requireNonNull(PartTypeRegistry.getInstance().getPartType(new ResourceLocation(name)), String.format("Could not find a part by name %s", name));
    }

    public static interface IPartStateHolderCallback {
        public void onSet(PartStateHolder<?, ?> var1);
    }

    public static class PartStateHolder<P extends IPartType<P, S>, S extends IPartState<P>> {
        private final IPartType<P, S> part;
        private final S state;

        public static PartStateHolder<?, ?> of(IPartType part, IPartState partState) {
            return new PartStateHolder(part, partState);
        }

        @ConstructorProperties(value={"part", "state"})
        public PartStateHolder(IPartType<P, S> part, S state) {
            this.part = part;
            this.state = state;
        }

        public IPartType<P, S> getPart() {
            return this.part;
        }

        public S getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartStateHolder)) {
                return false;
            }
            PartStateHolder other = (PartStateHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPartType<P, S> this$part = this.getPart();
            IPartType<P, S> other$part = other.getPart();
            if (this$part == null ? other$part != null : !this$part.equals(other$part)) {
                return false;
            }
            S this$state = this.getState();
            S other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartStateHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPartType<P, S> $part = this.getPart();
            result = result * 59 + ($part == null ? 0 : $part.hashCode());
            S $state = this.getState();
            result = result * 59 + ($state == null ? 0 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "PartHelpers.PartStateHolder(part=" + this.getPart() + ", state=" + this.getState() + ")";
        }
    }
}

