/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyMaterialized;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeListLPElement;

public class ValueTypeList
extends ValueObjectTypeBase<ValueList> {
    public static final int MAX_RENDER_LINES = 20;

    public ValueTypeList() {
        super("list", Helpers.RGBToInt((int)175, (int)3, (int)1), TextFormatting.DARK_RED, ValueList.class);
    }

    @Override
    public ValueList getDefault() {
        return ValueList.ofList(ValueTypes.CATEGORY_ANY, Collections.emptyList());
    }

    @Override
    public IFormattableTextComponent toCompactString(ValueList value) {
        return value.getRawValue().toCompactString();
    }

    @Override
    public INBT serialize(ValueList value) {
        try {
            return ValueTypeListProxyFactories.REGISTRY.serialize(value.getRawValue());
        }
        catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
            e.printStackTrace();
            return new CompoundNBT();
        }
    }

    @Override
    public ITextComponent canDeserialize(INBT value) {
        try {
            Object proxy = ValueTypeListProxyFactories.REGISTRY.deserialize(value);
            return null;
        }
        catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
            return new TranslationTextComponent(e.getMessage());
        }
    }

    @Override
    public ValueList deserialize(INBT value) {
        if (!(value.func_74732_a() == 0 || value.func_74732_a() == 10 && ((CompoundNBT)value).isEmpty())) {
            try {
                Object proxy = ValueTypeListProxyFactories.REGISTRY.deserialize(value);
                return ValueList.ofFactory(proxy);
            }
            catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
                e.printStackTrace();
            }
        }
        return this.getDefault();
    }

    @Override
    public ValueList materialize(ValueList value) throws EvaluationException {
        IValueTypeListProxy list = value.getRawValue();
        if (list.isInfinite()) {
            return ValueList.ofList(list.getValueType(), Lists.newArrayList((Object[])new IValue[]{list.get(0)}));
        }
        ImmutableList values = ImmutableList.copyOf(list);
        return ValueList.ofList(list.getValueType(), values);
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeListLPElement();
    }

    @Override
    public ValuePredicate<ValueList> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        JsonElement jsonElement = element.get("infinite_list");
        Boolean infinite = null;
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            infinite = JSONUtils.func_151216_b((JsonElement)jsonElement, (String)"infinite_list");
        }
        return new ValueListPredicate(this, value, infinite);
    }

    public static class ValueListPredicate
    extends ValuePredicate<ValueList> {
        private final Boolean infinite;

        public ValueListPredicate(@Nullable IValueType valueType, @Nullable IValue value, @Nullable Boolean infinite) {
            super(valueType, value);
            this.infinite = infinite;
        }

        @Override
        protected boolean testTyped(ValueList value) {
            return super.testTyped(value) && (this.infinite == null || value.getRawValue().isInfinite() == this.infinite.booleanValue());
        }
    }

    public static class ListFactoryIterator<T extends IValueType<V>, V extends IValue>
    implements Iterator<V> {
        private final IValueTypeListProxy<T, V> value;
        private int index = 0;
        private int length;

        public ListFactoryIterator(IValueTypeListProxy<T, V> value) {
            this.value = value;
            try {
                this.length = this.value.getLength();
            }
            catch (EvaluationException e) {
                this.length = 0;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public V next() {
            try {
                return this.value.get(this.index++);
            }
            catch (EvaluationException e) {
                e.printStackTrace();
                return this.value.getValueType().getDefault();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class ValueList<T extends IValueType<V>, V extends IValue>
    extends ValueBase {
        private final IValueTypeListProxy<T, V> value;

        private ValueList(IValueTypeListProxy<T, V> value) {
            super(ValueTypes.LIST);
            this.value = value;
        }

        public static <T extends IValueType<V>, V extends IValue> ValueList ofList(T valueType, List<V> values) {
            return new ValueList<T, V>(new ValueTypeListProxyMaterialized<T, V>(valueType, values));
        }

        public static <V extends IValue> ValueList ofAll(V ... values) {
            return values.length == 0 ? ValueTypes.LIST.getDefault() : ValueList.ofList(values[0].getType(), ImmutableList.copyOf((Object[])values));
        }

        public static <V extends IValue> ValueList ofAll(IValueType type, V ... values) {
            return ValueList.ofList(type, ImmutableList.copyOf((Object[])values));
        }

        public static <T extends IValueType<V>, V extends IValue> ValueList ofFactory(IValueTypeListProxy<T, V> proxy) {
            return new ValueList<T, V>(proxy);
        }

        public IValueTypeListProxy<T, V> getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueList && ((ValueList)o).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeList.ValueList(value=" + this.value + ")";
        }
    }
}

