/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMechanicalMachine;

public abstract class ContainerScreenMechanicalMachine<C extends ContainerMechanicalMachine<?>>
extends ContainerScreenExtended<C> {
    public ContainerScreenMechanicalMachine(C container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    public void drawEnergyBarTooltip(int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((ContainerScreen)this, (int)8, (int)16, (int)18, (int)60, (int)mouseX, (int)mouseY, () -> {
            int energyStored = ((ContainerMechanicalMachine)this.func_212873_a_()).getEnergy();
            int energyMax = ((ContainerMechanicalMachine)this.func_212873_a_()).getMaxEnergy();
            if (energyMax > 0) {
                return Optional.of(Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("general.integrateddynamics.energy"), Helpers.getLocalizedEnergyLevel(energyStored, energyMax)}));
            }
            return Optional.empty();
        });
    }

    public void drawFluidTankTooltip(FluidStack fluidStack, int fluidCapacity, int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((ContainerScreen)this, (int)x, (int)y, (int)width, (int)height, (int)mouseX, (int)mouseY, () -> {
            if (!fluidStack.isEmpty()) {
                ITextComponent fluidName = fluidStack.getDisplayName();
                return Optional.of(Lists.newArrayList((Object[])new ITextComponent[]{fluidName, DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)fluidStack.getAmount(), (int)fluidCapacity)}));
            }
            return Optional.empty();
        });
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }
}

