/*
 * Decompiled with CFR 0.152.
 */
package com.minttea.minecraft.tomeofblood.common.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IntangibleAirTile;
import com.hollingsworth.arsnouveau.common.block.tile.PhantomBlockTile;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenSpellBook;
import com.minttea.minecraft.tomeofblood.client.renderer.item.SpellTomeRenderer;
import com.minttea.minecraft.tomeofblood.common.items.BloodSpellResolver;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodTome
extends SpellBook {
    private static final Logger LOGGER = LogManager.getLogger();

    public BloodTome(ISpellTier.Tier tier) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ArsNouveau.itemGroup).setISTER(() -> SpellTomeRenderer::new), tier);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!stack.func_77942_o()) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        RayTraceResult result = playerIn.func_213324_a(5.0, 0.0f, false);
        if (result instanceof BlockRayTraceResult && worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof ScribesTile) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (result instanceof BlockRayTraceResult && !playerIn.func_225608_bj_() && worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) != null && !(worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof IntangibleAirTile) && !(worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof PhantomBlockTile)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (worldIn.field_72995_K || !stack.func_77942_o()) {
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        if (BloodTome.getMode((CompoundNBT)stack.func_77978_p()) == 0 && playerIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketOpenSpellBook(stack.func_77978_p(), this.getTier().ordinal(), BloodTome.getUnlockedSpellString((CompoundNBT)player.func_184586_b(handIn).func_77978_p())));
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        BloodSpellResolver resolver = new BloodSpellResolver(new SpellContext(this.getCurrentRecipe(stack), (LivingEntity)playerIn).withColors(SpellBook.getSpellColor((CompoundNBT)stack.func_77978_p(), (int)SpellBook.getMode((CompoundNBT)stack.func_77978_p()))));
        EntityRayTraceResult entityRes = MathUtil.getLookedAtEntity((LivingEntity)playerIn, (int)25);
        if (entityRes != null && entityRes.func_216348_a() instanceof LivingEntity) {
            resolver.onCastOnEntity(stack, (LivingEntity)playerIn, entityRes.func_216348_a(), handIn);
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            ItemUseContext context = new ItemUseContext(playerIn, handIn, (BlockRayTraceResult)result);
            resolver.onCastOnBlock(context);
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        resolver.onCast(stack, (LivingEntity)playerIn, worldIn);
        return new ActionResult(ActionResultType.CONSUME, (Object)stack);
    }

    public boolean shouldDisplay(ItemStack stack) {
        return false;
    }
}

