/*
 * Decompiled with CFR 0.152.
 */
package com.minttea.minecraft.tomeofblood.common.items;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class BloodSpellResolver
extends SpellResolver {
    private final ISpellValidator spellValidator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();

    public BloodSpellResolver(SpellContext spellContext) {
        super(spellContext);
    }

    public boolean canCast(LivingEntity entity) {
        List validationErrors = this.spellValidator.validate(this.spell.recipe);
        if (validationErrors.isEmpty()) {
            return this.enoughMana(entity);
        }
        if (!this.silent && entity.func_70613_aW()) {
            PortUtil.sendMessageCenterScreen((Entity)entity, (ITextComponent)((SpellValidationError)validationErrors.get(0)).makeTextComponentExisting());
        }
        return false;
    }

    private boolean enoughMana(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player.func_184812_l_()) {
                return true;
            }
            int totalCost = this.getCastingCost(this.spell, (LivingEntity)player);
            SoulNetwork soulNetwork = NetworkHelper.getSoulNetwork((UUID)player.func_110124_au());
            int pool = soulNetwork.getCurrentEssence();
            if (pool < this.getCastingCost(this.spell, entity)) {
                PortUtil.sendMessageCenterScreen((Entity)player, (ITextComponent)new TranslationTextComponent("toomanytomes.alert.lack_lp"));
                return true;
            }
            return true;
        }
        return false;
    }

    public void expendMana(LivingEntity entity) {
        PlayerEntity player;
        if (entity instanceof PlayerEntity && !(player = (PlayerEntity)entity).func_184812_l_()) {
            int totalCost = this.getCastingCost(this.spell, (LivingEntity)player);
            SoulNetwork soulNetwork = NetworkHelper.getSoulNetwork((UUID)player.func_110124_au());
            SoulTicket ticket = new SoulTicket((ITextComponent)new StringTextComponent("Spell cast"), totalCost);
            soulNetwork.syphonAndDamage(player, ticket);
        }
    }
}

