/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.worldentity;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.brandonscore.worldentity.WorldEntityType;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class WorldEntity {
    private WorldEntityType<?> worldEntityType;
    protected final Random rand = new Random();
    private UUID uniqueID = MathHelper.func_180182_a((Random)this.rand);
    protected World world;
    protected boolean removed;

    protected WorldEntity(WorldEntityType<?> worldEntityType) {
        this.worldEntityType = worldEntityType;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public WorldEntityType<?> getType() {
        return this.worldEntityType;
    }

    public UUID getUniqueID() {
        return this.uniqueID;
    }

    public void onLoad() {
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void removeEntity() {
        this.removed = true;
        WorldEntityHandler.onEntityRemove(this);
    }

    public void read(CompoundNBT nbt) {
        this.readInternal(nbt);
    }

    public void write(CompoundNBT nbt) {
        this.writeInternal(nbt);
    }

    private void writeInternal(CompoundNBT nbt) {
        ResourceLocation resourcelocation = WorldEntityType.getId(this.getType());
        if (resourcelocation == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbt.func_74778_a("id", resourcelocation.toString());
        nbt.func_186854_a("UUID", this.getUniqueID());
    }

    private void readInternal(CompoundNBT nbt) {
        if (nbt.func_186855_b("UUID")) {
            this.uniqueID = nbt.func_186857_a("UUID");
        }
    }

    @Nullable
    public static WorldEntity readWorldEntity(CompoundNBT nbt) {
        String id = nbt.func_74779_i("id");
        return Optional.ofNullable(WorldEntityHandler.REGISTRY.getValue(new ResourceLocation(id))).map(e -> {
            try {
                return e.create();
            }
            catch (Throwable throwable) {
                LogHelperBC.error("Failed to create world entity {}", id, throwable);
                return null;
            }
        }).map(e -> {
            try {
                e.read(nbt);
                return e;
            }
            catch (Throwable throwable) {
                LogHelperBC.error("Failed to load data for world entity {}", id, throwable);
                return null;
            }
        }).orElseGet(() -> {
            LogHelperBC.warn("Skipping WorldEntity with id {}", id);
            return null;
        });
    }
}

