/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.packet.PacketCustomChannelBuilder;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.ClientPacketHandler;
import com.brandon3055.brandonscore.network.ServerPacketHandler;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BCoreNetwork {
    public static final ResourceLocation CHANNEL = new ResourceLocation("brandonscore:network");
    public static EventNetworkChannel netChannel;
    public static final int C_TILE_DATA_MANAGER = 1;
    public static final int C_TILE_MESSAGE = 2;
    public static final int C_SERVER_CONFIG_SYNC = 3;
    public static final int C_NO_CLIP = 4;
    public static final int C_PLAYER_ACCESS = 5;
    public static final int C_PLAYER_ACCESS_UPDATE = 6;
    public static final int C_INDEXED_MESSAGE = 7;
    public static final int C_TILE_CAP_DATA = 8;
    public static final int C_PLAY_SOUND = 9;
    public static final int C_SPAWN_ENTITY = 10;
    public static final int C_SPAWN_PARTICLE = 11;
    public static final int C_ENTITY_VELOCITY = 12;
    public static final int C_OPEN_HUD_CONFIG = 13;
    public static final int S_TILE_MESSAGE = 1;
    public static final int S_PLAYER_ACCESS_BUTTON = 2;
    public static final int S_TILE_DATA_MANAGER = 3;

    public static void sendConfigToClient(ServerPlayerEntity player) {
        PacketCustom packet = new PacketCustom(CHANNEL, 3);
        packet.sendToPlayer(player);
        LogHelperBC.dev("Sending Config To Client: " + player);
    }

    public static void sendNoClip(ServerPlayerEntity player, boolean enabled) {
        PacketCustom packet = new PacketCustom(CHANNEL, 3);
        packet.writeBoolean(enabled);
        packet.sendToPlayer(player);
        LogHelperBC.dev("Sending NoClip update to player: " + player + " Enabled: " + enabled);
    }

    public static void sendOpenPlayerAccessUI(ServerPlayerEntity player, int windowID) {
        PacketCustom packet = new PacketCustom(CHANNEL, 5);
        packet.writeInt(windowID);
        packet.sendToPlayer(player);
    }

    public static void sendPlayerAccessUIUpdate(ServerPlayerEntity player, PlayerEntity target) {
        PacketCustom packet = new PacketCustom(CHANNEL, 6);
        packet.writeString(target.func_146103_bH().getName());
        packet.writePos(target.func_233580_cy_());
    }

    public static void sendPlayerAccessButton(int button) {
        PacketCustom packet = new PacketCustom(CHANNEL, 2);
        packet.writeByte(button);
        packet.sendToServer();
    }

    public static void sendIndexedMessage(ServerPlayerEntity player, ITextComponent message, int index) {
        PacketCustom packet = new PacketCustom(CHANNEL, 7);
        packet.writeTextComponent(message);
        packet.writeInt(index);
        packet.sendToPlayer(player);
    }

    public static void sendSound(World world, int x, int y, int z, SoundEvent sound, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        BCoreNetwork.sendSound(world, new BlockPos(x, y, z), sound, category, volume, pitch, distanceDelay);
    }

    public static void sendSound(World world, Entity entity, SoundEvent sound, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        BCoreNetwork.sendSound(world, entity.func_233580_cy_(), sound, category, volume, pitch, distanceDelay);
    }

    public static void sendSound(World world, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        if (!world.field_72995_K) {
            PacketCustom packet = new PacketCustom(CHANNEL, 9);
            packet.writePos(pos);
            packet.writeRegistryId((IForgeRegistryEntry)sound);
            packet.writeVarInt(category.ordinal());
            packet.writeFloat(volume);
            packet.writeFloat(pitch);
            packet.writeBoolean(distanceDelay);
            packet.sendToChunk(world, pos);
        }
    }

    public static void sendParticle(World world, IParticleData particleData, Vector3 pos, Vector3 motion, boolean distanceOverride) {
        if (!world.field_72995_K) {
            PacketCustom packet = new PacketCustom(CHANNEL, 11);
            packet.writeRegistryId((IForgeRegistryEntry)particleData.func_197554_b());
            particleData.func_197553_a(packet.toPacketBuffer());
            packet.writeVector(pos);
            packet.writeVector(motion);
            packet.writeBoolean(distanceOverride);
            packet.sendToChunk(world, pos.pos());
        }
    }

    public static IPacket<?> getEntitySpawnPacket(Entity entity) {
        PacketCustom packet = new PacketCustom(CHANNEL, 10);
        packet.writeVarInt(Registry.field_212629_r.func_148757_b((Object)entity.func_200600_R()));
        packet.writeInt(entity.func_145782_y());
        packet.writeUUID(entity.func_110124_au());
        packet.writeDouble(entity.func_226277_ct_());
        packet.writeDouble(entity.func_226278_cu_());
        packet.writeDouble(entity.func_226281_cx_());
        packet.writeByte((int)((byte)MathHelper.func_76141_d((float)(entity.field_70125_A * 256.0f / 360.0f))));
        packet.writeByte((int)((byte)MathHelper.func_76141_d((float)(entity.field_70177_z * 256.0f / 360.0f))));
        packet.writeByte((int)((byte)(entity.func_70079_am() * 256.0f / 360.0f)));
        Vector3d velocity = entity.func_213322_ci();
        packet.writeFloat((float)velocity.field_72450_a);
        packet.writeFloat((float)velocity.field_72448_b);
        packet.writeFloat((float)velocity.field_72449_c);
        return packet.toPacket(NetworkDirection.PLAY_TO_CLIENT);
    }

    public static IPacket<?> sendEntityVelocity(Entity entity, boolean movement) {
        PacketCustom packet = new PacketCustom(CHANNEL, 12);
        packet.writeInt(entity.func_145782_y());
        packet.writeVec3f(new Vector3f(entity.func_213322_ci()));
        packet.writeBoolean(movement);
        if (movement) {
            packet.writeFloat(entity.field_70125_A);
            packet.writeFloat(entity.field_70177_z);
            packet.writeBoolean(entity.func_233570_aj_());
        }
        return packet.toPacket(NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendOpenHudConfig(ServerPlayerEntity player) {
        new PacketCustom(CHANNEL, 13).sendToPlayer(player);
    }

    public static void init() {
        netChannel = PacketCustomChannelBuilder.named((ResourceLocation)CHANNEL).networkProtocolVersion(() -> "1").clientAcceptedVersions(e -> true).serverAcceptedVersions(e -> true).assignClientHandler(() -> ClientPacketHandler::new).assignServerHandler(() -> ServerPacketHandler::new).build();
    }
}

