/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class FilterItem
extends FilterBase {
    protected boolean whitelistItem = true;
    protected String itemName = "";
    protected int count = 0;
    protected int damage = -1;
    protected CompoundNBT nbt = null;
    protected boolean filterBlocks = false;
    protected boolean filterItems = false;
    public boolean dataChanged = false;

    public FilterItem(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistItem(boolean whitelistItem) {
        boolean prev = this.whitelistItem;
        this.whitelistItem = whitelistItem;
        this.getFilter().nodeModified(this);
        this.whitelistItem = prev;
    }

    public boolean isWhitelistItem() {
        return this.whitelistItem;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
        this.getFilter().nodeModified(this);
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setCount(int count) {
        this.count = count;
        this.getFilter().nodeModified(this);
    }

    public int getCount() {
        return this.count;
    }

    public void setDamage(int damage) {
        this.damage = damage;
        this.getFilter().nodeModified(this);
    }

    public int getDamage() {
        return this.damage;
    }

    public void setNbt(CompoundNBT nbt) {
        this.nbt = nbt;
        if (nbt != null && nbt.isEmpty()) {
            this.nbt = null;
        }
        this.getFilter().nodeModified(this);
    }

    public CompoundNBT getNbt() {
        return this.nbt;
    }

    public boolean isFilterBlocks() {
        return this.filterBlocks;
    }

    public void setFilterItemsBlocks(boolean filterItems, boolean filterBlocks) {
        boolean prev = this.filterItems;
        boolean prevBlocks = this.filterBlocks;
        this.filterItems = filterItems;
        this.filterBlocks = filterBlocks;
        this.getFilter().nodeModified(this);
        this.filterItems = prev;
        this.filterBlocks = prevBlocks;
    }

    public boolean isFilterItems() {
        return this.filterItems;
    }

    @Override
    public boolean test(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemStack stack = ((ItemEntity)entity).func_92059_d();
            if (stack.func_190926_b()) {
                return !this.whitelistItem;
            }
            boolean match = true;
            if (!this.itemName.isEmpty()) {
                if (this.itemName.contains(":")) {
                    String name = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString();
                    match = name.equals(this.itemName);
                } else {
                    Collection tags = ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b());
                    match = false;
                    for (ResourceLocation tag : tags) {
                        if (!tag.toString().equals(this.itemName)) continue;
                        match = true;
                        break;
                    }
                }
            }
            if (match && this.count > 0) {
                boolean bl = match = stack.func_190916_E() == this.count;
            }
            if (match && this.damage != -1) {
                boolean bl = match = stack.func_77952_i() == this.damage;
            }
            if (match && this.nbt != null) {
                match = this.nbt.equals((Object)stack.func_77978_p());
            }
            if (this.itemName.isEmpty()) {
                if (this.filterBlocks) {
                    match = stack.func_77973_b() instanceof BlockItem;
                } else if (this.filterItems) {
                    match = !(stack.func_77973_b() instanceof BlockItem);
                }
            }
            return match == this.whitelistItem;
        }
        return !this.whitelistItem;
    }

    @Override
    public FilterType getType() {
        return FilterType.ITEM_FILTER;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("include", this.whitelistItem);
        compound.func_74778_a("name", this.itemName);
        compound.func_74777_a("count", (short)this.count);
        compound.func_74777_a("damage", (short)this.count);
        compound.func_74757_a("items", this.filterItems);
        compound.func_74757_a("blocks", this.filterBlocks);
        if (this.nbt != null) {
            compound.func_218657_a("nbt", (INBT)this.nbt);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.whitelistItem = compound.func_74767_n("include");
        this.itemName = compound.func_74779_i("name");
        this.count = compound.func_74765_d("count");
        this.damage = compound.func_74765_d("damage");
        this.filterItems = compound.func_74767_n("items");
        this.filterBlocks = compound.func_74767_n("blocks");
        this.nbt = null;
        if (compound.func_150297_b("nbt", 10)) {
            this.nbt = compound.func_74775_l("nbt");
        }
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistItem);
        output.writeString(this.itemName);
        output.writeVarInt(this.count);
        output.writeVarInt(this.damage);
        output.writeBoolean(this.filterItems);
        output.writeBoolean(this.filterBlocks);
        output.writeCompoundNBT(this.nbt);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistItem = input.readBoolean();
        this.itemName = input.readString();
        this.count = input.readVarInt();
        this.damage = input.readVarInt();
        this.filterItems = input.readBoolean();
        this.filterBlocks = input.readBoolean();
        this.nbt = input.readCompoundNBT();
        this.dataChanged = true;
    }
}

