/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ManagedVector3
extends AbstractManagedData<Vector3> {
    private Vector3 value;
    private Vector3 defaultValue;
    protected Function<Vector3, Vector3> validator = null;

    public ManagedVector3(String name, @Nullable Vector3 defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.defaultValue = defaultValue == null ? null : defaultValue.copy();
    }

    public ManagedVector3(String name, DataFlags ... flags) {
        this(name, new Vector3(), flags);
    }

    public Vector3 set(Vector3 value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            Vector3 prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public Vector3 get() {
        return this.value;
    }

    public ManagedVector3 setValidator(Function<Vector3, Vector3> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeVector(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readVector() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        CompoundNBT nbt = new CompoundNBT();
        if (this.value == null) {
            nbt.func_74757_a("null", true);
        } else {
            this.value.writeToNBT(compound);
        }
        compound.func_218657_a(this.name, (INBT)nbt);
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        CompoundNBT nbt;
        this.value = !compound.func_150297_b(this.name, 10) ? (this.defaultValue == null ? null : this.defaultValue.copy()) : ((nbt = compound.func_74775_l(this.name)).func_74764_b("null") ? null : Vector3.fromNBT((CompoundNBT)nbt));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

