/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class ManagedTextComponent
extends AbstractManagedData<ITextComponent> {
    private ITextComponent value;
    protected Function<ITextComponent, ITextComponent> validator = null;

    public ManagedTextComponent(String name, @Nullable ITextComponent defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedTextComponent(String name, DataFlags ... flags) {
        this(name, (ITextComponent)null, flags);
    }

    public ITextComponent set(@Nullable ITextComponent value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            ITextComponent prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public ITextComponent get() {
        return this.value;
    }

    public ManagedTextComponent setValidator(Function<ITextComponent, ITextComponent> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeTextComponent(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readTextComponent() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        if (this.value != null) {
            compound.func_74778_a(this.name, ITextComponent.Serializer.func_150696_a((ITextComponent)this.value));
        }
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        this.value = compound.func_74764_b(this.name) ? ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i(this.name)) : null;
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

