/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class ManagedPos
extends AbstractManagedData<BlockPos> {
    private BlockPos value;
    private BlockPos defaultValue;
    protected Function<BlockPos, BlockPos> validator = null;

    public ManagedPos(String name, @Nullable BlockPos defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.defaultValue = defaultValue == null ? null : new BlockPos((Vector3i)defaultValue);
    }

    public ManagedPos(String name, DataFlags ... flags) {
        this(name, BlockPos.field_177992_a, flags);
    }

    public BlockPos set(BlockPos value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            BlockPos prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public BlockPos get() {
        return this.value;
    }

    public ManagedPos setValidator(Function<BlockPos, BlockPos> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writePos(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readPos() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        CompoundNBT nbt;
        CompoundNBT compoundNBT = nbt = this.value == null ? new CompoundNBT() : NBTUtil.func_186859_a((BlockPos)this.value);
        if (this.value == null) {
            nbt.func_74757_a("null", true);
        }
        compound.func_218657_a(this.name, (INBT)nbt);
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        CompoundNBT nbt;
        this.value = !compound.func_150297_b(this.name, 10) ? (this.defaultValue == null ? null : new BlockPos((Vector3i)this.defaultValue)) : ((nbt = compound.func_74775_l(this.name)).func_74764_b("null") ? null : NBTUtil.func_186861_c((CompoundNBT)nbt));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

