/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;

public class ManagedDouble
extends AbstractManagedData<Double> {
    private double value;
    protected Function<Double, Double> validator = null;

    public ManagedDouble(String name, double defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedDouble(String name, DataFlags ... flags) {
        this(name, 0.0, flags);
    }

    public double set(double value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            double prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public double get() {
        return this.value;
    }

    public ManagedDouble setValidator(Function<Double, Double> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeDouble(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readDouble();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        compound.func_74780_a(this.name, this.value);
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        this.value = compound.func_74769_h(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public double add(double add) {
        return this.set(this.get() + add);
    }

    public double subtract(double subtract) {
        return this.set(this.get() - subtract);
    }

    public double multiply(double multiplyBy) {
        return this.set(this.get() * multiplyBy);
    }

    public double divide(double divideBy) {
        return this.set(this.get() / divideBy);
    }

    public double zero() {
        return this.set(0.0);
    }

    public double inc() {
        return this.add(1.0);
    }

    public double dec() {
        return this.subtract(1.0);
    }
}

