/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.inventory.SlotCheckValid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ContainerSlotLayout {
    private List<SlotData> slotDataList = new ArrayList<SlotData>();
    private Map<SlotType, Map<Integer, SlotData>> slotDataMap = new HashMap<SlotType, Map<Integer, SlotData>>();

    protected ContainerSlotLayout retrieveSlotsForContainer(Consumer<Slot> slotConsumer) {
        for (SlotType type : SlotType.values()) {
            ((Map)this.slotDataMap.getOrDefault((Object)type, new HashMap())).forEach((integer, slotData) -> slotConsumer.accept(slotData.slot));
        }
        return this;
    }

    public ContainerSlotLayout playerMain(PlayerEntity player) {
        if (this.slotDataMap.keySet().stream().anyMatch(slotType -> !((SlotType)slotType).isPlayer)) {
            throw new IllegalStateException("All player slots must be added before tile slots.");
        }
        LazyOptional optionalHandler = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        optionalHandler.ifPresent(itemHandler -> {
            for (int x = 0; x < 9; ++x) {
                this.slotDataList.add(new SlotData(this, SlotType.PLAYER_INV, (IItemHandler)itemHandler, x));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.slotDataList.add(new SlotData(this, SlotType.PLAYER_INV, (IItemHandler)itemHandler, x + y * 9 + 9));
                }
            }
        });
        return this;
    }

    public ContainerSlotLayout playerEquipSlot(PlayerEntity player, int equipmentSlot) {
        if (this.slotDataMap.keySet().stream().anyMatch(slotType -> !((SlotType)slotType).isPlayer)) {
            throw new IllegalStateException("All player slots must be added before tile slots.");
        }
        LazyOptional optionalHandler = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH);
        optionalHandler.ifPresent(itemHandler -> this.slotDataList.add(new SlotData(this, equipmentSlot < 4 ? SlotType.PLAYER_ARMOR : SlotType.PLAYER_OFF_HAND, (IItemHandler)itemHandler, equipmentSlot)));
        return this;
    }

    public ContainerSlotLayout playerArmor(PlayerEntity player) {
        for (int i = 0; i < 4; ++i) {
            this.playerEquipSlot(player, i);
        }
        return this;
    }

    public ContainerSlotLayout playerEquipMod(PlayerEntity player) {
        if (this.slotDataMap.keySet().stream().anyMatch(slotType -> !((SlotType)slotType).isPlayer)) {
            throw new IllegalStateException("All player slots must be added before tile slots.");
        }
        if (BrandonsCore.equipmentManager != null) {
            LazyOptional<IItemHandlerModifiable> optional = BrandonsCore.equipmentManager.getInventory((LivingEntity)player);
            optional.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    this.slotDataList.add(new SlotData(this, SlotType.PLAYER_EQUIPMENT, (IItemHandler)handler, i));
                }
            });
        }
        return this;
    }

    public ContainerSlotLayout playerOffHand(PlayerEntity player) {
        this.playerEquipSlot(player, 4);
        return this;
    }

    public ContainerSlotLayout tile(IItemHandler tileItemHandler, int slot) {
        this.slotDataList.add(new SlotData(this, SlotType.TILE_INV, tileItemHandler, slot));
        return this;
    }

    public ContainerSlotLayout allTile(IItemHandler tileItemHandler) {
        for (int i = 0; i < tileItemHandler.getSlots(); ++i) {
            this.tile(tileItemHandler, i);
        }
        return this;
    }

    public SlotData getSlotData(SlotType type, int index) {
        return this.slotDataMap.containsKey((Object)type) ? this.slotDataMap.get((Object)type).get(index) : null;
    }

    public int getPlayerSlotCount() {
        return (int)this.slotDataList.stream().filter(e -> e.type.isPlayer).count();
    }

    public static interface LayoutFactory<T> {
        public ContainerSlotLayout buildLayout(PlayerEntity var1, T var2);
    }

    public static class SlotData {
        protected ContainerSlotLayout layout;
        protected final SlotType type;
        protected IItemHandler itemHandler;
        protected final int index;
        public Slot slot;

        public SlotData(ContainerSlotLayout layout, final SlotType type, IItemHandler itemHandler, int index) {
            this.layout = layout;
            this.type = type;
            this.itemHandler = itemHandler;
            this.index = index;
            this.slot = new SlotCheckValid(itemHandler, index, index % 9 * 18, (index / 9 + (type.isPlayer ? 0 : 5)) * 18){

                @Override
                public boolean func_75214_a(ItemStack stack) {
                    return super.func_75214_a(stack) && type != SlotType.PLAYER_EQUIPMENT;
                }
            };
            layout.slotDataMap.computeIfAbsent(type, slotType -> new HashMap()).put(index, this);
        }

        public void setPos(int xPos, int yPos) {
            this.slot.field_75223_e = xPos;
            this.slot.field_75221_f = yPos;
        }
    }

    public static enum SlotType {
        PLAYER_INV(true),
        PLAYER_ARMOR(true),
        PLAYER_OFF_HAND(true),
        PLAYER_EQUIPMENT(true),
        TILE_INV(false);

        private boolean isPlayer;

        private SlotType(boolean isPlayer) {
            this.isPlayer = isPlayer;
        }
    }
}

