/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.integration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class ModHelperBC {
    private static boolean initialized = false;
    private static List<String> loadedMods = null;
    private static Map<String, String> modNameMap = null;
    private static Map<String, String> modVersionMap = null;
    public static boolean isJEIInstalled;
    public static boolean isPIInstalled;

    public static void init() {
        if (initialized) {
            return;
        }
        loadedMods = Collections.synchronizedList(new ArrayList());
        modNameMap = Collections.synchronizedMap(new HashMap());
        modVersionMap = Collections.synchronizedMap(new HashMap());
        for (ModInfo mod : ModList.get().getMods()) {
            loadedMods.add(mod.getModId());
            modNameMap.put(mod.getModId(), mod.getDisplayName());
            String version = mod.getVersion().toString();
            if (version.equals("${mod_version}")) {
                version = "9.9.9.9";
            }
            modVersionMap.put(mod.getModId(), version);
        }
        isJEIInstalled = ModList.get().isLoaded("jei");
        isPIInstalled = ModList.get().isLoaded("projectintelligence");
        initialized = true;
    }

    public static List<String> getLoadedMods() {
        ModHelperBC.init();
        return ImmutableList.copyOf(loadedMods);
    }

    public static Map<String, String> getModNameMap() {
        ModHelperBC.init();
        return ImmutableMap.copyOf(modNameMap);
    }

    public static Map<String, String> getModVersionMap() {
        ModHelperBC.init();
        return ImmutableMap.copyOf(modVersionMap);
    }

    public static String getModName(String modid) {
        return ModHelperBC.getModNameMap().get(modid);
    }

    public static String getModVersion(String modid) {
        return ModHelperBC.getModVersionMap().get(modid);
    }
}

