/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.inventory.ContainerPlayerAccess;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.io.IOUtils;

public class BCUtilCommands {
    private static Random rand = new Random();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"bcore_util").then(BCUtilCommands.registerNBT())).then(BCUtilCommands.registerNoClip())).then(BCUtilCommands.registerUUID())).then(BCUtilCommands.registerDumpEvents())).then(BCUtilCommands.registerEggify()));
    }

    private static ArgumentBuilder<CommandSource, ?> registerNBT() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"nbt").requires(cs -> cs.func_197034_c(0))).executes(context -> BCUtilCommands.functionNBT((CommandSource)context.getSource()));
    }

    private static ArgumentBuilder<CommandSource, ?> registerRegenChunk() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"regenchunk").requires(cs -> cs.func_197034_c(3))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> BCUtilCommands.regenChunk((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"))));
    }

    private static ArgumentBuilder<CommandSource, ?> registerNoClip() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"noclip").requires(cs -> cs.func_197034_c(3))).executes(context -> BCUtilCommands.toggleNoClip((CommandSource)context.getSource()));
    }

    private static ArgumentBuilder<CommandSource, ?> registerUUID() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"uuid").requires(cs -> cs.func_197034_c(0))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> BCUtilCommands.getUUID((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"target"))))).executes(ctx -> BCUtilCommands.getUUID((CommandSource)ctx.getSource(), ((CommandSource)ctx.getSource()).func_197035_h()));
    }

    private static ArgumentBuilder<CommandSource, ?> registerPlayerAccess() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"player_access").requires(cs -> cs.func_197034_c(3))).then(Commands.func_197056_a((String)"target", reader -> StringArgumentType.string()).suggests((context, builder) -> ISuggestionProvider.func_197013_a(BCUtilCommands.accessiblePlayers((CommandSource)context.getSource()).values().stream().map(GameProfile::getName), (SuggestionsBuilder)builder)).executes(context -> BCUtilCommands.playerAccess((CommandSource)context.getSource(), (String)context.getArgument("target", String.class))))).then(Commands.func_197057_a((String)"list").executes(context -> BCUtilCommands.playerAccess((CommandSource)context.getSource(), null)));
    }

    private static ArgumentBuilder<CommandSource, ?> registerDumpEvents() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"dump_event_listeners").requires(cs -> cs.func_197034_c(0))).executes(ctx -> BCUtilCommands.dumpEventListeners((CommandSource)ctx.getSource()));
    }

    private static ArgumentBuilder<CommandSource, ?> registerEggify() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"eggify").requires(cs -> cs.func_197034_c(3))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197093_b()).executes(ctx -> BCUtilCommands.eggify((CommandContext<CommandSource>)ctx, EntityArgument.func_197088_a((CommandContext)ctx, (String)"target"))));
    }

    private static int functionNBT(CommandSource source) throws CommandException, CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        ItemStack stack = HandHelper.getMainFirst((PlayerEntity)player);
        if (stack.func_190926_b()) {
            throw new CommandException((ITextComponent)new StringTextComponent("You are not holding an item!"));
        }
        if (!stack.func_77942_o()) {
            throw new CommandException((ITextComponent)new StringTextComponent("That stack has no NBT tag!"));
        }
        CompoundNBT compound = stack.func_77978_p();
        LogHelperBC.logNBT(compound);
        LogHelperBC.info(compound);
        StringBuilder builder = new StringBuilder();
        LogHelperBC.buildNBT(builder, (INBT)compound, "", "Tag", false);
        String[] lines = builder.toString().split("\n");
        DataUtils.forEach(lines, arg_0 -> BCUtilCommands.lambda$functionNBT$18((PlayerEntity)player, arg_0));
        return 0;
    }

    private static int regenChunk(CommandSource source, int rad) throws CommandException, CommandSyntaxException {
        for (int xOffset = -rad; xOffset <= rad; ++xOffset) {
            for (int yOffset = -rad; yOffset <= rad; ++yOffset) {
                ServerWorld world = source.func_197023_e();
                ServerPlayerEntity player = source.func_197035_h();
                int chunkX = player.field_70176_ah + xOffset;
                int chunkZ = player.field_70164_aj + yOffset;
                Chunk oldChunk = world.func_212866_a_(chunkX, chunkZ);
                ServerChunkProvider chunkProviderServer = world.func_72863_F();
                ChunkGenerator chunkGenerator = chunkProviderServer.func_201711_g();
            }
        }
        return 0;
    }

    private static int toggleNoClip(CommandSource source) throws CommandException, CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        boolean enabled = BCEventHandler.noClipPlayers.contains(player.func_110124_au());
        if (enabled) {
            BCEventHandler.noClipPlayers.remove(player.func_110124_au());
            BCoreNetwork.sendNoClip(player, false);
            source.func_197030_a((ITextComponent)new StringTextComponent("NoClip Disabled!"), true);
        } else {
            BCEventHandler.noClipPlayers.add(player.func_110124_au());
            BCoreNetwork.sendNoClip(player, true);
            source.func_197030_a((ITextComponent)new StringTextComponent("NoClip Enabled!"), true);
        }
        return 0;
    }

    private static int getUUID(CommandSource source, ServerPlayerEntity player) throws CommandException {
        StringTextComponent comp = new StringTextComponent(player.func_200200_C_() + "'s UUID: " + TextFormatting.UNDERLINE + player.func_110124_au());
        Style style = Style.field_240709_b_;
        style.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, player.func_110124_au().toString()));
        style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to get text")));
        comp.func_230530_a_(style);
        source.func_197030_a((ITextComponent)comp, true);
        return 0;
    }

    public static int dumpEventListeners(CommandSource source) throws CommandException {
        HashMap eventListenerMap = new HashMap();
        BCUtilCommands.dumpBus("EVENT_BUS", (EventBus)MinecraftForge.EVENT_BUS, eventListenerMap);
        StringBuilder builder = new StringBuilder("\n");
        for (String bus : eventListenerMap.keySet()) {
            builder.append("Dumping listeners for bus: ").append(bus).append("\n");
            Map busListeners = (Map)eventListenerMap.get(bus);
            ArrayList sortedClasses = Lists.newArrayList(busListeners.keySet());
            sortedClasses.sort(Comparator.comparing(Class::getName));
            for (Class eventClass : sortedClasses) {
                List listenerList = (List)busListeners.get(eventClass);
                listenerList.sort(Comparator.comparingInt(value -> ((EventPriority)value.key()).ordinal()));
                builder.append("    Handlers for event: ").append(eventClass).append("\n");
                for (Pair listener : listenerList) {
                    Method m = (Method)listener.value();
                    builder.append("        ").append(listener.key()).append(" ").append(m.getDeclaringClass().getName()).append(" ").append(m.getName()).append("(").append(BCUtilCommands.separateWithCommas(m.getParameterTypes())).append(")\n");
                }
                builder.append("\n");
            }
        }
        LogHelperBC.info(builder.toString());
        for (String s : builder.toString().split("\n")) {
            source.func_197030_a((ITextComponent)new StringTextComponent(s), true);
        }
        return 0;
    }

    private static String separateWithCommas(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < types.length; ++j) {
            sb.append(types[j].getTypeName());
            if (j >= types.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static void dumpBus(String name, EventBus bus, Map<String, Map<Class<?>, List<Pair<EventPriority, Method>>>> baseMap) throws CommandException {
        Map map = baseMap.computeIfAbsent(name, eventBus -> new HashMap());
        try {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String)"listeners");
            for (Object obj : listeners.keySet()) {
                for (Method method : obj.getClass().getMethods()) {
                    SubscribeEvent anno = method.getAnnotation(SubscribeEvent.class);
                    if (anno == null) continue;
                    for (Class<?> parameter : method.getParameterTypes()) {
                        if (!Event.class.isAssignableFrom(parameter)) continue;
                        map.computeIfAbsent(parameter, aClass -> new ArrayList()).add(new Pair<EventPriority, Method>(anno.priority(), method));
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandException((ITextComponent)new StringTextComponent(e.getMessage()));
        }
    }

    private static int eggify(CommandContext<CommandSource> ctx, Entity target) throws CommandException, CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        Entity entity = target;
        if (entity == null) {
            player.func_145747_a((ITextComponent)new StringTextComponent("You must be looking at an entity!"), Util.field_240973_b_);
            return 1;
        }
        ItemStack spawnEgg = new ItemStack((IItemProvider)SpawnEggItem.func_200889_b((EntityType)entity.func_200600_R()));
        CompoundNBT data = entity.serializeNBT();
        spawnEgg.func_77983_a("EntityTag", (INBT)data);
        data.func_82580_o("Pos");
        data.func_82580_o("Motion");
        data.func_82580_o("Rotation");
        data.func_82580_o("FallDistance");
        data.func_82580_o("Fire");
        data.func_82580_o("Air");
        data.func_82580_o("OnGround");
        data.func_82580_o("Dimension");
        data.func_82580_o("Invulnerable");
        data.func_82580_o("PortalCooldown");
        data.func_82580_o("UUID");
        InventoryUtils.givePlayerStack((PlayerEntity)player, spawnEgg);
        return 0;
    }

    @Nullable
    protected static Entity traceEntity(PlayerEntity player) {
        Entity entity = null;
        return entity;
    }

    private static Map<UUID, GameProfile> accessiblePlayers(CommandSource source) throws CommandException {
        HashMap<UUID, GameProfile> playerMap = new HashMap<UUID, GameProfile>();
        return playerMap;
    }

    private static int playerAccess(CommandSource source, String target) throws CommandException, CommandSyntaxException {
        PlayerProfileCache cache = source.func_197028_i().func_152358_ax();
        Map<UUID, GameProfile> playerMap = BCUtilCommands.accessiblePlayers(source);
        if (target == null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("################## All Known Players ##################"), false);
            for (UUID uuid : playerMap.keySet()) {
                GameProfile profile = playerMap.get(uuid);
                boolean online = false;
                for (PlayerEntity player : source.func_197028_i().func_184103_al().func_181057_v()) {
                    if (!player.func_146103_bH().getId().equals(uuid)) continue;
                    online = true;
                    break;
                }
                StringTextComponent message = new StringTextComponent((online ? TextFormatting.GREEN + "[Online]: " : TextFormatting.GRAY + "[Offline]: ") + profile.getName());
                boolean offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + profile.getName()).getBytes(Charsets.UTF_8)).equals(uuid);
                if (offline) {
                    message.func_230529_a_((ITextComponent)new StringTextComponent(" (Offline Account)").func_240699_a_(TextFormatting.RED));
                }
                IFormattableTextComponent messageHover = new StringTextComponent("Last Seen: \n").func_230529_a_((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "UUID: " + uuid + "\n")).func_230529_a_((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "-Click to access player."));
                Style msgStyle = Style.field_240709_b_;
                msgStyle.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/bcore_util player_access " + uuid));
                msgStyle.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)messageHover));
                message.func_230530_a_(msgStyle);
                source.func_197030_a((ITextComponent)message, false);
            }
            return 0;
        }
        target = target.toLowerCase(Locale.ENGLISH);
        GameProfile profile = null;
        if (cache.field_152661_c.containsKey(target)) {
            profile = cache.func_152655_a(target);
            target = profile.getId().toString();
        } else {
            try {
                profile = cache.func_152652_a(UUID.fromString(target));
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
            if (profile == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Could not find the specified player name or uuid!"));
            }
        }
        ServerPlayerEntity playerSender = source.func_197035_h();
        ServerPlayerEntity targetPlayer = source.func_197028_i().func_184103_al().func_177451_a(profile.getId());
        if (targetPlayer == null) {
            File file = BCUtilCommands.getPlayerFile(source.func_197028_i(), target);
        }
        if (playerSender == targetPlayer) {
            throw new CommandException((ITextComponent)new StringTextComponent("This command only works on other players!"));
        }
        BCUtilCommands.openPlayerAccessUI(source.func_197028_i(), playerSender, (PlayerEntity)targetPlayer);
        return 0;
    }

    public static File getPlayerFile(MinecraftServer server, String uuid) throws CommandException {
        throw new CommandException((ITextComponent)new StringTextComponent("Could not find a data file for the specified player!"));
    }

    public static CompoundNBT readPlayerCompound(File playerData) throws CommandException {
        CompoundNBT compoundNBT;
        DataInputStream is = null;
        try {
            is = new DataInputStream(new GZIPInputStream(new FileInputStream(playerData)));
            CompoundNBT compound = CompressedStreamTools.func_74794_a((DataInput)is);
            IOUtils.closeQuietly((InputStream)is);
            compoundNBT = compound;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new CommandException((ITextComponent)new StringTextComponent(e.toString()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return compoundNBT;
    }

    public static void writePlayerCompound(File playerFile, CompoundNBT playerCompound) throws IOException {
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(playerFile)));
            CompressedStreamTools.func_74800_a((CompoundNBT)playerCompound, (DataOutput)os);
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static void openPlayerAccessUI(final MinecraftServer server, ServerPlayerEntity player, final PlayerEntity playerAccess) {
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        BCoreNetwork.sendOpenPlayerAccessUI(player, windowId);
        BCoreNetwork.sendPlayerAccessUIUpdate(player, playerAccess);
        player.func_213829_a(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Player Access");
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                ContainerPlayerAccess access = new ContainerPlayerAccess(id, playerInventory, playerAccess, server);
                return access;
            }
        });
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)player, player.field_71070_bA));
    }

    private static /* synthetic */ void lambda$functionNBT$18(PlayerEntity player, String s) {
        ChatHelper.sendMessage(player, (ITextComponent)new StringTextComponent(s).func_240699_a_(TextFormatting.GOLD));
    }
}

