/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.utils;

import codechicken.lib.colour.ColourARGB;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;

@Deprecated
public class GuiHelperOld {
    public static final RenderType TRANS_TYPE = RenderType.func_228632_a_((String)"gui_trans_colour", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228713_a_(RenderState.field_228516_h_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    public static RenderType FAN_TYPE = RenderType.func_228632_a_((String)"tri_fan_type", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)6, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228713_a_(RenderState.field_228516_h_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    public static final float PXL128 = 0.0078125f;
    public static final float PXL256 = 0.00390625f;

    public static boolean isInRect(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX < (double)(x + xSize) && mouseY >= (double)y && mouseY < (double)(y + ySize);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        GuiHelperOld.drawTexturedRect(x, y, width, height, u, v, width, height, 0.0f, 0.00390625f);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, int u, int v, int uSize, int vSize, float zLevel, float pxl) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_((float)u * pxl, (float)(v + vSize) * pxl).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + uSize) * pxl, (float)(v + vSize) * pxl).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_((float)(u + uSize) * pxl, (float)v * pxl).func_181675_d();
        vertexBuffer.func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_((float)u * pxl, (float)v * pxl).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTiledTextureRectWithTrim(int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim, int texU, int texV, int texWidth, int texHeight, double zLevel) {
        int trimWidth = texWidth - leftTrim - rightTrim;
        int trimHeight = texHeight - topTrim - bottomTrim;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightTrim);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = x == 0 ? texU : (x + texWidth <= xSize ? texU + leftTrim : texU + (texWidth - (xSize - x)));
            GuiHelperOld.bufferTexturedModalRect(buffer, xPos + x, yPos, trimU, texV, rWidth, topTrim, zLevel);
            GuiHelperOld.bufferTexturedModalRect(buffer, xPos + x, yPos + ySize - bottomTrim, trimU, texV + texHeight - bottomTrim, rWidth, bottomTrim, zLevel);
            rWidth = Math.min(xSize - x - leftTrim - rightTrim, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int trimV;
                int rHeight = Math.min(ySize - y - topTrim - bottomTrim, trimHeight);
                int n = trimV = y + texHeight <= ySize ? texV + topTrim : texV + (texHeight - (ySize - y));
                if (x == 0) {
                    GuiHelperOld.bufferTexturedModalRect(buffer, xPos, yPos + y + topTrim, texU, trimV, leftTrim, rHeight, zLevel);
                    GuiHelperOld.bufferTexturedModalRect(buffer, xPos + xSize - rightTrim, yPos + y + topTrim, trimU + texWidth - rightTrim, trimV, rightTrim, rHeight, zLevel);
                }
                GuiHelperOld.bufferTexturedModalRect(buffer, xPos + x + leftTrim, yPos + y + topTrim, texU + leftTrim, texV + topTrim, rWidth, rHeight, zLevel);
            }
        }
        tessellator.func_78381_a();
    }

    private static void bufferTexturedModalRect(BufferBuilder buffer, int x, int y, int textureX, int textureY, int width, int height, double zLevel) {
        buffer.func_225582_a_((double)x, (double)(y + height), zLevel).func_225583_a_((float)textureX * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)textureY * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, zLevel).func_225583_a_((float)textureX * 0.00390625f, (float)textureY * 0.00390625f).func_181675_d();
    }

    public static void drawHoveringTextScaled(List list, int mouseX, int mouseY, FontRenderer font, float fade, double scale, int guiWidth, int guiHeight) {
        MatrixStack matrixstack = new MatrixStack();
        if (!list.isEmpty()) {
            RenderSystem.pushMatrix();
            RenderSystem.disableRescaleNormal();
            RenderHelper.func_74518_a();
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
            mouseX = (int)((double)mouseX / scale);
            mouseY = (int)((double)mouseY / scale);
            int tooltipTextWidth = 0;
            for (Object aList : list) {
                String s = (String)aList;
                int l = font.func_78256_a(s);
                if (l <= tooltipTextWidth) continue;
                tooltipTextWidth = l;
            }
            int tooltipX = mouseX + 12;
            int tooltipY = mouseY - 12;
            int tooltipHeight = 6;
            if (list.size() > 1) {
                tooltipHeight += 2 + (list.size() - 1) * 10;
            }
            if (tooltipX + tooltipTextWidth > (int)((double)guiWidth / scale)) {
                tooltipX -= 28 + tooltipTextWidth;
            }
            if (tooltipY + tooltipHeight + 6 > (int)((double)guiHeight / scale)) {
                tooltipY = (int)((double)guiHeight / scale) - tooltipHeight - 6;
            }
            int backgroundColor = -267386864;
            GuiHelperOld.drawGradientRect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor, fade, scale);
            GuiHelperOld.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor, fade, scale);
            GuiHelperOld.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, fade, scale);
            GuiHelperOld.drawGradientRect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, fade, scale);
            GuiHelperOld.drawGradientRect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, fade, scale);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            GuiHelperOld.drawGradientRect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, k1, l1, fade, scale);
            GuiHelperOld.drawGradientRect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, k1, l1, fade, scale);
            GuiHelperOld.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, k1, k1, fade, scale);
            GuiHelperOld.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, l1, l1, fade, scale);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = (String)list.get(i2);
                RenderSystem.enableBlend();
                RenderSystem.disableAlphaTest();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                font.func_238405_a_(matrixstack, s1, (float)tooltipX, (float)tooltipY, (int)(fade * 240.0f) + 16 << 24 | 0xFFFFFF);
                RenderSystem.enableAlphaTest();
                tooltipY += 10;
            }
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            RenderHelper.func_227780_a_();
            RenderSystem.enableRescaleNormal();
            RenderSystem.popMatrix();
        }
    }

    @Deprecated
    public static void drawGradientRect(float left, float top, float right, float bottom, int colour1, int colour2, float fade, double zLevel) {
        float f = (float)(colour1 >> 24 & 0xFF) / 255.0f * fade;
        float f1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour1 & 0xFF) / 255.0f;
        float f4 = (float)(colour2 >> 24 & 0xFF) / 255.0f * fade;
        float f5 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colour2 & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_225582_a_((double)right, (double)top, zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_225582_a_((double)left, (double)top, zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_225582_a_((double)left, (double)bottom, zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_225582_a_((double)right, (double)bottom, zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawGuiBaseBackground(AbstractGui gui, int posX, int posY, int xSize, int ySize) {
        ResourceHelperBC.bindTexture("textures/gui/light/background_dynamic.png");
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        MatrixStack matrixstack = new MatrixStack();
        gui.func_238474_b_(matrixstack, posX, posY, 0, 0, xSize - 4, ySize - 4);
        gui.func_238474_b_(matrixstack, posX + xSize - 4, posY, 252, 0, 4, ySize - 4);
        gui.func_238474_b_(matrixstack, posX, posY + ySize - 4, 0, 252, xSize - 4, 4);
        gui.func_238474_b_(matrixstack, posX + xSize - 4, posY + ySize - 4, 252, 252, 4, 4);
    }

    @Deprecated
    public static void drawPlayerSlots(AbstractGui gui, int posX, int posY, boolean center) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderMaterial mat = BCSprites.getThemed("slot");
        ResourceHelperBC.bindTexture(mat.func_229310_a_());
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                GuiHelperOld.drawSprite(mat.func_229311_a_((IRenderTypeBuffer)getter, BCSprites::makeType), posX + x * 18, posY + y * 18, 18.0f, 18.0f, mat.func_229314_c_(), 0.0);
            }
        }
        for (int x = 0; x < 9; ++x) {
            GuiHelperOld.drawSprite(mat.func_229311_a_((IRenderTypeBuffer)getter, BCSprites::makeType), posX + x * 18, posY + 58, 18.0f, 18.0f, mat.func_229314_c_(), 0.0);
        }
        getter.func_228461_a_();
    }

    @Deprecated
    public static void drawCenteredString(FontRenderer fontRenderer, String text, int x, int y, int color, boolean dropShadow) {
        MatrixStack matrixstack = new MatrixStack();
        if (dropShadow) {
            fontRenderer.func_238405_a_(matrixstack, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        } else {
            fontRenderer.func_238421_b_(matrixstack, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        }
    }

    public static void drawCenteredString(FontRenderer fontRenderer, MatrixStack matrixstack, String text, int x, int y, int color, boolean dropShadow) {
        if (dropShadow) {
            fontRenderer.func_238405_a_(matrixstack, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        } else {
            fontRenderer.func_238421_b_(matrixstack, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        }
    }

    public static void drawBackgroundString(IVertexBuilder vertexBuilder, FontRenderer font, String text, float x, float y, int color, int background, int padding, boolean shadow, boolean centered) {
        MatrixStack matrixstack = new MatrixStack();
        int width = font.func_78256_a(text);
        x = centered ? x - (float)width / 2.0f : x;
        double d = x - (float)padding;
        double d2 = y - (float)padding;
        double d3 = width + padding * 2;
        font.getClass();
        GuiHelperOld.drawColouredRect(vertexBuilder, d, d2, d3, 9 - 2 + padding * 2, background, 0.0);
        if (shadow) {
            font.func_238405_a_(matrixstack, text, x, y, color);
        } else {
            font.func_238421_b_(matrixstack, text, x, y, color);
        }
    }

    public static void drawGradientRect(int posX, int posY, int xSize, int ySize, int colour, int colour2) {
        GuiHelperOld.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour2, 1.0f, 0.0);
    }

    @Deprecated
    public static void drawColouredRect(int posX, int posY, int xSize, int ySize, int colour) {
        GuiHelperOld.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour, 1.0f, 0.0);
    }

    @Deprecated
    public static void drawBorderedRect(int posX, int posY, int xSize, int ySize, int borderWidth, int fillColour, int borderColour) {
        GuiHelperOld.drawColouredRect(posX, posY, xSize, borderWidth, borderColour);
        GuiHelperOld.drawColouredRect(posX, posY + ySize - borderWidth, xSize, borderWidth, borderColour);
        GuiHelperOld.drawColouredRect(posX, posY + borderWidth, borderWidth, ySize - 2 * borderWidth, borderColour);
        GuiHelperOld.drawColouredRect(posX + xSize - borderWidth, posY + borderWidth, borderWidth, ySize - 2 * borderWidth, borderColour);
        GuiHelperOld.drawColouredRect(posX + borderWidth, posY + borderWidth, xSize - 2 * borderWidth, ySize - 2 * borderWidth, fillColour);
    }

    public static void renderCuboid(Cuboid6 cuboid, float r, float g, float b, float a) {
        MatrixStack stack = new MatrixStack();
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        Matrix4 mat = new Matrix4(stack);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(RenderType.func_228659_m_()), (Transformation)mat);
        RenderUtils.bufferCuboidOutline((IVertexBuilder)builder, (Cuboid6)cuboid.copy().expand((double)0.002f), (float)r, (float)g, (float)b, (float)a);
    }

    public static void drawShadedRect(IVertexBuilder builder, double x, double y, double width, double height, double borderWidth, int fill, int topLeftColour, int bottomRightColour, int cornerMixColour, double zLevel) {
        GuiHelperOld.drawColouredRect(builder, x + borderWidth, y + borderWidth, width - borderWidth * 2.0, height - borderWidth * 2.0, fill, zLevel);
        GuiHelperOld.drawColouredRect(builder, x, y, width - borderWidth, borderWidth, topLeftColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, x, y + borderWidth, borderWidth, height - borderWidth * 2.0, topLeftColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, x + borderWidth, y + height - borderWidth, width - borderWidth, borderWidth, bottomRightColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, x + width - borderWidth, y + borderWidth, borderWidth, height - borderWidth * 2.0, bottomRightColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, x + width - borderWidth, y, borderWidth, borderWidth, cornerMixColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, x, y + height - borderWidth, borderWidth, borderWidth, cornerMixColour, zLevel);
    }

    public static void drawColouredRect(IVertexBuilder builder, double posX, double posY, double xSize, double ySize, int colour, double zLevel) {
        GuiHelperOld.drawGradientRect(builder, posX, posY, posX + xSize, posY + ySize, colour, colour, zLevel);
    }

    public static void drawGradientRect(IVertexBuilder builder, double left, double top, double right, double bottom, int startColor, int endColor, double zLevel) {
        if (startColor == endColor && endColor == 0) {
            return;
        }
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        builder.func_225582_a_(right, top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(left, top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(left, bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_(right, bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
    }

    public static void drawBorderedRect(IVertexBuilder builder, double posX, double posY, double xSize, double ySize, double borderWidth, int fillColour, int borderColour, double zLevel) {
        GuiHelperOld.drawColouredRect(builder, posX, posY, xSize, borderWidth, borderColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, posX, posY + ySize - borderWidth, xSize, borderWidth, borderColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, posX, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, posX + xSize - borderWidth, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour, zLevel);
        GuiHelperOld.drawColouredRect(builder, posX + borderWidth, posY + borderWidth, xSize - 2.0 * borderWidth, ySize - 2.0 * borderWidth, fillColour, zLevel);
    }

    public static void drawDynamicSprite(IVertexBuilder builder, TextureAtlasSprite tex, int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim, int colour, double zLevel) {
        int texWidth = tex.func_94211_a();
        int texHeight = tex.func_94216_b();
        int trimWidth = texWidth - leftTrim - rightTrim;
        int trimHeight = texHeight - topTrim - bottomTrim;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightTrim);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = 0;
            if (x != 0) {
                trimU = x + leftTrim + trimWidth <= xSize ? leftTrim : texWidth - (xSize - x);
            }
            GuiHelperOld.bufferTexturedModalRect(builder, tex, xPos + x, yPos, trimU, 0.0, rWidth, topTrim, colour, zLevel);
            GuiHelperOld.bufferTexturedModalRect(builder, tex, xPos + x, yPos + ySize - bottomTrim, trimU, texHeight - bottomTrim, rWidth, bottomTrim, colour, zLevel);
            rWidth = Math.min(xSize - x - leftTrim - rightTrim, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int rHeight = Math.min(ySize - y - topTrim - bottomTrim, trimHeight);
                int trimV = y + (texHeight - topTrim - bottomTrim) <= ySize ? topTrim : texHeight - (ySize - y);
                if (x == 0 && y + topTrim < ySize - bottomTrim) {
                    GuiHelperOld.bufferTexturedModalRect(builder, tex, xPos, yPos + y + topTrim, 0.0, trimV, leftTrim, rHeight, colour, zLevel);
                    GuiHelperOld.bufferTexturedModalRect(builder, tex, xPos + xSize - rightTrim, yPos + y + topTrim, trimU + texWidth - rightTrim, trimV, rightTrim, rHeight, colour, zLevel);
                }
                if (y + topTrim >= ySize - bottomTrim || x + leftTrim >= xSize - rightTrim) continue;
                GuiHelperOld.bufferTexturedModalRect(builder, tex, xPos + x + leftTrim, yPos + y + topTrim, leftTrim, topTrim, rWidth, rHeight, colour, zLevel);
            }
        }
    }

    private static void bufferTexturedModalRect(IVertexBuilder builder, TextureAtlasSprite tex, int x, int y, double textureX, double textureY, int width, int height, int colour, double zLevel) {
        int w = tex.func_94211_a();
        int h = tex.func_94216_b();
        int[] colours = ColourARGB.unpack((int)colour);
        builder.func_225582_a_((double)x, (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a(textureX / (double)w * 16.0), tex.func_94207_b((textureY + (double)height) / (double)h * 16.0)).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a((textureX + (double)width) / (double)w * 16.0), tex.func_94207_b((textureY + (double)height) / (double)h * 16.0)).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a((textureX + (double)width) / (double)w * 16.0), tex.func_94207_b(textureY / (double)h * 16.0)).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a(textureX / (double)w * 16.0), tex.func_94207_b(textureY / (double)h * 16.0)).func_181675_d();
    }

    public static void drawSprite(IVertexBuilder builder, float x, float y, float width, float height, TextureAtlasSprite sprite, double zLevel) {
        builder.func_225582_a_((double)x, (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
    }
}

