/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.brandon3055.brandonscore.utils.DataUtils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;

public class IntParticleType
extends ParticleType<IntParticleData> {
    private static IParticleData.IDeserializer<IntParticleData> DESERIALIZER = new IParticleData.IDeserializer<IntParticleData>(){

        public IntParticleData fromCommand(ParticleType<IntParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            ArrayList<Integer> list = new ArrayList<Integer>();
            while (reader.peek() == ' ') {
                reader.expect(' ');
                list.add(reader.readInt());
            }
            return new IntParticleData(particleTypeIn, DataUtils.toPrimitive(list.toArray(new Integer[0])));
        }

        public IntParticleData fromNetwork(ParticleType<IntParticleData> particleTypeIn, PacketBuffer buffer) {
            return new IntParticleData(particleTypeIn, buffer.readByte());
        }
    };

    public IntParticleType(boolean alwaysShow) {
        super(alwaysShow, DESERIALIZER);
    }

    public Codec<IntParticleData> func_230522_e_() {
        return null;
    }

    public static class IntParticleData
    implements IParticleData {
        private ParticleType<?> type;
        private int[] data;

        public IntParticleData(ParticleType<?> type, int ... data) {
            this.type = type;
            this.data = data;
        }

        public ParticleType<?> func_197554_b() {
            return this.type;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.func_186875_a(this.data);
        }

        public int[] get() {
            return this.data;
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %sb", Registry.field_212632_u.func_177774_c(this.func_197554_b()), DataUtils.stringArrayConcat(DataUtils.arrayToString(this.data), " "));
        }
    }
}

