/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.hud;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.hud.HudData;
import com.brandon3055.brandonscore.client.hud.HudDataElement;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public class HudManager {
    private static ForgeRegistry<AbstractHudElement> HUD_REGISTRY;
    protected static Map<ResourceLocation, AbstractHudElement> hudElements;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(HudManager::onDrawOverlayPre);
        MinecraftForge.EVENT_BUS.addListener(HudManager::onDrawOverlayPost);
        MinecraftForge.EVENT_BUS.addListener(HudManager::onClientTick);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HudManager::createRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HudManager::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(AbstractHudElement.class, HudManager::registerBuiltIn);
    }

    public static void onDrawOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.isCanceled()) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        boolean configuring = Minecraft.func_71410_x().field_71462_r instanceof HudConfigGui;
        for (AbstractHudElement element : hudElements.values()) {
            if (!element.shouldRender(event.getType(), true)) continue;
            stack.func_227860_a_();
            element.render(stack, event.getPartialTicks(), configuring);
            stack.func_227865_b_();
        }
    }

    public static void onDrawOverlayPost(RenderGameOverlayEvent.Post event) {
        if (event.isCanceled()) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        boolean configuring = Minecraft.func_71410_x().field_71462_r instanceof HudConfigGui;
        for (AbstractHudElement element : hudElements.values()) {
            if (!element.shouldRender(event.getType(), false)) continue;
            stack.func_227860_a_();
            element.render(stack, event.getPartialTicks(), configuring);
            stack.func_227865_b_();
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        boolean configuring = Minecraft.func_71410_x().field_71462_r instanceof HudConfigGui;
        for (AbstractHudElement element : hudElements.values()) {
            element.tick(configuring);
        }
        HudData.clientTick();
    }

    private static void createRegistry(RegistryEvent.NewRegistry event) {
        HUD_REGISTRY = (ForgeRegistry)SneakyUtils.unsafeCast((Object)new RegistryBuilder().setName(new ResourceLocation("brandonscore", "hud_elements")).setType((Class)SneakyUtils.unsafeCast(AbstractHudElement.class)).disableSaving().disableSync().create());
    }

    private static void onLoadComplete(FMLLoadCompleteEvent event) {
        hudElements.clear();
        for (ResourceLocation key : HUD_REGISTRY.getKeys()) {
            hudElements.put(key, (AbstractHudElement)HUD_REGISTRY.getValue(key));
        }
        HudData.loadSettings();
    }

    public static void registerBuiltIn(RegistryEvent.Register<AbstractHudElement> event) {
        event.getRegistry().register(new HudDataElement(new Vector2(0.0, 0.20494), true, false).setEnabled(false).setRegistryName("item_hud"));
        event.getRegistry().register(new HudDataElement(new Vector2(0.0, 0.04593), false, true).setEnabled(false).setRegistryName("block_hud"));
        event.getRegistry().register(new HudDataElement(new Vector2(0.99023, 0.72438), true, true).setRegistryName("block_item_hud"));
    }

    public static Map<ResourceLocation, AbstractHudElement> getHudElements() {
        return ImmutableMap.copyOf(hudElements);
    }

    @Nullable
    public static AbstractHudElement getHudElement(ResourceLocation key) {
        return hudElements.get(key);
    }

    static {
        hudElements = new HashMap<ResourceLocation, AbstractHudElement>();
    }
}

