/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.templates;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IGuiParentElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSlotRender;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.awt.Point;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;

public class TGuiBase
implements IGuiTemplate {
    private boolean isInitialized = false;
    public GuiElement<?> background;
    public GuiLabel title;
    public GuiButton themeButton;
    public GuiElement<?> playerSlots;
    public GuiEnergyBar energyBar;
    public GuiSlotRender powerSlot;
    public GuiToolkit.InfoPanel infoPanel;
    protected Screen gui;
    protected GuiToolkit<?> toolkit;
    protected ContainerSlotLayout slotLayout;

    public TGuiBase(Screen gui) {
        this.gui = gui;
    }

    public TGuiBase(Screen gui, ContainerSlotLayout slotLayout) {
        this.slotLayout = slotLayout;
    }

    @Override
    public void addElements(IGuiParentElement<?> parent, GuiToolkit<?> toolkit) {
        this.toolkit = toolkit;
        if (this.background == null) {
            this.background = toolkit.createBackground(true);
            parent.addChild(this.background);
        } else if (!parent.hasChild(this.background)) {
            parent.addChild(this.background);
        }
        this.title = toolkit.createHeading(this.getTitle(), this.background, true);
        this.themeButton = toolkit.createThemeButton(this.background);
        this.themeButton.setRelPosRight(this.background, -15, 3);
        this.infoPanel = toolkit.createInfoPanel(this.background, false);
        this.infoPanel.setOrigin(() -> new Point(this.themeButton.xPos(), this.themeButton.maxYPos()));
        this.infoPanel.setEnabled(false);
        this.isInitialized = true;
    }

    public void addPlayerSlots() {
        this.addPlayerSlots(true, false, false);
    }

    public void addPlayerSlots(boolean title, boolean armor, boolean offHand) {
        if (this.playerSlots != null && this.playerSlots.getParent() != null) {
            this.playerSlots.getParent().removeChild(this.playerSlots);
        }
        this.playerSlots = this.toolkit.createPlayerSlots(this.background, title, armor, offHand);
        this.toolkit.placeInside(this.playerSlots, this.background, GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, -7);
    }

    public void addEnergyBar(IOPStorage opStorage, boolean inventoryAligned) {
        this.checkInit();
        this.energyBar = this.toolkit.createEnergyBar(this.background, opStorage);
        if (inventoryAligned) {
            this.energyBar.setPos(this.playerSlots.xPos(), this.background.yPos() + 6);
        } else {
            this.energyBar.setPos(this.background.xPos() + 6, this.background.yPos() + 6);
        }
        ((GuiEnergyBar)this.energyBar.setXSize(14)).setMaxYPos(this.playerSlots.yPos() - 4, true);
    }

    public void addEnergyBar(IOPStorage opStorage) {
        this.addEnergyBar(opStorage, !this.toolkit.getLayout().isWide());
    }

    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem, boolean bellowBar, ContainerSlotLayout.SlotData slotData) {
        if (this.energyBar == null) {
            throw new RuntimeException("Must call addEnergyBar before you can add an energy item slot!");
        }
        this.powerSlot = new GuiSlotRender();
        this.background.addChild(this.powerSlot);
        GuiTexture bgTexture = (GuiTexture)new GuiTexture(16, 16, BCSprites.get("slot_energy")).setPos(1, 1);
        this.powerSlot.addChild(bgTexture);
        if (slotData != null) {
            this.powerSlot.addPosChangeListener((x, y) -> slotData.setPos(x + 1 - this.toolkit.guiLeft(), y + 1 - this.toolkit.guiTop()));
        }
        GuiButton powerToggle = new GuiButton();
        powerToggle.setFillColours(0, 0x4000FF00);
        if (chargeItem != null) {
            powerToggle.onPressed(chargeItem::invert);
        }
        powerToggle.setSize(14, 14);
        powerToggle.setHoverText(element -> I18n.func_135052_a((String)("gui.bc." + (chargeItem.get() ? "charging" : "discharging") + "_item.txt"), (Object[])new Object[0]));
        GuiTexture toggleTex = new GuiTexture(14, 14, BCSprites.get(bellowBar ? "vertical_discharge" : "right_discharge"));
        toggleTex.setPos(powerToggle);
        if (bellowBar) {
            this.energyBar.translate(2, 0);
            toggleTex.setSize(12, 10);
            powerToggle.setSize(12, 10);
            this.powerSlot.setPos(this.energyBar.xPos() - 2, this.playerSlots.yPos() - this.powerSlot.ySize() - 6);
        } else {
            this.powerSlot.setPos(this.energyBar.maxXPos() + 2, this.energyBar.maxYPos() - this.powerSlot.ySize());
        }
        if (chargeItem != null) {
            toggleTex.setMaterialSupplier(() -> BCSprites.get(!chargeItem.get() ? (bellowBar ? "btn_vertical_discharge" : "btn_right_discharge") : (bellowBar ? "btn_vertical_charge" : "btn_right_charge")));
            powerToggle.addChild(toggleTex);
            if (bellowBar) {
                powerToggle.setPos(this.powerSlot.xPos() + 3, this.powerSlot.yPos() - toggleTex.ySize() - 1);
                this.energyBar.setMaxYPos(toggleTex.yPos() - 1, true);
            } else {
                powerToggle.setPos(this.powerSlot.xPos() + 2, this.powerSlot.yPos() - powerToggle.ySize() - 2);
            }
            this.background.addChild(powerToggle);
        }
    }

    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem, boolean bellowBar) {
        this.addEnergyItemSlot(chargeItem, bellowBar, null);
    }

    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem, ContainerSlotLayout.SlotData slotData) {
        this.addEnergyItemSlot(chargeItem, this.toolkit.getLayout().isTall());
    }

    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem) {
        this.addEnergyItemSlot(chargeItem, null);
    }

    public void addEnergyItemSlot(boolean chargeItem, boolean bellowBar, ContainerSlotLayout.SlotData slotData) {
        if (this.energyBar == null) {
            throw new RuntimeException("Must call addEnergyBar before you can add an energy item slot!");
        }
        this.powerSlot = new GuiSlotRender();
        this.background.addChild(this.powerSlot);
        GuiTexture bgTexture = (GuiTexture)new GuiTexture(16, 16, BCSprites.get("slots/energy")).setPos(1, 1);
        this.powerSlot.addChild(bgTexture);
        if (slotData != null) {
            bgTexture.setEnabledCallback(() -> !slotData.slot.func_75216_d());
            this.powerSlot.addPosChangeListener((x, y) -> slotData.setPos(x + 1 - this.toolkit.guiLeft(), y + 1 - this.toolkit.guiTop()));
        }
        GuiTexture toggleTex = new GuiTexture(14, 14, BCSprites.get("item_charge/" + (bellowBar ? "vertical" : "right") + "_" + (chargeItem ? "charge" : "discharge")));
        if (bellowBar) {
            this.energyBar.translate(2, 0);
            toggleTex.setSize(12, 10);
            this.powerSlot.setPos(this.energyBar.xPos() - 2, this.playerSlots.yPos() - this.powerSlot.ySize() - 2);
            toggleTex.setPos(this.powerSlot.xPos() + 3, this.powerSlot.yPos() - toggleTex.ySize() - 1);
            this.energyBar.setMaxYPos(toggleTex.yPos() - 1, true);
        } else {
            this.powerSlot.setPos(this.energyBar.maxXPos() + 2, this.energyBar.maxYPos() - this.powerSlot.ySize());
            if (chargeItem) {
                toggleTex.setPos(this.powerSlot.xPos(), this.powerSlot.yPos() - toggleTex.ySize() - 2);
            } else {
                toggleTex.setPos(this.powerSlot.xPos() + 1, this.powerSlot.yPos() - toggleTex.ySize());
            }
        }
        this.powerSlot.addChild(toggleTex);
    }

    public void addEnergyItemSlot(boolean chargeItem, boolean bellowBar) {
        this.addEnergyItemSlot(chargeItem, bellowBar, null);
    }

    public void addEnergyItemSlot(boolean chargeItem) {
        this.addEnergyItemSlot(chargeItem, null);
    }

    public void addEnergyItemSlot(boolean chargeItem, ContainerSlotLayout.SlotData slotData) {
        this.addEnergyItemSlot(chargeItem, this.toolkit.getLayout().isTall(), slotData);
    }

    private boolean checkInit() {
        if (!this.isInitialized) {
            LogHelperBC.bigError("Machine template must be initialized before applying any other operations.", new Object[0]);
        }
        return this.isInitialized;
    }

    protected String getTitle() {
        return this.gui.func_231171_q_().getString();
    }
}

