/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.integration.JeiHelper;
import com.brandon3055.brandonscore.integration.PIHelper;
import com.brandon3055.brandonscore.lib.StackReference;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class StackElement
extends MDElementBase<StackElement> {
    private ItemStack[] stacks;
    public boolean drawSlot = false;

    public StackElement(String stackString) {
        this.enableTooltip = true;
        this.size = 16;
        Object tag = null;
        boolean isOre = tag != null;
        ArrayList<ItemStack> baseStacks = new ArrayList<ItemStack>();
        if (isOre) {
            baseStacks.addAll(tag.func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList()));
        } else {
            ItemStack stack;
            StackReference stackRef = StackReference.fromString(stackString);
            if (stackRef == null || (stack = stackRef.createStack()).func_190926_b()) {
                this.error("[Broken Stack. Specified Item or Block could not be found!]");
                return;
            }
            baseStacks.add(stack);
        }
        NonNullList finalStacks = NonNullList.func_191196_a();
        finalStacks.addAll(baseStacks);
        this.stacks = (ItemStack[])finalStacks.toArray((Object[])new ItemStack[0]);
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.setSize(this.size, this.size);
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.stacks.length == 0) {
            return;
        }
        RenderSystem.pushMatrix();
        if (this.drawSlot) {
            RenderMaterial mat = BCSprites.get("light/slot");
            this.bindTexture(mat.func_229310_a_());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            this.drawSprite(mat.func_229311_a_((IRenderTypeBuffer)getter, BCSprites::makeType), this.xPos(), this.yPos(), this.xSize(), this.ySize(), mat.func_229314_c_());
            getter.func_228461_a_();
        }
        double scale = (double)this.size / 18.0;
        ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
        RenderHelper.func_227780_a_();
        RenderSystem.translated((double)((double)this.xPos() + scale), (double)((double)this.yPos() + scale), (double)(this.getRenderZLevel() - 80.0f));
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        minecraft.func_175599_af().func_175042_a(stack, 0, 0);
        if (stack.func_190916_E() > 1) {
            String s = "\u00a7f" + stack.func_190916_E() + "" + "\u00a7" + "f";
            RenderSystem.translated((double)0.0, (double)0.0, (double)(-(this.getRenderZLevel() - 80.0f)));
            this.zOffset += 45.0;
            float f = 18 - this.fontRenderer.func_78256_a(s) - 1;
            ((Object)((Object)this.fontRenderer)).getClass();
            this.drawString((FontRenderer)this.fontRenderer, s, f, 9.0f, 0xFFFFFF, true);
            this.zOffset -= 45.0;
        }
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.enableTooltip && this.isMouseOver(mouseX, mouseY)) {
            if (this.tooltip.isEmpty()) {
                ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
                List<ITextComponent> list = this.getTooltipFromItem(stack);
                for (int i = 0; i < list.size(); ++i) {
                    if (i != 0) continue;
                }
                GuiUtils.preItemToolTip((ItemStack)stack);
                this.drawHoveringText(stack, list, mouseX, mouseY, this.screenWidth, this.screenHeight, -1, this.fontRenderer);
                GuiUtils.postItemToolTip();
            } else {
                this.drawHoveringText(this.tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
            }
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY) && (mouseButton == 0 || mouseButton == 1)) {
            ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
            JeiHelper.openJEIRecipe(stack, mouseButton == 1);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        double mouseY;
        double mouseX = this.getMouseX();
        if (this.isMouseOver(mouseX, mouseY = this.getMouseY())) {
            List<String> pages;
            ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
            if (keyCode == JeiHelper.getRecipeKey(false)) {
                JeiHelper.openJEIRecipe(stack, false);
                return true;
            }
            if (keyCode == JeiHelper.getRecipeKey(true)) {
                JeiHelper.openJEIRecipe(stack, true);
                return true;
            }
            if (PIHelper.isInstalled() && PIHelper.getETGuiKey().func_197976_a(keyCode, scanCode) && !(pages = PIHelper.getRelatedPages(stack)).isEmpty()) {
                PIHelper.openGui(this.modularGui.getScreen(), pages);
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

