/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MarkerElement;
import com.brandon3055.brandonscore.integration.IRecipeRenderer;
import com.brandon3055.brandonscore.integration.JeiHelper;
import com.brandon3055.brandonscore.integration.PIHelper;
import com.brandon3055.brandonscore.lib.StackReference;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class RecipeElement
extends MDElementBase<RecipeElement> {
    private List<IRecipeRenderer> renderers;
    public int spacing = 1;

    public RecipeElement(String stackString) {
        ItemStack stack;
        this.hasSubParts = true;
        this.boundless = true;
        this.colour = 0xC6C6C6;
        this.colourHover = -1;
        StackReference stackRef = StackReference.fromString(stackString);
        if (stackRef == null || (stack = stackRef.createStack()).func_190926_b()) {
            this.error("[Broken recipe. Specified Item or Block could not be found!]");
            return;
        }
        if (!JeiHelper.jeiAvailable()) {
            this.error("[Broken recipe. The mod JEI (Just Enough Items) is required to display recipes!]");
            return;
        }
        this.renderers = JeiHelper.getRecipeRenderers(stack);
        if (this.renderers == null) {
            this.error("[Broken recipe. No recipe's were found for " + stackString + "]");
        } else if (this.renderers.isEmpty()) {
            // empty if block
        }
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.toRemove.addAll(this.subParts);
        this.subParts.clear();
        for (int i = 0; i < this.renderers.size(); ++i) {
            int nextWidth;
            IRecipeRenderer renderer = this.renderers.get(i);
            RecipeElementPart element = new RecipeElementPart(this, renderer);
            int avalibleWidth = layout.getWidth() - layout.getCaretXOffset();
            if (avalibleWidth - this.spacing < (nextWidth = renderer.getWidth() + this.leftPad + this.rightPad) && layout.getCaretXOffset() > 0) {
                layout.newLine(0, this.subParts.isEmpty() ? 0 : 0);
                MarkerElement marker = new MarkerElement(MarkerElement.Type.NEW_LINE);
                this.subParts.add(marker);
            } else if (lineElement.isEmpty() || !(lineElement.get(lineElement.size() - 1) instanceof RecipeElement)) {
                MarkerElement spacer = new MarkerElement(this.spacing, 0);
                spacer.layoutElement(layout, lineElement);
                this.subParts.add(spacer);
            }
            this.addChild(element);
            this.subParts.add(element);
            element.layoutElement(layout, lineElement);
            if (i != 0) continue;
            this.setXPosMod((E element1, Integer integer) -> element.xPos());
            this.setYPosMod((E element1, Integer integer) -> element.yPos());
        }
        if (!this.renderers.isEmpty()) {
            MarkerElement spacer = new MarkerElement(this.spacing, 0);
            spacer.layoutElement(layout, lineElement);
            this.subParts.add(spacer);
        }
    }

    private static class RecipeElementPart
    extends MDElementBase<RecipeElementPart> {
        private RecipeElement parent;
        private IRecipeRenderer renderer;

        public RecipeElementPart(RecipeElement parent, IRecipeRenderer renderer) {
            this.parent = parent;
            this.renderer = renderer;
            this.setSize(renderer.getWidth() + parent.leftPad + parent.rightPad + 8, renderer.getHeight() + parent.topPad + parent.bottomPad + 8);
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            if (this.parent.hasColourBorder) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.parent.getColourBorder(mouseOver));
            } else if (this.parent.hasColourBorderHover && mouseOver) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.parent.colourBorderHover);
            }
            RenderSystem.translated((double)0.0, (double)0.0, (double)this.getRenderZLevel());
            this.renderer.render(minecraft, this.xPos() + this.parent.leftPad + 4, this.yPos() + this.parent.topPad + 4, mouseX, mouseY);
            RenderSystem.translated((double)0.0, (double)0.0, (double)(-this.getRenderZLevel()));
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        @Override
        public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            if (this.isMouseOver(mouseX, mouseY)) {
                this.renderer.renderOverlay(this.mc, mouseX, mouseY);
                return true;
            }
            return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
        }

        @Override
        public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
            Point pos = layout.nextElementPos(this.xSize(), this.ySize() + this.parent.spacing);
            this.setPos(pos.x, pos.y);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (this.isMouseOver(mouseX, mouseY) && (mouseButton == 0 || mouseButton == 1)) {
                this.renderer.handleRecipeClick(this.mc, mouseX, mouseY, mouseButton == 1);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            double mouseY;
            double mouseX = this.getMouseX();
            if (this.isMouseOver(mouseX, mouseY = this.getMouseY())) {
                List<String> pages;
                Object o = this.renderer.getIngredientUnderMouse(mouseX, mouseY);
                if (keyCode == JeiHelper.getRecipeKey(false)) {
                    this.renderer.handleRecipeClick(this.mc, mouseX, mouseY, false);
                    return true;
                }
                if (keyCode == JeiHelper.getRecipeKey(true)) {
                    this.renderer.handleRecipeClick(this.mc, mouseX, mouseY, true);
                    return true;
                }
                if (o instanceof ItemStack && !((ItemStack)o).func_190926_b() && PIHelper.isInstalled() && PIHelper.getETGuiKey().func_197976_a(keyCode, scanCode) && !(pages = PIHelper.getRelatedPages((ItemStack)o)).isEmpty()) {
                    PIHelper.openGui(this.modularGui.getScreen(), pages);
                    return true;
                }
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
    }
}

