/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ImageElement
extends MDElementBase<ImageElement> {
    private static final Random rand = new Random();
    private static final List<Block> LOADING_BLOCKS = Lists.newArrayList((Object[])new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150349_c, Blocks.field_150347_e, Blocks.field_196617_K, Blocks.field_150359_w, Blocks.field_150391_bh, Blocks.field_150486_ae, Blocks.field_150381_bn, Blocks.field_150462_ai, Blocks.field_150467_bQ, Blocks.field_150461_bJ, Blocks.field_150342_X, Blocks.field_150482_ag, Blocks.field_150343_Z, Blocks.field_150346_d, Blocks.field_150367_z, Blocks.field_150460_al, Blocks.field_150407_cf});
    private ItemStack renderLoadingStack = ItemStack.field_190927_a;
    private int loadingTime = 0;
    private int maxLoadTime = 10;
    private boolean downloading = false;
    private DLResourceLocation resourceLocation;
    private MDElementContainer container;
    private RenderType imageType;
    private String imageURL;
    public String linkTo = "";

    public ImageElement(MDElementContainer container, String imageURL) {
        this.container = container;
        this.imageURL = imageURL;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.resourceLocation = DLRSCache.getResource(this.imageURL);
        int w = 0;
        int h = 0;
        if (!this.resourceLocation.dlFinished || this.resourceLocation.dlFailed) {
            w = 76;
            h = 76;
            this.downloading = true;
        } else {
            this.imageType = GuiHelper.guiTextureType(this.resourceLocation);
            if (this.width == -1 && this.height == -1) {
                this.width = 32;
            }
            if (this.width != -1) {
                int n = w = this.screenRelativeSize ? (int)(MathHelper.clip((double)((double)this.width / 100.0), (double)0.0, (double)1.0) * (double)layout.getWidth()) : MathHelper.clip((int)this.width, (int)8, (int)layout.getWidth());
                if (this.height == -1) {
                    h = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.height / (double)this.resourceLocation.width * (double)w) : w;
                }
            }
            if (this.height != -1) {
                h = this.height;
                if (this.width == -1) {
                    w = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.width / (double)this.resourceLocation.height * (double)this.height) : this.height;
                }
            }
        }
        this.setSize(w, h);
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.downloading || this.resourceLocation.dlFailed) {
            this.renderDownloading(partialTicks);
        } else if (this.imageType != null) {
            ResourceHelperBC.bindTexture(this.resourceLocation);
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            if (this.hasColourBorder) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.getColourBorder(mouseOver));
            } else if (this.hasColourBorderHover && mouseOver) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.colourBorderHover);
            }
            int w = this.xSize() - this.rightPad - this.leftPad;
            int h = this.ySize() - this.bottomPad - this.topPad;
            IRenderTypeBuffer.Impl getter = RenderUtils.getTypeBuffer();
            GuiHelper.drawTexture(getter.getBuffer(this.imageType), this.xPos() + this.leftPad, this.yPos() + this.topPad, w, h);
            RenderUtils.endBatch((IRenderTypeBuffer)getter);
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    private void renderDownloading(float partialTicks) {
        IRenderTypeBuffer.Impl getter = RenderUtils.getTypeBuffer();
        boolean failed = this.resourceLocation.dlFailed;
        RenderMaterial mat = failed ? BCSprites.get("download_failed") : BCSprites.get("downloading");
        float failTicks = failed ? 0.0f : partialTicks;
        float anim = MathHelper.clip((float)(((float)this.loadingTime + failTicks) / (float)this.maxLoadTime), (float)0.0f, (float)1.0f);
        this.drawBorderedRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, failed ? -65536 : -16711936);
        if (failed) {
            GuiHelper.drawSprite(BCSprites.builder((IRenderTypeBuffer)getter), this.xPos(), this.yPos(), this.xSize(), this.ySize(), mat.func_229314_c_());
        } else {
            GuiHelper.drawPartialSprite(BCSprites.builder((IRenderTypeBuffer)getter), this.xPos(), this.yPos(), this.xSize(), (float)this.ySize() * anim, mat.func_229314_c_(), 0.0, 0.0, 1.0, anim);
        }
        RenderUtils.endBatch((IRenderTypeBuffer)getter);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (!this.linkTo.isEmpty() && this.container.linkDisplayTarget != null) {
                GuiElement e = this.container.linkDisplayTarget;
                int width = this.fontRenderer.func_78256_a(this.linkTo);
                int height = this.fontRenderer.func_78267_b(this.linkTo, e.xSize()) + 4;
                this.zOffset += (double)this.container.linkDisplayZOffset;
                this.drawColouredRect(e.xPos(), e.maxYPos() - height, Math.min(Math.max(width + 4, e.xSize() / 2), e.xSize()), height, -1879048192);
                this.drawSplitString(this.fontRenderer, this.linkTo, e.xPos() + 2, e.maxYPos() - height + 2, e.xSize(), 0xC0C0C0, false);
                this.zOffset -= (double)this.container.linkDisplayZOffset;
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            if (this.resourceLocation.dlFailed) {
                tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.bc.downloading_image_failed.info", (Object[])new Object[0]));
            } else if (!this.resourceLocation.dlFinished) {
                tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.bc.downloading_image.info", (Object[])new Object[0]));
            }
            if (this.enableTooltip && !this.tooltip.isEmpty()) {
                tooltip.addAll(this.tooltip);
            }
            if (!tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (mouseButton == 0 && Screen.func_231173_s_()) {
                DLRSCache.clearFileCache(this.imageURL);
                this.loadingTime = 0;
                this.container.layoutMarkdownElements();
                return true;
            }
            if (mouseButton != 1 && !this.linkTo.isEmpty()) {
                this.container.handleLinkClick(this.linkTo, mouseButton);
                return true;
            }
            if (mouseButton == 1) {
                this.container.handleLinkClick(this.imageURL, mouseButton);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onUpdate() {
        if (this.resourceLocation != null && this.downloading) {
            if (this.resourceLocation.dlFailed) {
                this.downloading = false;
                this.container.getTopLevelContainer().layoutMarkdownElements();
                return true;
            }
            if (this.loadingTime++ > this.maxLoadTime) {
                this.loadingTime = 0;
                if (this.resourceLocation.dlFinished || this.resourceLocation.dlFailed) {
                    this.container.getTopLevelContainer().layoutMarkdownElements();
                    this.downloading = false;
                    return true;
                }
            }
        }
        return super.onUpdate();
    }
}

