/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GuiTextFieldDialog
extends GuiPopUpDialogBase<GuiTextFieldDialog> {
    private String title = "";
    public int titleColour = 0xFFFFFF;
    public GuiTextField textField;
    public GuiButton okButton;
    protected int maxLength = 64;
    protected String defaultText = "";
    protected Predicate<String> validator = null;
    protected Consumer<String> changeCallBack;
    protected Consumer<String> confirmCallBack;

    public GuiTextFieldDialog(GuiElement parent) {
        super(parent);
        this.setSize(200, 20);
    }

    public GuiTextFieldDialog(GuiElement parent, String title) {
        super(parent);
        this.title = title;
        this.setSize(200, 40);
        this.setDragBar(15);
        this.setInsets(18, 3, 3, 3);
    }

    public GuiTextFieldDialog(int xPos, int yPos, GuiElement parent) {
        super(xPos, yPos, parent);
        this.setSize(200, 20);
    }

    public GuiTextFieldDialog(int xPos, int yPos, int xSize, int ySize, GuiElement parent) {
        super(xPos, yPos, xSize, ySize, parent);
        this.setSize(200, 20);
    }

    @Override
    public void addChildElements() {
        this.textField = (GuiTextField)((GuiTextField)new GuiTextField().setPosAndSize(this.getInsetRect())).setXSize(this.getInsetRect().width - 20);
        this.addChild(this.textField);
        this.textField.setChangeListener(text -> {
            if (this.changeCallBack != null) {
                this.changeCallBack.accept((String)text);
            }
        });
        this.textField.setReturnListener(text -> {
            if (this.confirmCallBack != null) {
                this.confirmCallBack.accept((String)text);
            }
            this.close();
        });
        this.textField.setMaxStringLength(this.maxLength);
        this.textField.setTextAndNotify(this.defaultText);
        if (this.validator != null) {
            this.textField.setValidator(this.validator);
        }
        this.okButton = new GuiButton(this.textField.maxXPos(), this.textField.yPos(), 20, this.textField.ySize(), I18n.func_135052_a((String)"mod_gui.brandonscore.button.ok", (Object[])new Object[0])).setTrim(false).setFillColour(-16777216).setBorderColours(-11184811, -8947849);
        this.addChild(this.okButton);
        this.okButton.onPressed(() -> {
            if (this.confirmCallBack != null) {
                this.confirmCallBack.accept(this.textField.getText());
            }
            this.close();
        });
        super.addChildElements();
    }

    public GuiTextFieldDialog setValidator(Predicate<String> validator) {
        this.validator = validator;
        if (this.textField != null) {
            this.textField.setValidator(validator);
        }
        return this;
    }

    public GuiTextFieldDialog setText(String text) {
        this.defaultText = text;
        if (this.textField != null) {
            this.textField.setTextAndNotify(text);
        }
        return this;
    }

    public GuiTextFieldDialog addTextChangeCallback(Consumer<String> changeCallBack) {
        this.changeCallBack = changeCallBack;
        return this;
    }

    public GuiTextFieldDialog addTextConfirmCallback(Consumer<String> confirmCallBack) {
        this.confirmCallBack = confirmCallBack;
        return this;
    }

    public GuiTextFieldDialog setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.textField != null) {
            this.textField.setMaxStringLength(maxLength);
        }
        return this;
    }

    public GuiTextFieldDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public GuiTextFieldDialog setTitleColour(int titleColour) {
        this.titleColour = titleColour;
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (!this.title.isEmpty()) {
            this.drawString(this.fontRenderer, this.title, (float)(this.xPos() + 4), (float)(this.yPos() + 6), this.titleColour);
        }
    }
}

