/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public class GuiLabel
extends GuiElement<GuiLabel> {
    protected boolean trim = true;
    protected boolean midTrim = false;
    protected boolean wrap = false;
    protected boolean dropShadow = true;
    protected GuiAlign alignment = GuiAlign.CENTER;
    protected GuiAlign.TextRotation rotation = GuiAlign.TextRotation.NORMAL;
    private int textColour = -1;
    private String labelText = "";
    private Supplier<String> displayStringSupplier;
    private Supplier<Boolean> shadowStateSupplier;
    private GuiColourProvider.HoverColour<Integer> texColGetter;

    public GuiLabel() {
    }

    public GuiLabel(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiLabel(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    public GuiLabel(String labelText) {
        this.labelText = labelText;
    }

    public GuiLabel(Supplier<String> displayStringSupplier) {
        this.setDisplaySupplier(displayStringSupplier);
    }

    public GuiLabel(int xPos, int yPos, String labelText) {
        this(xPos, yPos);
        this.labelText = labelText;
    }

    public GuiLabel(int xPos, int yPos, int xSize, int ySize, String labelText) {
        this(xPos, yPos, xSize, ySize);
        this.labelText = labelText;
    }

    public GuiLabel setLabelText(String displayString) {
        this.labelText = displayString;
        return this;
    }

    public GuiLabel setDisplaySupplier(Supplier<String> displayStringSupplier) {
        this.displayStringSupplier = displayStringSupplier;
        return this;
    }

    public String getLabelText() {
        return this.displayStringSupplier != null ? this.displayStringSupplier.get() : this.labelText;
    }

    public GuiLabel setAlignment(GuiAlign alignment) {
        this.alignment = alignment;
        return this;
    }

    public GuiAlign getAlignment() {
        return this.alignment;
    }

    public GuiLabel setTrim(boolean trim) {
        this.trim = trim;
        if (trim) {
            this.wrap = false;
        }
        return this;
    }

    public GuiLabel setMidTrim(boolean midTrim) {
        this.midTrim = midTrim;
        return this;
    }

    public GuiLabel setWrap(boolean wrap) {
        this.wrap = wrap;
        if (wrap) {
            this.trim = false;
        }
        return this;
    }

    public GuiLabel setRotation(GuiAlign.TextRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiAlign.TextRotation getRotation() {
        return this.rotation;
    }

    public GuiLabel setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        this.shadowStateSupplier = null;
        return this;
    }

    public GuiLabel setShadowStateSupplier(Supplier<Boolean> shadowStateSupplier) {
        this.shadowStateSupplier = shadowStateSupplier;
        return this;
    }

    public boolean hasShadow() {
        return this.shadowStateSupplier != null ? this.shadowStateSupplier.get() : this.dropShadow;
    }

    public int getTextColour(boolean hovered) {
        if (this.texColGetter != null) {
            return this.texColGetter.getColour(hovered);
        }
        return this.textColour;
    }

    public GuiLabel setHoverableTextCol(GuiColourProvider.HoverColour<Integer> texColGetter) {
        this.texColGetter = texColGetter;
        return this;
    }

    public GuiLabel setTextColGetter(GuiColourProvider<Integer> texColGetter) {
        this.texColGetter = hovering -> (Integer)texColGetter.getColour();
        return this;
    }

    public GuiLabel setTextColour(TextFormatting colour, TextFormatting colourHover) {
        return this.setTextColour(colour.func_211163_e(), colourHover.func_211163_e());
    }

    public GuiLabel setTextColour(int colour, int colourHover) {
        this.setHoverableTextCol(hovering -> hovering ? colourHover : colour);
        return this;
    }

    public GuiLabel setTextColour(int colour) {
        if (this.texColGetter != null) {
            int hover = this.texColGetter.getColour(true);
            this.setHoverableTextCol(hovering -> hovering ? hover : colour);
        }
        this.setHoverableTextCol(hovering -> colour);
        return this;
    }

    public GuiLabel setTextColour(TextFormatting colour) {
        this.setTextColour(colour.func_211163_e());
        return this;
    }

    @Override
    public void renderElement(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        super.renderElement(mc, mouseX, mouseY, partialTicks);
        String displayString = this.getLabelText();
        if (!displayString.isEmpty()) {
            int colour = this.getTextColour(mouseOver);
            int widthLimit = this.rotation == GuiAlign.TextRotation.NORMAL || this.rotation == GuiAlign.TextRotation.ROT_180 ? this.getInsetRect().width : this.getInsetRect().height;
            ((Object)((Object)this.fontRenderer)).getClass();
            int ySize = 9;
            if (this.wrap && !this.trim) {
                ySize = this.fontRenderer.func_78267_b(displayString, widthLimit);
            }
            boolean wrap = this.wrap && this.fontRenderer.func_78256_a(displayString) > widthLimit;
            int yPos = this.getInsetRect().y + this.getInsetRect().height / 2 - ySize / 2;
            int xPos = this.getInsetRect().x;
            switch (this.rotation) {
                case NORMAL: {
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.midTrim, this.hasShadow());
                    break;
                }
                case ROT_CC: {
                    xPos = this.getInsetRect().x + this.getInsetRect().width / 2 - ySize / 2;
                    yPos = this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.midTrim, this.hasShadow());
                    break;
                }
                case ROT_C: {
                    xPos = this.getInsetRect().x + this.getInsetRect().width / 2 - ySize / 2;
                    yPos = this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, displayString, xPos + ySize, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.midTrim, this.hasShadow());
                    break;
                }
                case ROT_180: {
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.midTrim, this.hasShadow());
                }
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public GuiLabel setWidthFromText() {
        int textWidth = this.fontRenderer.func_78256_a(this.getLabelText());
        this.setXSize(textWidth + this.getInsets().left + this.getInsets().right);
        return this;
    }

    public GuiLabel setWidthFromText(int ySize) {
        this.setYSize(ySize);
        return this.setWidthFromText();
    }

    public GuiLabel setHeightForText() {
        int textHeight = this.fontRenderer.func_78267_b(this.getLabelText(), this.getInsetRect().width);
        this.setYSize(textHeight + this.getInsets().top + this.getInsets().bottom);
        return this;
    }

    public GuiLabel setHeightForText(int xSize) {
        this.setXSize(xSize);
        return this.setHeightForText();
    }
}

