/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSelectDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.text.TextFormatting;

public class StandardDialog<T>
extends GuiSelectDialog<T> {
    private int maxWidth = 0;
    private int maxHeight = 0;
    private GuiLabel heading;
    private boolean autoHeight = true;
    private boolean autoNormalize = true;
    private int renderHeight;
    private boolean draggable;

    public StandardDialog(GuiElement<?> parent) {
        super(parent);
        this.setInsets(3, 3, 3, 3);
        this.setPlayClickSound(true);
        this.setReloadOnSelection(true);
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
        this.addBackGroundChild(((DialogBackground)new DialogBackground(() -> this.heading != null).setPos(this)).bindSize(this, false));
        GuiSlideControl scrollBar = this.getScrollElement().getVerticalScrollBar();
        scrollBar.setBackgroundElement(new DialogBar(true));
        scrollBar.setSliderElement(new DialogBar(false));
        ((GuiSlideControl)scrollBar.setXSize(5)).setInsets(0, 0, 0, 0);
        scrollBar.updateElements();
    }

    @Override
    public void reloadElement() {
        if (this.autoHeight) {
            int height = this.sectionElements.values().stream().mapToInt(GuiElement::ySize).sum() + (this.heading == null ? 6 : 17);
            this.setYSize(height);
        }
        super.reloadElement();
        if (this.maxWidth > 0) {
            this.setXSize(Math.min(this.xSize(), this.maxWidth));
        }
        if (this.maxHeight > 0) {
            this.setYSize(Math.min(this.ySize(), this.maxHeight));
        }
        if (this.draggable) {
            this.setDragBar(this.heading == null ? 3 : 12);
        }
        if (this.autoNormalize) {
            this.normalizePosition();
        }
    }

    public StandardDialog<T> setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public StandardDialog<T> setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public StandardDialog<T> setMaxSize(int maxWidth, int maxHeight) {
        this.setMaxWidth(maxWidth);
        this.setMaxHeight(maxHeight);
        return this;
    }

    public StandardDialog<T> setHeading(String headingText) {
        return this.setHeading(() -> headingText);
    }

    public StandardDialog<T> setHeading(Supplier<String> headingSupplier) {
        this.heading = new GuiLabel(headingSupplier);
        this.heading.setPos(this.xPos() + 4, this.yPos() + 4);
        this.heading.setYSize(8);
        this.heading.setXSizeMod(() -> this.xSize() - 8);
        this.heading.setAlignment(GuiAlign.LEFT);
        this.addChild(this.heading);
        this.setInsets(14, 3, 3, 3);
        return this;
    }

    public StandardDialog<T> setDefaultRenderer(Function<T, String> nameSupplier) {
        this.setRendererBuilder(e -> {
            GuiLabel label = new GuiLabel(() -> (String)nameSupplier.apply(e));
            label.setResetHoverOnClick(true);
            label.setInsets(0, 2, 0, 2);
            label.setYSize(10);
            label.setTextColour(TextFormatting.GRAY, TextFormatting.YELLOW);
            label.setAlignment(GuiAlign.LEFT);
            GuiToolkit.addHoverHighlight(label, 0, 0, 0, 0, false);
            return label;
        });
        this.onReload(d -> {
            int height = d.getItems().size() * 10 + (this.heading == null ? 6 : 17);
            int width = d.getItems().stream().map(nameSupplier).mapToInt(e -> this.fontRenderer.func_78256_a((String)e)).max().orElse(50);
            width = Math.max(width, this.heading == null ? 0 : this.fontRenderer.func_78256_a(this.heading.getLabelText())) + (height > d.ySize() ? 15 : 10);
            d.setXSize(width);
        }, false);
        this.renderHeight = 10;
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    public StandardDialog<T> setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    public StandardDialog<T> setAutoNormalize(boolean autoNormalize) {
        this.autoNormalize = autoNormalize;
        return this;
    }

    public StandardDialog<T> setDraggable(boolean draggable) {
        this.draggable = draggable;
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    @Override
    public StandardDialog<T> setToolTipHandler(BiConsumer<T, GuiElement<?>> toolTipHandler) {
        return (StandardDialog)super.setToolTipHandler(toolTipHandler);
    }

    @Override
    public StandardDialog<T> addItem(T item) {
        super.addItem(item);
        return this;
    }

    @Override
    public StandardDialog<T> addItem(T item, @Nullable GuiElement<?> itemRenderer) {
        super.addItem(item, itemRenderer);
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    @Override
    public StandardDialog<T> addItems(Map<T, GuiElement<?>> itemMap) {
        super.addItems(itemMap);
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    @Override
    public StandardDialog<T> addItems(Collection<T> itemMap) {
        super.addItems(itemMap);
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    @Override
    public StandardDialog<T> addItemAt(T item, int index, @Nullable GuiElement<?> itemRenderer) {
        super.addItemAt(item, index, itemRenderer);
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    @Override
    public StandardDialog<T> removeItem(T item) {
        super.removeItem(item);
        if (this.isVisible()) {
            this.reloadElement();
        }
        return this;
    }

    public static class DialogBar
    extends GuiElement<DialogBar> {
        private boolean background;
        private Supplier<Boolean> dragging = () -> false;

        public DialogBar(boolean background) {
            this.background = background;
        }

        @Override
        public void reloadElement() {
            super.reloadElement();
            GuiElement parent = this.getParent();
            if (parent instanceof GuiSlideControl) {
                this.dragging = ((GuiSlideControl)parent)::isDragging;
            }
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            if (this.background && (this.dragging.get().booleanValue() || this.isMouseOver(mouseX, mouseY))) {
                this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos(), this.xSize() - 1, this.ySize(), 817054207);
            } else if (!this.background) {
                this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos(), this.xSize() - 1, this.ySize(), -1934409217);
            }
            getter.func_228461_a_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public static class DialogBackground
    extends GuiElement<DialogBackground> {
        private final Supplier<Boolean> hasHeading;

        public DialogBackground(Supplier<Boolean> hasHeading) {
            this.hasHeading = hasHeading;
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            int backgroundColor = -267386864;
            int borderColorStart = -1862270977;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos(), this.xSize() - 2, 1.0, backgroundColor, backgroundColor);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos() + this.ySize() - 1, this.xSize() - 2, 1.0, backgroundColor, backgroundColor);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos(), this.yPos() + 1, 1.0, this.ySize() - 2, backgroundColor, backgroundColor);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + this.xSize() - 1, this.yPos() + 1, 1.0, this.ySize() - 2, backgroundColor, backgroundColor);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos() + 1, this.xSize() - 2, this.ySize() - 2, backgroundColor, backgroundColor);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos() + 1, 1.0, this.ySize() - 2, borderColorStart, borderColorEnd);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + this.xSize() - 2, this.yPos() + 1, 1.0, this.ySize() - 2, borderColorStart, borderColorEnd);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + 2, this.yPos() + 1, this.xSize() - 4, 1.0, borderColorStart, borderColorStart);
            this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + 2, this.yPos() + this.ySize() - 2, this.xSize() - 4, 1.0, borderColorEnd, borderColorEnd);
            if (this.hasHeading.get().booleanValue()) {
                this.drawGradient((IRenderTypeBuffer)getter, this.xPos() + 2, this.yPos() + 12, this.xSize() - 4, 1.0, borderColorStart, borderColorStart);
            }
            getter.func_228461_a_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }
}

