/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui;

import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GuiToolkit<T extends Screen> {
    private static final String INTERNAL_TRANSLATION_PREFIX = "gui_tkt.brandonscore.";
    private static Map<String, ResourceLocation> resourceCache = new HashMap<String, ResourceLocation>();
    private List<GuiElement<?>> jeiExclusions = new ArrayList();
    private T gui;
    private GuiLayout layout;
    private ContainerSlotLayout slotLayout;
    private String translationPrefix = "";
    public static final int DEFAULT_WIDTH = 176;
    public static final int WIDE_WIDTH = 200;
    public static final int EXTRA_WIDE_WIDTH = 250;
    public static final int DEFAULT_HEIGHT = 166;
    public static final int TALL_HEIGHT = 200;
    public static final int EXTRA_TALL_HEIGHT = 250;

    public GuiToolkit(T gui, GuiLayout layout) {
        this(gui, layout.xSize, layout.ySize);
        this.layout = layout;
        if (layout == GuiLayout.CUSTOM) {
            throw new UnsupportedOperationException("For custom gui size use the alternate constructor that allows you to specify the size");
        }
    }

    public GuiToolkit(T gui, int xSize, int ySize) {
        this.gui = gui;
        this.layout = GuiLayout.CUSTOM;
        ((IModularGui)this.gui).setUISize(xSize, ySize);
        ((IModularGui)gui).getManager().setJeiExclusions(() -> this.jeiExclusions);
        if (gui instanceof ModularGuiContainer && ((ModularGuiContainer)gui).func_212873_a_() instanceof ContainerBCore) {
            this.setSlotLayout(((ContainerBCore)((ModularGuiContainer)gui).func_212873_a_()).getSlotLayout());
        }
    }

    public GuiToolkit<T> setTranslationPrefix(String translationPrefix) {
        if (!translationPrefix.endsWith(".")) {
            translationPrefix = translationPrefix + ".";
        }
        this.translationPrefix = translationPrefix;
        return this;
    }

    public String i18n(String translationKey) {
        if (translationKey.startsWith(".")) {
            translationKey = translationKey.substring(1);
        }
        return I18n.func_135052_a((String)(this.translationPrefix + translationKey), (Object[])new Object[0]);
    }

    protected static String i18ni(String translationKey) {
        if (translationKey.startsWith(".")) {
            translationKey = translationKey.substring(1);
        }
        return I18n.func_135052_a((String)(INTERNAL_TRANSLATION_PREFIX + translationKey), (Object[])new Object[0]);
    }

    public Supplier<String> i18n(Supplier<String> translationKey) {
        return () -> I18n.func_135052_a((String)(this.translationPrefix + (String)translationKey.get()), (Object[])new Object[0]);
    }

    public GuiLayout getLayout() {
        return this.layout;
    }

    public void setSlotLayout(ContainerSlotLayout slotLayout) {
        this.slotLayout = slotLayout;
    }

    public GuiButton createRSSwitch(IRSSwitchable switchable) {
        GuiButton button = new GuiButton();
        GuiToolkit.addHoverHighlight(button);
        button.setHoverTextDelay(10);
        button.setSize(12, 12);
        GuiTexture icon = new GuiTexture(12, 12, () -> BCSprites.get("redstone/" + switchable.getRSMode().name().toLowerCase(Locale.ENGLISH)));
        button.addChild(icon);
        icon.setYPosMod(button::yPos);
        button.setHoverText(element -> GuiToolkit.i18ni("rs_mode." + switchable.getRSMode().name().toLowerCase(Locale.ENGLISH)));
        button.onButtonPressed(pressed -> switchable.setRSMode(switchable.getRSMode().next(Screen.func_231173_s_() || pressed == 1)));
        return button;
    }

    public GuiButton createRSSwitch(GuiElement parent, IRSSwitchable switchable) {
        GuiButton button = this.createRSSwitch(switchable);
        parent.addChild(button);
        return button;
    }

    public GuiTexture createBackground(boolean addToManager, boolean center) {
        if (this.layout.xSize == -1 || this.layout.ySize == -1) {
            throw new UnsupportedOperationException("Layout type " + (Object)((Object)this.layout) + " does not have an associated default background.");
        }
        GuiTexture texture = new GuiTexture(() -> BCSprites.getThemed(this.layout.textureName()));
        texture.setSize(this.layout.xSize, this.layout.ySize);
        if (addToManager) {
            ((IModularGui)this.gui).getManager().addChild(texture);
        }
        if (center) {
            texture.onReload(guiTex -> {
                GuiTexture cfr_ignored_0 = (GuiTexture)guiTex.setPos(((IModularGui)this.gui).guiLeft(), ((IModularGui)this.gui).guiTop());
            });
        }
        return texture;
    }

    public GuiTexture createBackground(boolean center) {
        return this.createBackground(false, center);
    }

    public GuiTexture createBackground() {
        return this.createBackground(false);
    }

    public GuiLabel createHeading(String unlocalizedHeading, @Nullable GuiElement parent, boolean layout) {
        GuiLabel heading = new GuiLabel(I18n.func_135052_a((String)unlocalizedHeading, (Object[])new Object[0]));
        heading.setTextColGetter(Palette.BG::text);
        heading.setShadowStateSupplier(() -> BCConfig.darkMode);
        if (parent != null) {
            parent.addChild(heading);
            if (layout) {
                ((GuiLabel)heading.setSize(parent.xSize(), 8)).setAlignment(GuiAlign.CENTER).setRelPos(parent, 0, 4);
            }
        }
        return heading;
    }

    public GuiLabel createHeading(String unlocalizedHeading, @Nullable GuiElement parent) {
        return this.createHeading(unlocalizedHeading, parent, false);
    }

    public GuiLabel createHeading(String unlocalizedHeading) {
        return this.createHeading(unlocalizedHeading, null, false);
    }

    public GuiElement createSlots(GuiElement parent, final int columns, final int rows, final int spacing, final BiFunction<Integer, Integer, ContainerSlotLayout.SlotData> slotMapper, final RenderMaterial background) {
        GuiElement element = new GuiElement(){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                int y;
                int x;
                super.renderElement(minecraft, mouseX, mouseY, partialTicks);
                RenderMaterial slot = BCSprites.getThemed("slot");
                IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                IVertexBuilder buffer = getter.getBuffer(BCSprites.GUI_TYPE);
                for (x = 0; x < columns; ++x) {
                    for (y = 0; y < rows; ++y) {
                        this.drawSprite(buffer, this.xPos() + x * (18 + spacing), this.yPos() + y * (18 + spacing), 18.0f, 18.0f, slot.func_229314_c_());
                    }
                }
                if (background != null) {
                    for (x = 0; x < columns; ++x) {
                        for (y = 0; y < rows; ++y) {
                            ContainerSlotLayout.SlotData data;
                            if (slotMapper != null && (data = (ContainerSlotLayout.SlotData)slotMapper.apply(x, y)) != null && data.slot.func_75216_d()) continue;
                            this.drawSprite(buffer, this.xPos() + x * (18 + spacing), this.yPos() + y * (18 + spacing), 18.0f, 18.0f, background.func_229314_c_());
                        }
                    }
                }
                getter.func_228461_a_();
            }

            public GuiElement translate(int xAmount, int yAmount) {
                Object ret = super.translate(xAmount, yAmount);
                if (slotMapper != null) {
                    for (int x = 0; x < columns; ++x) {
                        for (int y = 0; y < rows; ++y) {
                            ContainerSlotLayout.SlotData data = (ContainerSlotLayout.SlotData)slotMapper.apply(x, y);
                            if (data == null) continue;
                            data.setPos(this.xPos() + x * (18 + spacing) - ((IModularGui)GuiToolkit.this.gui).guiLeft() + 1, this.yPos() + y * (18 + spacing) - ((IModularGui)GuiToolkit.this.gui).guiTop() + 1);
                        }
                    }
                }
                return ret;
            }

            public void quad(BufferBuilder buffer, int x, int y, int width, int height) {
                double zLevel = this.getRenderZLevel();
                buffer.func_225582_a_((double)x, (double)(y + height), zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_((double)(x + width), (double)y, zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)x, (double)y, zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
            }
        };
        element.setSize(columns * 18 + (columns - 1) * spacing, rows * 18 + (rows - 1) * spacing);
        if (parent != null) {
            parent.addChild(element);
        }
        return element;
    }

    public GuiElement createSlots(GuiElement parent, int columns, int rows, int spacing) {
        return this.createSlots(parent, columns, rows, spacing, null, null);
    }

    public GuiElement createSlots(GuiElement parent, int columns, int rows) {
        return this.createSlots(parent, columns, rows, 0);
    }

    public GuiElement createSlots(GuiElement parent, int columns, int rows, int spacing, RenderMaterial slotTexture) {
        return this.createSlots(parent, columns, rows, spacing, null, slotTexture);
    }

    public GuiElement createSlots(GuiElement parent, int columns, int rows, RenderMaterial slotTexture) {
        return this.createSlots(parent, columns, rows, 0, null, slotTexture);
    }

    public GuiElement createSlots(int columns, int rows) {
        return this.createSlots(null, columns, rows, 0);
    }

    public GuiElement createPlayerSlots(GuiElement parent, boolean title) {
        return this.createPlayerSlots(parent, title, false, false);
    }

    public GuiElement createPlayerSlots(GuiElement parent, boolean title, boolean addArmor, boolean addOffHand) {
        GuiElement container = new GuiElement();
        GuiElement main = this.createSlots(container, 9, 3, 0, this.slotLayout == null ? null : (column, row) -> this.slotLayout.getSlotData(ContainerSlotLayout.SlotType.PLAYER_INV, column + row * 9 + 9), null);
        GuiElement bar = this.createSlots(container, 9, 1, 0, this.slotLayout == null ? null : (column, row) -> this.slotLayout.getSlotData(ContainerSlotLayout.SlotType.PLAYER_INV, (int)column), null);
        bar.setYPos(main.maxYPos() + 3);
        if (title) {
            GuiLabel invTitle = new GuiLabel(GuiToolkit.i18ni("your_inventory"));
            invTitle.setAlignment(GuiAlign.LEFT).setHoverableTextCol(hovering -> Palette.BG.text());
            invTitle.setShadowStateSupplier(() -> BCConfig.darkMode);
            container.addChild(invTitle);
            invTitle.setSize(main.xSize(), 8);
            main.translate(0, 10);
            bar.translate(0, 10);
        }
        if (addArmor) {
            for (int i = 0; i < 4; ++i) {
                int finalI = 3 - i;
                GuiElement element = this.createSlots(container, 1, 1, 0, this.slotLayout == null ? null : (column, row) -> this.slotLayout.getSlotData(ContainerSlotLayout.SlotType.PLAYER_ARMOR, finalI), BCSprites.getArmorSlot(finalI));
                element.setMaxXPos(main.xPos() - 3, false);
                element.setYPos(main.yPos() + i * 19);
            }
        }
        if (addOffHand) {
            GuiElement element = this.createSlots(container, 1, 1, 0, this.slotLayout == null ? null : (column, row) -> this.slotLayout.getSlotData(ContainerSlotLayout.SlotType.PLAYER_OFF_HAND, 4), BCSprites.get("slots/armor_shield"));
            element.setXPos(main.maxXPos() + 3);
            element.setMaxYPos(bar.maxYPos(), false);
        }
        Rectangle rect = container.getEnclosingRect();
        container.setRawPos(rect.x, rect.y);
        container.setSize(rect);
        if (parent != null) {
            parent.addChild(container);
        }
        return container;
    }

    public GuiElement createEquipModSlots(GuiElement parent, PlayerEntity player, boolean jeiExclude, Predicate<ItemStack> showFilter) {
        GuiTexture fallback = new GuiElement();
        if (BrandonsCore.equipmentManager != null) {
            LazyOptional<IItemHandlerModifiable> optional = BrandonsCore.equipmentManager.getInventory((LivingEntity)player);
            GuiTexture container = GuiTexture.newDynamicTexture(() -> BCSprites.getThemed("bg_dynamic_small"));
            container.setXSize(26);
            optional.ifPresent(handler -> {
                if (jeiExclude) {
                    this.jeiExclude(container);
                }
                parent.addBackGroundChild(container);
                int c = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    int finalI = i;
                    ContainerSlotLayout.SlotData data = this.slotLayout.getSlotData(ContainerSlotLayout.SlotType.PLAYER_EQUIPMENT, finalI);
                    if (showFilter != null && !showFilter.test(data.slot.func_75211_c())) {
                        data.setPos(-9999, -9999);
                        continue;
                    }
                    GuiElement element = this.createSlots(container, 1, 1, 0, (column, row) -> data, null);
                    element.setXPos(container.xPos() + 4, false);
                    element.setYPos(container.yPos() + c * 19 + 4);
                    container.setMaxYPos(element.maxYPos() + 4, true);
                    ++c;
                }
            });
            return container.getChildElements().isEmpty() ? fallback : container;
        }
        return fallback;
    }

    public GuiElement createPlayerSlots() {
        return this.createPlayerSlots(null, true);
    }

    public GuiButton createVanillaButton(String unlocalizedText, @Nullable GuiElement parent) {
        GuiButton button = new GuiButton(I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]));
        button.setHoverTextDelay(10);
        button.enableVanillaRender();
        if (parent != null) {
            parent.addChild(button);
        }
        return button;
    }

    public GuiButton createVanillaButton(String unlocalizedText) {
        return this.createVanillaButton(unlocalizedText, null);
    }

    public GuiButton createBorderlessButton(String unlocalizedText) {
        return this.createBorderlessButton(null, unlocalizedText);
    }

    public GuiButton createBorderlessButton(@Nullable GuiElement parent, String unlocalizedText) {
        GuiButton button = new GuiButton(I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]));
        button.setInsets(5, 2, 5, 2);
        button.setHoverTextDelay(10);
        button.set3dText(true);
        GuiTexture texture = GuiTexture.newDynamicTexture(() -> BCSprites.getThemed("button_borderless" + (button.isPressed() ? "_invert" : "")));
        button.addChild(texture);
        GuiToolkit.addHoverHighlight(button, 0, 0, true);
        texture.bindSize(button, false);
        if (parent != null) {
            parent.addChild(button);
        }
        return button;
    }

    public GuiButton createButton(String unlocalizedText, @Nullable GuiElement parent, boolean inset3d) {
        return this.createButton(unlocalizedText, parent, inset3d, 1.0);
    }

    public GuiButton createButton(String unlocalizedText, @Nullable GuiElement parent, boolean inset3d, double doubleBoarder) {
        GuiButton button = new GuiButton(I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]));
        button.setInsets(5, 2, 5, 2);
        button.setHoverTextDelay(10);
        if (inset3d) {
            button.set3dText(true);
            GuiBorderedRect buttonBG = new GuiBorderedRect().setDoubleBorder(doubleBoarder);
            ((GuiBorderedRect)buttonBG.setPosModifiers(button::xPos, button::yPos)).setSizeModifiers(button::xSize, button::ySize);
            buttonBG.setFillColourL(hovering -> Palette.Ctrl.fill(hovering || button.isPressed()));
            buttonBG.setBorderColourL(Palette.Ctrl::border3D);
            buttonBG.set3dTopLeftColourL(hovering -> button.isPressed() ? Palette.Ctrl.accentDark(true) : Palette.Ctrl.accentLight(hovering));
            buttonBG.set3dBottomRightColourL(hovering -> button.isPressed() ? Palette.Ctrl.accentLight(true) : Palette.Ctrl.accentDark(hovering));
            GuiTexture disabledBG = GuiTexture.newDynamicTexture(BCSprites.themedGetter("button_disabled"));
            ((GuiTexture)disabledBG.setPosModifiers(button::xPos, button::yPos)).setSizeModifiers(button::xSize, button::ySize);
            disabledBG.setEnabledCallback(button::isDisabled);
            buttonBG.addChild(disabledBG);
            button.addChild(buttonBG);
        } else {
            button.setRectFillColourGetter((hovering, disabled) -> Palette.Ctrl.fill(hovering));
            button.setRectBorderColourGetter((hovering, disabled) -> Palette.Ctrl.border(hovering));
        }
        button.setTextColGetter((hovering, disabled) -> Palette.Ctrl.textH(hovering));
        if (parent != null) {
            parent.addChild(button);
        }
        return button;
    }

    public GuiButton createButton(String unlocalizedText, @Nullable GuiElement parent) {
        return this.createButton(unlocalizedText, parent, true);
    }

    public GuiButton createButton(String unlocalizedText, boolean shadeEdges) {
        return this.createButton(unlocalizedText, null, shadeEdges);
    }

    public GuiButton createButton(String unlocalizedText) {
        return this.createButton(unlocalizedText, null, true);
    }

    public GuiButton createThemeButton(GuiElement<?> parent) {
        GuiButton button = this.createThemedIconButton(parent, "theme");
        button.setHoverText(element -> BCConfig.darkMode ? GuiToolkit.i18ni("theme.light") : GuiToolkit.i18ni("theme.dark"));
        button.onPressed(() -> BCConfig.modifyClientProperty("darkMode", e -> e.setBoolean(!BCConfig.darkMode), new String[0]));
        return button;
    }

    public GuiButton createThemeButton() {
        return this.createThemeButton(null);
    }

    public GuiButton createResizeButton() {
        return this.createResizeButton(null);
    }

    public GuiButton createResizeButton(GuiElement<?> parent) {
        GuiButton button = this.createThemedIconButton(parent, "resize");
        button.setHoverText(element -> GuiToolkit.i18ni("large_view"));
        return button;
    }

    public GuiButton createGearButton() {
        return this.createGearButton(null);
    }

    public GuiButton createGearButton(GuiElement<?> parent) {
        GuiButton button = this.createThemedIconButton(parent, "gear");
        return button;
    }

    public GuiButton createAdvancedButton() {
        return this.createAdvancedButton(null);
    }

    public GuiButton createAdvancedButton(GuiElement<?> parent) {
        GuiButton button = this.createThemedIconButton(parent, "advanced");
        return button;
    }

    public GuiButton createThemedIconButton(GuiElement<?> parent, String iconString) {
        return this.createThemedIconButton(parent, 12, iconString);
    }

    public GuiButton createThemedIconButton(GuiElement<?> parent, int size, String iconString) {
        return this.createIconButton(parent, size, BCSprites.themedGetter(iconString));
    }

    public GuiButton createIconButton(GuiElement<?> parent, int size, Supplier<RenderMaterial> iconSupplier) {
        return this.createIconButton(parent, size, size, iconSupplier);
    }

    public GuiButton createIconButton(GuiElement<?> parent, int buttonSize, int iconSize, String iconString) {
        return this.createIconButton(parent, buttonSize, iconSize, BCSprites.getter(iconString));
    }

    public GuiButton createIconButton(GuiElement<?> parent, int buttonSize, int iconSize, Supplier<RenderMaterial> iconSupplier) {
        return this.createIconButton(parent, buttonSize, buttonSize, iconSize, iconSize, iconSupplier);
    }

    public GuiButton createIconButton(GuiElement<?> parent, int buttonWidth, int buttonHeight, int iconWidth, int iconHeight, String iconString) {
        return this.createIconButton(parent, buttonWidth, buttonHeight, iconWidth, iconHeight, BCSprites.getter(iconString));
    }

    public GuiButton createIconButton(GuiElement<?> parent, int buttonWidth, int buttonHeight, int iconWidth, int iconHeight, Supplier<RenderMaterial> iconSupplier) {
        GuiButton button = new GuiButton();
        button.setHoverTextDelay(10);
        button.setSize(buttonWidth, buttonHeight);
        GuiToolkit.addHoverHighlight(button);
        GuiTexture icon = new GuiTexture(iconWidth, iconHeight, iconSupplier);
        icon.setPosModifiers(() -> button.xPos() + -((iconWidth - buttonWidth) / 2), () -> button.yPos() + -((iconHeight - buttonHeight) / 2));
        button.addChild(icon);
        if (parent != null) {
            parent.addChild(button);
        }
        return button;
    }

    public static GuiBorderedRect addHoverHighlight(GuiElement button) {
        return GuiToolkit.addHoverHighlight(button, 0, 0);
    }

    public static GuiBorderedRect addHoverHighlight(GuiElement button, int xOversize, int yOversize) {
        return GuiToolkit.addHoverHighlight(button, xOversize / 2, yOversize / 2, false);
    }

    public static GuiBorderedRect addHoverHighlight(GuiElement button, int xOversize, int yOversize, boolean transparent) {
        return GuiToolkit.addHoverHighlight(button, xOversize, xOversize, yOversize, yOversize, transparent);
    }

    public static GuiBorderedRect addHoverHighlight(GuiElement button, int leftOversize, int rightOversize, int topOversize, int bottomOversize, boolean transparent) {
        GuiBorderedRect rect = new GuiBorderedRect();
        rect.setBorderColourL(hovering -> Palette.Ctrl.fill(hovering) & (transparent ? -2130706433 : -1));
        rect.setPosModifiers(() -> button.xPos() - leftOversize, () -> button.yPos() - topOversize);
        rect.setSizeModifiers(() -> button.xSize() + leftOversize + rightOversize, () -> button.ySize() + topOversize + bottomOversize);
        rect.setEnabledCallback(() -> button.getHoverTime() > 0);
        if (transparent) {
            button.addChild(rect);
        } else {
            button.addBackGroundChild(rect);
        }
        return rect;
    }

    public GuiElement createHighlightIcon(GuiElement parent, int xSize, int ySize, int xOversize, int yOversize, Supplier<RenderMaterial> matSupplier) {
        Object base = new GuiElement().setSize(xSize, ySize);
        GuiTexture icon = (GuiTexture)new GuiTexture(matSupplier).setSize(xSize, ySize);
        GuiToolkit.addHoverHighlight(base, xOversize, yOversize).setEnabledCallback(() -> base.getHoverTime() > 0);
        ((GuiElement)base).addChild((GuiTexture)icon);
        parent.addChild(base);
        return base;
    }

    public GuiElement createHighlightIcon(GuiElement parent, int xSize, int ySize, int xOversize, int yOversize, Supplier<RenderMaterial> matSupplier, Function<GuiElement, Boolean> highlight) {
        Object base = new GuiElement().setSize(xSize, ySize);
        GuiTexture icon = (GuiTexture)new GuiTexture(matSupplier).setSize(xSize, ySize);
        GuiToolkit.addHoverHighlight(base, xOversize, yOversize).setEnabledCallback(() -> (Boolean)highlight.apply((GuiElement)base));
        ((GuiElement)base).addChild((GuiTexture)icon);
        parent.addChild(base);
        return base;
    }

    public GuiEnergyBar createEnergyBar(GuiElement parent) {
        GuiEnergyBar energyBar = new GuiEnergyBar();
        if (parent != null) {
            parent.addChild(energyBar);
        }
        return energyBar;
    }

    public GuiEnergyBar createEnergyBar(GuiElement parent, IOPStorage storage) {
        GuiEnergyBar energyBar = new GuiEnergyBar();
        energyBar.setEnergyStorage(storage);
        if (parent != null) {
            parent.addChild(energyBar);
        }
        return energyBar;
    }

    public GuiEnergyBar createEnergyBar(IOPStorage storage) {
        return this.createEnergyBar(null, storage);
    }

    public GuiEnergyBar createEnergyBar() {
        return this.createEnergyBar((IOPStorage)null);
    }

    public InfoPanel createInfoPanel(GuiElement parent, boolean leftSide) {
        InfoPanel panel = new InfoPanel(parent, leftSide);
        parent.addChild(panel);
        this.jeiExclude(panel);
        return panel;
    }

    public GuiTextField createTextField() {
        return this.createTextField(null);
    }

    public GuiTextField createTextField(GuiElement parent) {
        return this.createTextField(parent, true);
    }

    public GuiTextField createTextField(GuiElement parent, boolean background) {
        GuiTextField textField = new GuiTextField();
        textField.setTextColor(Palette.Ctrl::text);
        textField.setShadow(false);
        textField.setEnableBackgroundDrawing(background);
        if (background) {
            textField.setFillColour(Palette.Ctrl::fill);
            textField.setBorderColour(hovering -> Palette.Ctrl.accentLight(false));
        }
        if (parent != null) {
            parent.addChild(textField);
        }
        return textField;
    }

    public GuiSlideControl createVanillaScrollBar(GuiSlideControl.SliderRotation rotation, boolean forceEnabled) {
        GuiSlideControl scrollBar = new GuiSlideControl(rotation);
        scrollBar.setBackgroundElement(GuiTexture.newDynamicTexture(BCSprites.themedGetter("button_disabled")));
        scrollBar.setSliderElement(GuiTexture.newDynamicTexture(BCSprites.themedGetter("button_borderless")));
        if (forceEnabled) {
            scrollBar.setEnabledCallback(() -> true);
        }
        scrollBar.onReload(GuiSlideControl::updateElements);
        return scrollBar;
    }

    public GuiSlideControl createVanillaScrollBar(GuiSlideControl.SliderRotation rotation) {
        return this.createVanillaScrollBar(rotation, true);
    }

    public GuiSlideControl createVanillaScrollBar() {
        return this.createVanillaScrollBar(GuiSlideControl.SliderRotation.VERTICAL, true);
    }

    public void center(GuiElement element, GuiElement centerOn, int xOffset, int yOffset) {
        element.setXPos(centerOn.xPos() + (centerOn.xSize() - element.xSize()) / 2 + xOffset);
        element.setYPos(centerOn.yPos() + (centerOn.ySize() - element.ySize()) / 2 + yOffset);
    }

    public void center(GuiElement element, int xPos, int yPos) {
        element.setXPos(xPos - element.xSize() / 2);
        element.setYPos(yPos - element.ySize() / 2);
    }

    public void centerX(GuiElement element, GuiElement centerOn, int xOffset) {
        element.setXPos(centerOn.xPos() + (centerOn.xSize() - element.xSize()) / 2 + xOffset);
    }

    public void centerY(GuiElement element, GuiElement centerOn, int yOffset) {
        element.setYPos(centerOn.yPos() + (centerOn.ySize() - element.ySize()) / 2 + yOffset);
    }

    public <TEM extends IGuiTemplate> TEM loadTemplate(TEM template) {
        template.addElements(((IModularGui)this.gui).getManager(), this);
        return template;
    }

    public void placeInside(GuiElement element, GuiElement placeInside, LayoutPos position, int xOffset, int yOffset) {
        switch (position) {
            case TOP_LEFT: {
                element.setRelPos(placeInside, xOffset, yOffset);
                break;
            }
            case TOP_CENTER: {
                element.setRelPos(placeInside, (placeInside.xSize() - element.xSize()) / 2 + xOffset, yOffset);
                break;
            }
            case TOP_RIGHT: {
                element.setRelPos(placeInside, placeInside.xSize() - element.xSize() + xOffset, yOffset);
                break;
            }
            case MIDDLE_RIGHT: {
                element.setRelPos(placeInside, placeInside.xSize() - element.xSize() + xOffset, (placeInside.ySize() - element.ySize()) / 2 + yOffset);
                break;
            }
            case BOTTOM_RIGHT: {
                element.setRelPos(placeInside, placeInside.xSize() - element.xSize() + xOffset, placeInside.ySize() - element.ySize() + yOffset);
                break;
            }
            case BOTTOM_CENTER: {
                element.setRelPos(placeInside, (placeInside.xSize() - element.xSize()) / 2 + xOffset, placeInside.ySize() - element.ySize() + yOffset);
                break;
            }
            case BOTTOM_LEFT: {
                element.setRelPos(placeInside, xOffset, placeInside.ySize() - element.ySize() + yOffset);
                break;
            }
            case MIDDLE_LEFT: {
                element.setRelPos(xOffset, (placeInside.ySize() - element.ySize()) / 2 + yOffset);
            }
        }
    }

    public void placeOutside(GuiElement element, GuiElement placeOutside, LayoutPos position, int xOffset, int yOffset) {
        switch (position) {
            case TOP_LEFT: {
                element.setRelPos(placeOutside, -element.xSize() + xOffset, -element.ySize() + yOffset);
                break;
            }
            case TOP_CENTER: {
                element.setRelPos(placeOutside, (placeOutside.xSize() - element.xSize()) / 2 + xOffset, -element.ySize() + yOffset);
                break;
            }
            case TOP_RIGHT: {
                element.setRelPos(placeOutside, placeOutside.xSize() + xOffset, -element.ySize() + yOffset);
                break;
            }
            case MIDDLE_RIGHT: {
                element.setRelPos(placeOutside, placeOutside.xSize() + xOffset, (placeOutside.ySize() - element.ySize()) / 2 + yOffset);
                break;
            }
            case BOTTOM_RIGHT: {
                element.setRelPos(placeOutside, placeOutside.xSize() + xOffset, placeOutside.ySize() + yOffset);
                break;
            }
            case BOTTOM_CENTER: {
                element.setRelPos(placeOutside, (placeOutside.xSize() - element.xSize()) / 2 + xOffset, placeOutside.ySize() + yOffset);
                break;
            }
            case BOTTOM_LEFT: {
                element.setRelPos(placeOutside, -element.xSize() + xOffset, placeOutside.ySize() + yOffset);
                break;
            }
            case MIDDLE_LEFT: {
                element.setRelPos(-element.xSize() + xOffset, (placeOutside.ySize() - element.ySize()) / 2 + yOffset);
            }
        }
    }

    public void jeiExclude(GuiElement element) {
        this.jeiExclusions.add(element);
    }

    public static ResourceLocation getRS(String resource) {
        return resourceCache.computeIfAbsent(resource, s -> new ResourceLocation(resource));
    }

    public int guiLeft() {
        return ((IModularGui)this.gui).guiLeft();
    }

    public int guiTop() {
        return ((IModularGui)this.gui).guiTop();
    }

    public Predicate<String> catchyValidator(Predicate<String> predicate) {
        return s -> {
            try {
                return predicate.test((String)s);
            }
            catch (Throwable e) {
                return false;
            }
        };
    }

    public static abstract class Palette {

        public static class Ctrl {
            public static int fill(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -12100758 : -10191953;
                }
                return BCConfig.darkMode ? -10790053 : -8355712;
            }

            public static int border(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -5721887 : -16777216;
                }
                return BCConfig.darkMode ? -2894893 : -16777216;
            }

            public static int border3D(boolean hovering) {
                return -16777216;
            }

            public static int accentLight(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -9066302 : -5722143;
                }
                return BCConfig.darkMode ? -5723992 : -1;
            }

            public static int accentDark(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -14602177 : -11445622;
                }
                return BCConfig.darkMode ? -13619152 : -11184811;
            }

            public static int text() {
                return BCConfig.darkMode ? 14803941 : 0xFFFFFF;
            }

            public static int textH(boolean hovering) {
                return hovering ? (BCConfig.darkMode ? 0xFFFFA0 : 0xFFFFA0) : Ctrl.text();
            }
        }

        public static class SubItem {
            public static int fill() {
                return BCConfig.darkMode ? -10592410 : -4340017;
            }

            public static int accentLight() {
                return BCConfig.darkMode ? -8947585 : -1;
            }

            public static int accentDark() {
                return BCConfig.darkMode ? -12171442 : -11905184;
            }

            public static int text() {
                return BCConfig.darkMode ? 14606562 : 1974290;
            }

            public static int textH(boolean hovering) {
                return hovering ? (BCConfig.darkMode ? 0 : 0) : SubItem.text();
            }

            public static int border3d() {
                return BCConfig.darkMode ? -1 : -16777216;
            }
        }

        public static class Slot {
            public static int fill() {
                return BCConfig.darkMode ? -9803158 : -7631989;
            }

            public static int border3D(boolean hovering) {
                return BCConfig.darkMode ? -1 : -16777216;
            }

            public static int accentLight() {
                return BCConfig.darkMode ? -3947581 : -1;
            }

            public static int accentDark() {
                return BCConfig.darkMode ? -14013910 : -13158601;
            }

            public static int text() {
                return BCConfig.darkMode ? 14606562 : 1974311;
            }

            public static int textH(boolean hovering) {
                return hovering ? (BCConfig.darkMode ? 0 : 0) : Slot.text();
            }
        }

        public static class BG {
            public static int fill() {
                return BCConfig.darkMode ? -12829636 : -3750202;
            }

            public static int border() {
                return BCConfig.darkMode ? -15461356 : -16777216;
            }

            public static int accentLight() {
                return BCConfig.darkMode ? -10790053 : -1;
            }

            public static int accentDark() {
                return BCConfig.darkMode ? -14145496 : -11184811;
            }

            public static int text() {
                return BCConfig.darkMode ? 11514291 : 0x111111;
            }
        }
    }

    public static class InfoPanel
    extends GuiElement<InfoPanel> {
        private static AtomicBoolean globalExpanded = new AtomicBoolean(false);
        private Map<GuiElement, Dimension> elementsDimMap = new LinkedHashMap<GuiElement, Dimension>();
        private final GuiElement parent;
        private boolean leftSide = false;
        private boolean hasPI = true;
        private AtomicBoolean expanded;
        public double animState = 0.0;
        private Supplier<Point> origin;
        private GuiButton toggleButton;
        public String hoverText = GuiToolkit.i18ni("info_panel");

        public InfoPanel(GuiElement parent, boolean leftSide, AtomicBoolean expandedHolder) {
            this.parent = parent;
            this.leftSide = leftSide;
            this.expanded = expandedHolder;
            this.animState = this.isExpanded() ? 1.0 : -0.5;
            this.setEnabled(false);
            if (this.animState == -0.5) {
                this.setHoverText(this.hoverText);
            }
            this.updatePosSize();
            this.setHoverTextDelay(10);
        }

        public InfoPanel(GuiElement parent, boolean leftSide) {
            this(parent, leftSide, globalExpanded);
        }

        public void setExpandedHolder(AtomicBoolean expanded) {
            this.expanded = expanded;
            this.animState = this.isExpanded() ? 1.0 : -0.5;
            this.setHoverTextEnabled(false);
            if (this.animState == -0.5) {
                this.setHoverText(this.hoverText);
                this.setHoverTextEnabled(true);
            }
        }

        public boolean isExpanded() {
            return this.expanded.get();
        }

        public void toggleExpanded() {
            this.expanded.set(!this.expanded.get());
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.toggleButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)new GuiButton().setHoverTextDelay(10)).setSize(12, 12)).onPressed(this::toggleExpanded).setPosModifiers(() -> this.getOrigin().x, () -> this.getOrigin().y)).setEnabledCallback(() -> this.origin != null || this.animState <= 0.0);
            GuiToolkit.addHoverHighlight(this.toggleButton);
            GuiTexture icon = (GuiTexture)new GuiTexture(12, 12, BCSprites.getter("info_panel")).setPosModifiers(() -> this.getOrigin().x, () -> this.getOrigin().y);
            this.toggleButton.addChild(icon);
            this.addChild(this.toggleButton);
        }

        @Override
        public void reloadElement() {
            super.reloadElement();
            if (this.isExpanded()) {
                this.updatePosSize();
            }
        }

        public void setOrigin(Supplier<Point> origin) {
            this.origin = origin;
        }

        public Point getOrigin() {
            if (this.origin == null) {
                int xPos = this.leftSide ? this.parent.xPos() - this.xSize() - 2 : this.parent.maxXPos() + 2;
                int yPos = this.parent.yPos() + (this.leftSide && this.hasPI ? 25 : 0);
                return new Point(xPos, yPos);
            }
            return this.origin.get();
        }

        public InfoPanel addElement(GuiElement element, Dimension preferredSize) {
            if (this.elementsDimMap.isEmpty()) {
                this.setEnabled(true);
            }
            this.elementsDimMap.put(element, preferredSize);
            this.addChild(element);
            this.updatePosSize();
            return this;
        }

        public InfoPanel addElement(GuiElement element) {
            return this.addElement(element, new Dimension(element.xSize(), element.ySize()));
        }

        public GuiLabel addDynamicLabel(Supplier<String> stringSupplier, Dimension preferredSize) {
            GuiLabel label = new GuiLabel().setAlignment(GuiAlign.LEFT);
            label.setSize(preferredSize.width, preferredSize.height);
            label.setDisplaySupplier(stringSupplier);
            this.addElement(label, preferredSize);
            return label;
        }

        public GuiLabel addDynamicLabel(Supplier<String> stringSupplier, int xSize, int ySize) {
            return this.addDynamicLabel(stringSupplier, new Dimension(xSize, ySize));
        }

        public GuiLabel addDynamicLabel(final Supplier<String> stringSupplier, int ySize) {
            final Dimension dimension = new Dimension(this.fontRenderer.func_78256_a(stringSupplier.get()), ySize);
            GuiLabel label = new GuiLabel(stringSupplier){

                @Override
                public boolean onUpdate() {
                    int lastWidth = dimension.width;
                    dimension.width = this.fontRenderer.func_78256_a((String)stringSupplier.get());
                    if (dimension.width != lastWidth) {
                        this.updatePosSize();
                    }
                    return super.onUpdate();
                }
            };
            label.setTrim(false);
            label.setAlignment(GuiAlign.LEFT);
            this.addElement(label, dimension);
            return label;
        }

        public GuiElement addLabeledValue(String labelText, final int valueOffset, int lineHeight, final Supplier<String> valueSupplier, final boolean multiLine) {
            final GuiElement container = new GuiElement();
            final GuiLabel label = new GuiLabel(labelText).setAlignment(GuiAlign.LEFT);
            label.setSize(multiLine ? this.fontRenderer.func_78256_a(labelText) : valueOffset, lineHeight);
            label.setWrap(true);
            container.addChild(label);
            String value = valueSupplier.get();
            ((Object)((Object)this.fontRenderer)).getClass();
            int extraHeiht = 9;
            if (value.contains("\n")) {
                String[] strs = value.split("\n");
                value = "";
                for (String s : strs) {
                    if (s.length() <= value.length()) continue;
                    ((Object)((Object)this.fontRenderer)).getClass();
                    extraHeiht += 9;
                    value = s;
                }
            }
            ((Object)((Object)this.fontRenderer)).getClass();
            final Dimension dimension = multiLine ? new Dimension(Math.max(label.xSize(), valueOffset + this.fontRenderer.func_78256_a(value)), lineHeight * 2 + (extraHeiht -= 9)) : new Dimension(valueOffset + this.fontRenderer.func_78256_a(value), lineHeight);
            GuiLabel valueLabel = new GuiLabel(){

                @Override
                public boolean onUpdate() {
                    int lastWidth = dimension.width;
                    String value = (String)valueSupplier.get();
                    if (value.contains("\n")) {
                        String[] strs = value.split("\n");
                        value = "";
                        for (String s : strs) {
                            if (s.length() <= value.length()) continue;
                            value = s;
                        }
                    }
                    dimension.width = multiLine ? Math.max(label.xSize(), valueOffset + this.fontRenderer.func_78256_a(value)) : valueOffset + this.fontRenderer.func_78256_a(value);
                    if (dimension.width != lastWidth) {
                        this.updatePosSize();
                    }
                    this.setMaxXPos(container.maxXPos(), true);
                    return super.onUpdate();
                }
            };
            valueLabel.setTrim(false);
            valueLabel.setAlignment(GuiAlign.LEFT);
            valueLabel.setDisplaySupplier(valueSupplier);
            valueLabel.setYSize(lineHeight);
            valueLabel.setXPos(valueOffset);
            valueLabel.setYPos(multiLine ? lineHeight : 0);
            container.addChild(valueLabel);
            this.addElement(container, dimension);
            return container;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            boolean ret = super.mouseClicked(mouseX, mouseY, mouseButton);
            if (!ret && this.isMouseOver(mouseX, mouseY)) {
                this.toggleExpanded();
                GuiButton.playGenericClick();
                return true;
            }
            return ret;
        }

        private void updatePosSize() {
            Dimension prefBounds = new Dimension();
            for (Dimension dim : this.elementsDimMap.values()) {
                prefBounds.width = Math.max(prefBounds.width, dim.width);
                prefBounds.height += dim.height;
            }
            Dimension actSize = prefBounds;
            int xPos = this.leftSide ? this.parent.xPos() - this.xSize() - 2 : this.parent.maxXPos() + 2;
            int yPos = this.parent.yPos() + (this.leftSide && this.hasPI ? 25 : 0);
            Rectangle bounds = new Rectangle(xPos, yPos, actSize.width + 8, actSize.height + 6);
            Point origin = this.getOrigin();
            Rectangle collapsed = new Rectangle(origin.x, origin.y, 12, 12);
            double animState = Math.max(0.0, this.animState);
            int sx = (int)MathUtils.map(animState, 0.0, 1.0, collapsed.x, bounds.x);
            int sy = (int)MathUtils.map(animState, 0.0, 1.0, collapsed.y, bounds.y);
            int sw = (int)MathUtils.map(animState, 0.0, 1.0, collapsed.width, bounds.width);
            int sh = (int)MathUtils.map(animState, 0.0, 1.0, collapsed.height, bounds.height);
            if (sx + sw > this.screenWidth) {
                sx -= sx + sw - this.screenWidth;
            }
            this.setPosAndSize(sx, sy, sw, sh);
            int y = yPos + 3;
            for (GuiElement element : this.elementsDimMap.keySet()) {
                if (animState >= 1.0) {
                    element.setEnabled(true);
                    element.setPos(this.xPos() + 4, y);
                    Dimension dim = this.elementsDimMap.get(element);
                    element.setXSize(Math.min(actSize.width, dim.width));
                    element.setYSize(Math.min((int)((double)actSize.height / (double)prefBounds.height * (double)dim.height), dim.height));
                    y += element.ySize();
                    continue;
                }
                element.setEnabled(false);
            }
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.toggleButton.renderElement(minecraft, mouseX, mouseY, partialTicks);
            double fadeAlpha = Math.min(1.0, (this.animState + 0.5) * 2.0);
            int col1 = 0x100010 | (int)(240.0 * fadeAlpha) << 24;
            int col2 = 0x80FF | (int)(176.0 * fadeAlpha) << 24;
            int col3 = 0x408F | (int)(128.0 * fadeAlpha) << 24;
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos() + 1, this.xSize(), this.ySize() - 2, col1);
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos(), this.xSize() - 2, this.ySize(), col1);
            this.drawGradientRect((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos() + 1, this.xPos() + this.xSize() - 1, this.yPos() + this.ySize() - 1, col2, col3);
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos() + 2, this.yPos() + 2, this.xSize() - 4, this.ySize() - 4, col1);
            getter.func_228461_a_();
            for (GuiElement element : this.childElements) {
                if (!element.isEnabled() || element == this.toggleButton) continue;
                element.preDraw(minecraft, mouseX, mouseY, partialTicks);
                element.renderElement(minecraft, mouseX, mouseY, partialTicks);
                element.postDraw(minecraft, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public boolean onUpdate() {
            if (this.isExpanded() && this.animState < 1.0) {
                this.animState = Math.min(1.0, this.animState + 0.2);
                this.setHoverTextEnabled(false);
                this.updatePosSize();
            } else if (!this.isExpanded() && this.animState > -0.5) {
                this.animState = Math.max(-0.5, this.animState - 0.2);
                if (this.animState == -0.5) {
                    this.setHoverText(this.hoverText);
                }
                this.updatePosSize();
            }
            return super.onUpdate();
        }

        public void clear() {
            this.elementsDimMap.keySet().forEach(this::removeChild);
            this.elementsDimMap.clear();
        }
    }

    public static enum LayoutPos {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_RIGHT,
        MIDDLE_LEFT,
        BOTTOM_RIGHT,
        BOTTOM_CENTER,
        BOTTOM_LEFT;

    }

    public static enum GuiLayout {
        DEFAULT(176, 166, false, false),
        WIDE(200, 166, true, false),
        TALL(176, 200, false, true),
        WIDE_TALL(200, 200, true, true),
        EXTRA_WIDE(250, 166, true, false),
        EXTRA_TALL(176, 250, false, true),
        EXTRA_WIDE_TALL(250, 200, true, true),
        WIDE_EXTRA_TALL(200, 250, true, true),
        EXTRA_WIDE_EXTRA_TALL(250, 250, true, true),
        CUSTOM(-1, -1, false, false);

        public final int xSize;
        public final int ySize;
        private final boolean wide;
        private final boolean tall;

        private GuiLayout(int xSize, int ySize, boolean wide, boolean tall) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.wide = wide;
            this.tall = tall;
        }

        public String textureName() {
            return "background-" + this.xSize + "x" + this.ySize;
        }

        public boolean isTall() {
            return this.tall;
        }

        public boolean isWide() {
            return this.wide;
        }

        public static GuiLayout getBestFit(int width, int height) {
            GuiLayout bestFit = EXTRA_WIDE_EXTRA_TALL;
            int widthDeviation = bestFit.xSize - width;
            int heightDeviation = bestFit.ySize - height;
            for (GuiLayout layout : GuiLayout.values()) {
                if (layout == CUSTOM) continue;
                int newXD = layout.xSize - width;
                int newYD = layout.ySize - height;
                if (newXD < 0 || newXD > widthDeviation && widthDeviation >= 0 || newYD < 0 || newYD > heightDeviation && heightDeviation >= 0) continue;
                bestFit = layout;
                widthDeviation = newXD;
                heightDeviation = newYD;
            }
            return bestFit;
        }
    }
}

