/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.blocks.SerializationFlags;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.IMCDataSerializable;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileCapabilityManager
implements ICapabilityProvider {
    private Map<Capability<?>, Map<Direction, LazyOptional<?>>> capabilityMap = new HashMap();
    private Map<Object, Predicate<Direction>> capSideValidator = new HashMap<Object, Predicate<Direction>>();
    private Map<INBTSerializable<CompoundNBT>, SerializationFlags<?>> serializableMap = new HashMap();
    private List<SerializationFlags<?>> indexedDataList = new ArrayList();
    private TileBCore tile;

    public TileCapabilityManager(TileBCore tile) {
        this.tile = tile;
    }

    public <T> void set(@Nonnull Capability<?> cap, @Nonnull T capInstance, Direction ... sides) {
        if (sides == null) {
            return;
        }
        if (sides.length == 0) {
            sides = Direction.values();
            this.setSide(cap, capInstance, null);
        }
        for (Direction dir : sides) {
            this.setSide(cap, capInstance, dir);
        }
    }

    public <T extends INBTSerializable<CompoundNBT>> SerializationFlags<T> setManaged(String tagName, @Nonnull Capability<?> cap, @Nonnull T capInstance, Direction ... sides) {
        this.set(cap, capInstance, sides);
        SerializationFlags<T> flags = new SerializationFlags<T>(tagName, capInstance);
        this.serializableMap.put(capInstance, flags);
        this.indexedDataList.add(flags);
        return flags;
    }

    public <T extends INBTSerializable<CompoundNBT>> SerializationFlags<T> setInternalManaged(String tagName, @Nonnull Capability<?> cap, @Nonnull T capInstance) {
        SerializationFlags<T> flags = new SerializationFlags<T>(tagName, capInstance);
        this.serializableMap.put(capInstance, flags);
        this.indexedDataList.add(flags);
        return flags;
    }

    public <T> void remove(@Nonnull Capability<T> cap, Direction ... sides) {
        if (sides.length == 0) {
            sides = Direction.values();
            this.clearSide(cap, null);
        }
        for (Direction dir : sides) {
            this.clearSide(cap, dir);
        }
    }

    public <T> void setSide(@Nonnull Capability<?> cap, @Nonnull T capInstance, @Nullable Direction side) {
        Map map = this.capabilityMap.computeIfAbsent(cap, c -> new HashMap());
        LazyOptional previous = (LazyOptional)map.get(side);
        map.put(side, LazyOptional.of(() -> capInstance));
        if (previous != null) {
            previous.invalidate();
        }
    }

    public <T> void clearSide(@Nonnull Capability<?> cap, @Nullable Direction side) {
        Map<Direction, LazyOptional<?>> map = this.capabilityMap.get(cap);
        if (map != null) {
            LazyOptional<?> previous = map.get(side);
            map.remove(side);
            if (previous != null) {
                previous.invalidate();
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<?> optional;
        Map<Direction, LazyOptional<?>> map = this.capabilityMap.get(cap);
        if (map == null && cap == CapabilityEnergy.ENERGY) {
            map = this.capabilityMap.get(CapabilityOP.OP);
        }
        if (map != null && map.containsKey(side) && (optional = map.get(side)).filter(o -> this.capSideValidator.getOrDefault(o, d -> true).test(side)).isPresent()) {
            return optional;
        }
        return LazyOptional.empty();
    }

    public void invalidate() {
        this.capabilityMap.values().forEach(map -> map.values().forEach(LazyOptional::invalidate));
    }

    public void setCapSideValidator(Object capabilityInstance, Predicate<Direction> predicate) {
        this.capSideValidator.put(capabilityInstance, predicate);
    }

    public CompoundNBT serialize(boolean forItem) {
        CompoundNBT compound = new CompoundNBT();
        for (SerializationFlags<?> helper : this.serializableMap.values()) {
            if ((!forItem || !helper.saveItem) && (forItem || !helper.saveTile)) continue;
            compound.func_218657_a(helper.tagName, helper.getData().serializeNBT());
        }
        return compound;
    }

    public void deserialize(CompoundNBT compound) {
        for (SerializationFlags<?> helper : this.serializableMap.values()) {
            if (!compound.func_74764_b(helper.tagName)) continue;
            helper.getData().deserializeNBT((INBT)compound.func_74775_l(helper.tagName));
        }
    }

    public void detectAndSendChanges() {
        for (int i = 0; i < this.indexedDataList.size(); ++i) {
            SerializationFlags<?> helper = this.indexedDataList.get(i);
            if (!helper.syncTile || !helper.hasChanged(true)) continue;
            PacketCustom packet = this.createCapPacket(helper, i);
            packet.sendToChunk((TileEntity)this.tile);
        }
    }

    public void detectAndSendChangesToListeners(List<IContainerListener> listeners) {
        for (int i = 0; i < this.indexedDataList.size(); ++i) {
            SerializationFlags<?> helper = this.indexedDataList.get(i);
            if (!helper.syncContainer || !helper.hasChanged(true)) continue;
            PacketCustom packet = this.createCapPacket(helper, i);
            DataUtils.forEachMatch(listeners, p -> p instanceof ServerPlayerEntity, p -> packet.sendToPlayer((ServerPlayerEntity)p));
        }
    }

    private PacketCustom createCapPacket(SerializationFlags<?> helper, int index) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, 8);
        packet.writePos(this.tile.func_174877_v());
        packet.writeInt(index);
        if (helper.getData() instanceof IMCDataSerializable) {
            ((IMCDataSerializable)helper.getData()).serializeMCD((MCDataOutput)packet);
        } else {
            packet.writeCompoundNBT((CompoundNBT)helper.getData().serializeNBT());
        }
        return packet;
    }

    public void receiveCapSyncData(MCDataInput input) {
        int index = input.readInt();
        if (index >= 0 && index < this.indexedDataList.size()) {
            SerializationFlags<?> helper = this.indexedDataList.get(index);
            if (helper.getData() instanceof IMCDataSerializable) {
                ((IMCDataSerializable)helper.getData()).deSerializeMCD(input);
            } else {
                helper.getData().deserializeNBT((INBT)input.readCompoundNBT());
            }
        }
    }
}

