/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.render;

import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;

public class GuiHelper {
    public static final RenderType transColourType = RenderType.func_228632_a_((String)"ghv2_trans_colour", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228723_a_(RenderState.field_228520_l_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));

    public static void drawHoverRect(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double width, double height, int backgroundColor, int borderColorStart, int borderColorEnd, boolean empty) {
        GuiHelper.drawGradient(getter, mStack, x + 1.0, y, width - 2.0, 1.0, backgroundColor, backgroundColor);
        GuiHelper.drawGradient(getter, mStack, x + 1.0, y + height - 1.0, width - 2.0, 1.0, backgroundColor, backgroundColor);
        GuiHelper.drawGradient(getter, mStack, x, y + 1.0, 1.0, height - 2.0, backgroundColor, backgroundColor);
        GuiHelper.drawGradient(getter, mStack, x + width - 1.0, y + 1.0, 1.0, height - 2.0, backgroundColor, backgroundColor);
        if (!empty) {
            GuiHelper.drawGradient(getter, mStack, x + 1.0, y + 1.0, width - 2.0, height - 2.0, backgroundColor, backgroundColor);
        }
        GuiHelper.drawGradient(getter, mStack, x + 1.0, y + 1.0, 1.0, height - 2.0, borderColorStart, borderColorEnd);
        GuiHelper.drawGradient(getter, mStack, x + width - 2.0, y + 1.0, 1.0, height - 2.0, borderColorStart, borderColorEnd);
        GuiHelper.drawGradient(getter, mStack, x + 2.0, y + 1.0, width - 4.0, 1.0, borderColorStart, borderColorStart);
        GuiHelper.drawGradient(getter, mStack, x + 2.0, y + height - 2.0, width - 4.0, 1.0, borderColorEnd, borderColorEnd);
    }

    public static void drawHoverRect(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double width, double height, int backgroundColor, int borderColor, boolean empty) {
        int borderColorEnd = (borderColor & 0xFEFEFE) >> 1 | borderColor & 0xFF000000;
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, backgroundColor, borderColor, borderColorEnd, empty);
    }

    public static void drawHoverRect(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double width, double height, boolean empty) {
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, -267386864, 0x505000FF, empty);
    }

    public static void drawHoverRect(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double width, double height, int backgroundColor, int borderColor) {
        int borderColorEnd = (borderColor & 0xFEFEFE) >> 1 | borderColor & 0xFF000000;
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, backgroundColor, borderColor, borderColorEnd, false);
    }

    public static void drawHoverRect(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double width, double height) {
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, -267386864, 0x505000FF, false);
    }

    public static void drawGradient(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double width, double height, int startColor, int endColor) {
        GuiHelper.drawGradientRect(getter, mStack, x, y, x + width, y + height, startColor, endColor);
    }

    public static void drawRect(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double width, double height, int colour) {
        GuiHelper.drawGradientRect(getter, mStack, x, y, x + width, y + height, colour, colour);
    }

    public static void drawGradientRect(IRenderTypeBuffer getter, MatrixStack mStack, double left, double top, double right, double bottom, int startColor, int endColor) {
        if (startColor == endColor && endColor == 0) {
            return;
        }
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(transColourType), mStack);
        builder.func_225582_a_(right, top, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(left, top, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(left, bottom, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_(right, bottom, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
    }

    public static void drawMultiPassGradientRect(IRenderTypeBuffer getter, MatrixStack mStack, double left, double top, double right, double bottom, int startColor, int endColor, int layers) {
        if (startColor == endColor && endColor == 0) {
            return;
        }
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(transColourType), mStack);
        for (int i = 0; i < layers; ++i) {
            builder.func_225582_a_(right, top, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            builder.func_225582_a_(left, top, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            builder.func_225582_a_(left, bottom, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            builder.func_225582_a_(right, bottom, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        }
    }

    public static void drawSprite(IVertexBuilder builder, double x, double y, double width, double height, TextureAtlasSprite sprite) {
        builder.func_225582_a_(x, y + height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_(x + width, y + height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_(x + width, y, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        builder.func_225582_a_(x, y, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
    }

    public static void drawSprite(IVertexBuilder builder, double x, double y, double width, double height, TextureAtlasSprite sprite, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        GuiHelper.drawSprite(builder, x, y, width, height, sprite, red, green, blue, alpha);
    }

    public static void drawSprite(IVertexBuilder builder, double x, double y, double width, double height, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        builder.func_225582_a_(x, y + height, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_(x + width, y + height, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_(x + width, y, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        builder.func_225582_a_(x, y, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
    }

    public static void drawPartialSprite(IVertexBuilder builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV) {
        float sW = sprite.func_94212_f() - sprite.func_94209_e();
        float sH = sprite.func_94210_h() - sprite.func_94206_g();
        float uMin = sprite.func_94209_e() + sW * (float)minU;
        float uMax = sprite.func_94209_e() + sW * (float)maxU;
        float vMin = sprite.func_94206_g() + sH * (float)minV;
        float vMax = sprite.func_94206_g() + sH * (float)maxV;
        builder.func_225582_a_(x, y + height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMax).func_181675_d();
        builder.func_225582_a_(x + width, y + height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMax).func_181675_d();
        builder.func_225582_a_(x + width, y, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMin).func_181675_d();
        builder.func_225582_a_(x, y, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMin).func_181675_d();
    }

    public static void drawPartialSprite(IVertexBuilder builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV, double texWidth, double texHeight) {
        GuiHelper.drawPartialSprite(builder, x, y, width, height, sprite, minU / texHeight, minV / texHeight, maxU / texWidth, maxV / texHeight);
    }

    public static void drawPartialSprite(IVertexBuilder builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV, float red, float green, float blue, float alpha) {
        float sW = sprite.func_94212_f() - sprite.func_94209_e();
        float sH = sprite.func_94210_h() - sprite.func_94206_g();
        float uMin = sprite.func_94209_e() + sW * (float)minU;
        float uMax = sprite.func_94209_e() + sW * (float)maxU;
        float vMin = sprite.func_94206_g() + sH * (float)minV;
        float vMax = sprite.func_94206_g() + sH * (float)maxV;
        builder.func_225582_a_(x, y + height, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(uMin, vMax).func_181675_d();
        builder.func_225582_a_(x + width, y + height, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(uMax, vMax).func_181675_d();
        builder.func_225582_a_(x + width, y, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(uMax, vMin).func_181675_d();
        builder.func_225582_a_(x, y, 0.0).func_227885_a_(red, green, blue, alpha).func_225583_a_(uMin, vMin).func_181675_d();
    }

    public static void drawPartialSprite(IVertexBuilder builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV, double texWidth, double texHeight, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        GuiHelper.drawPartialSprite(builder, x, y, width, height, sprite, minU / texHeight, minV / texHeight, maxU / texWidth, maxV / texHeight, red, green, blue, alpha);
    }

    public static void drawTexture(IVertexBuilder builder, double x, double y, double width, double height) {
        builder.func_225582_a_(x, y + height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + width, y + height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + width, y, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_(x, y, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    public static void drawPieProgress(IRenderTypeBuffer getter, MatrixStack mStack, double x, double y, double diameter, double progress, double offsetAngle, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        double radius = diameter / 2.0;
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(GuiHelperOld.FAN_TYPE), mStack);
        builder.func_225582_a_(x + radius, y + radius, 0.0).func_225586_a_(0, 255, 255, 64).func_181675_d();
        for (double d = 0.0; d <= 1.0; d += 0.03333333333333333) {
            double angle = d * progress + 0.5 - progress;
            angle *= Math.PI * 2;
            double vertX = x + radius + Math.sin(angle += 0.017453292519943 * offsetAngle) * radius;
            double vertY = y + radius + Math.cos(angle) * radius;
            builder.func_225582_a_(vertX, vertY, 0.0).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX < (double)(x + xSize) && mouseY >= (double)y && mouseY < (double)(y + ySize);
    }

    public static boolean isInRect(double x, double y, double xSize, double ySize, double mouseX, double mouseY) {
        return mouseX >= x && mouseX < x + xSize && mouseY >= y && mouseY < y + ySize;
    }

    public static RenderType guiTextureType(ResourceLocation resource) {
        return RenderType.func_228632_a_((String)"gui_resource", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resource, false, false)).func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228713_a_(RenderState.field_228517_i_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    }
}

