/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.power;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.api.power.IOTracker;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class IOTrackerSelfTimed
extends IOTracker {
    protected int lastInputTick = 0;
    protected int lastOutputTick = 0;

    public IOTrackerSelfTimed(int averageTime) {
        super(averageTime);
    }

    public IOTrackerSelfTimed() {
        super(20);
    }

    @Override
    public void energyInserted(long amount) {
        int tick = TimeKeeper.getServerTick();
        this.zeroSkippedTicks(this.inputArray, this.lastInputTick, tick);
        if (tick != this.lastInputTick) {
            this.lastInputTick = tick;
            this.inputArray[tick % this.inputArray.length] = 0L;
        }
        int n = tick % this.inputArray.length;
        this.inputArray[n] = this.inputArray[n] + amount;
    }

    @Override
    public void energyExtracted(long amount) {
        int tick = TimeKeeper.getServerTick();
        this.zeroSkippedTicks(this.outputArray, this.lastInputTick, tick);
        if (tick != this.lastOutputTick) {
            this.lastOutputTick = tick;
            this.outputArray[tick % this.outputArray.length] = 0L;
        }
        int n = tick % this.outputArray.length;
        this.outputArray[n] = this.outputArray[n] + amount;
    }

    @Override
    public void energyModified(long amount) {
        if (amount > 0L) {
            this.energyInserted(amount);
        } else {
            this.energyExtracted(amount * -1L);
        }
    }

    private void zeroSkippedTicks(long[] array, int lastUpdateTick, int currentTick) {
        if (currentTick > lastUpdateTick) {
            for (int i = 1; i < Math.min(currentTick - lastUpdateTick, array.length + 1); ++i) {
                array[(lastUpdateTick + i) % array.length] = 0L;
            }
        }
    }

    @Override
    public long currentInput() {
        if (EffectiveSide.get().isClient()) {
            return this.inputPerTick;
        }
        int tick = TimeKeeper.getServerTick();
        if (tick != this.lastInputCheck) {
            this.zeroSkippedTicks(this.inputArray, this.lastInputTick, tick);
            this.lastInputCheck = tick;
            this.inputPerTick = IOTrackerSelfTimed.averageLongArray(this.inputArray, tick % this.inputArray.length);
        }
        return this.inputPerTick;
    }

    @Override
    public long currentOutput() {
        if (EffectiveSide.get().isClient()) {
            return this.outputPerTick;
        }
        int tick = TimeKeeper.getServerTick();
        if (tick != this.lastOutputCheck) {
            this.zeroSkippedTicks(this.outputArray, this.lastOutputTick, tick);
            this.lastOutputCheck = tick;
            this.outputPerTick = IOTrackerSelfTimed.averageLongArray(this.outputArray, tick % this.inputArray.length);
        }
        return this.outputPerTick;
    }
}

