/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.AutoSwitchBlock;
import wile.rsgauges.blocks.EnvironmentalSensorSwitchBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class DayTimerSwitchBlock
extends AutoSwitchBlock {
    public DayTimerSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public DayTimerSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DayTimerSwitchTileEntity(ModContent.TET_DAYTIMER_SWITCH);
    }

    public static class DayTimerSwitchTileEntity
    extends EnvironmentalSensorSwitchBlock.EnvironmentalSensorSwitchTileEntity
    implements ITickableTileEntity {
        public DayTimerSwitchTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public DayTimerSwitchTileEntity() {
            super(ModContent.TET_DAYTIMER_SWITCH);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y, boolean show_only) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            SwitchBlock block = (SwitchBlock)state.func_177230_c();
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                double time_scaling = 0.3125;
                switch (field) {
                    case 1: {
                        double v = this.threshold0_on() + 0.3125 * (double)direction;
                        if (v < 0.0) {
                            v += 15.0;
                        } else if (v > 15.0) {
                            v = 0.0;
                        }
                        this.threshold0_on(v);
                        break;
                    }
                    case 2: {
                        double v = this.threshold0_off() + 0.3125 * (double)direction;
                        if (v < 0.0) {
                            v += 15.0;
                        } else if (v > 15.0) {
                            v = 0.0;
                        }
                        this.threshold0_off(v);
                        break;
                    }
                    case 3: {
                        this.debounce(this.debounce() + direction);
                        break;
                    }
                    case 4: {
                        this.on_power(this.on_power() + direction);
                    }
                }
                if (this.on_power() < 1) {
                    this.on_power(1);
                }
                this.func_70296_d();
            }
            StringTextComponent separator = new StringTextComponent(" | ");
            separator.func_240699_a_(TextFormatting.GRAY);
            ArrayList<Object> tr = new ArrayList<Object>();
            tr.add(Auxiliaries.localizable("switchconfig.daytimerclock.daytime_on", TextFormatting.BLUE, new Object[]{Auxiliaries.daytimeToString((long)(this.threshold0_on() * 24000.0 / 15.0))}));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.daytimerclock.daytime_off", TextFormatting.YELLOW, new Object[]{Auxiliaries.daytimeToString((long)(this.threshold0_off() * 24000.0 / 15.0))})));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.daytimerclock.output_power", TextFormatting.RED, new Object[]{this.on_power()})));
            if (this.debounce() > 0) {
                tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.daytimerclock.random", TextFormatting.DARK_GREEN, new Object[]{this.debounce()})));
            } else {
                tr.add(new StringTextComponent(""));
            }
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.daytimerclock.output_power", TextFormatting.RED, new Object[]{this.on_power()})));
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchconfig.daytimerclock", TextFormatting.RESET, tr.toArray()));
            return true;
        }

        @Override
        public void func_73660_a() {
            boolean active_setpoint;
            if (!this.func_145830_o() || this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 10) {
                this.update_interval_ = 10;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 5.0);
            BlockState state = this.func_195044_w();
            if (!(state.func_177230_c() instanceof DayTimerSwitchBlock)) {
                return;
            }
            boolean active = (Boolean)state.func_177229_b((Property)SwitchBlock.POWERED);
            long wt = this.field_145850_b.func_72820_D() % 24000L;
            double t = 6.25E-4 * (double)wt;
            if (this.threshold0_on() == this.threshold0_off()) {
                active_setpoint = false;
            } else if (this.threshold0_on() < this.threshold0_off()) {
                active_setpoint = t >= this.threshold0_on() && t <= this.threshold0_off();
            } else {
                boolean bl = active_setpoint = t >= this.threshold0_on() && t <= 15.0 || t >= 0.0 && t <= this.threshold0_off();
            }
            if (active != active_setpoint) {
                if (this.debounce() <= 0) {
                    active = active_setpoint;
                } else {
                    double d1 = (1.0 - (double)this.debounce() / 9.0) * 0.7;
                    d1 *= d1;
                    if (Math.random() <= d1) {
                        active = active_setpoint;
                    }
                }
            }
            this.updateSwitchState(state, (DayTimerSwitchBlock)state.func_177230_c(), active, 0);
        }
    }
}

