/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.detail.BlockCategories;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Networking;
import wile.rsgauges.libmc.detail.OptionalRecipeCondition;
import wile.rsgauges.libmc.detail.Overlay;
import wile.rsgauges.libmc.detail.PlayerBlockInteraction;

@Mod(value="rsgauges")
public class ModRsGauges {
    public static final String MODID = "rsgauges";
    public static final String MODNAME = "Gauges and Switches";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup ITEMGROUP = new ItemGroup("tabrsgauges"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModContent.INDUSTRIAL_SMALL_LEVER);
        }
    };

    public ModRsGauges() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        OptionalRecipeCondition.init(MODID, LOGGER);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onConfigReload);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfig.COMMON_CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PlayerBlockInteraction.init(MODID, LOGGER);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static final void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static final void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.registerItems(event);
            ModContent.registerBlockItems(event);
        }

        @SubscribeEvent
        public static final void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            ModContent.registerTileEntities(event);
        }

        public static final void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        }

        public static final void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        }

        @SubscribeEvent
        public static final void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
            ModResources.registerSoundEvents(event);
        }

        public static void onSetup(FMLCommonSetupEvent event) {
            LOGGER.info("Registering recipe condition processor ...");
            CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
            Networking.init(ModRsGauges.MODID);
            ModContent.processRegisteredContent();
            BlockCategories.update();
        }

        public static void onClientSetup(FMLClientSetupEvent event) {
            Overlay.register();
            ModContent.processContentClientSide(event);
        }

        public static void onConfigLoad(ModConfig.Loading configEvent) {
            try {
                ModConfig.apply();
            }
            catch (Throwable e) {
                ModRsGauges.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }

        public static void onConfigReload(ModConfig.Reloading configEvent) {
            try {
                ModRsGauges.logger().info("Config file changed {}", (Object)configEvent.getConfig().getFileName());
                ModConfig.apply();
            }
            catch (Throwable e) {
                ModRsGauges.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }
    }
}

