/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.datagen.recipe.PneumaticCraftRecipeBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeBuilder
extends PneumaticCraftRecipeBuilder<RefineryRecipeBuilder> {
    private final FluidIngredient input;
    private final TemperatureRange operatingTemp;
    private final FluidStack[] outputs;

    public RefineryRecipeBuilder(FluidIngredient input, TemperatureRange operatingTemp, FluidStack ... outputs) {
        super(PneumaticRegistry.RL("refinery"));
        this.input = input;
        this.operatingTemp = operatingTemp;
        this.outputs = outputs;
    }

    @Override
    protected PneumaticCraftRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new RefineryRecipeResult(id);
    }

    public class RefineryRecipeResult
    extends PneumaticCraftRecipeBuilder.RecipeResult {
        RefineryRecipeResult(ResourceLocation id) {
            super(RefineryRecipeBuilder.this, id);
        }

        public void func_218610_a(JsonObject json) {
            json.add("input", RefineryRecipeBuilder.this.input.func_200304_c());
            json.add("temperature", (JsonElement)RefineryRecipeBuilder.this.operatingTemp.toJson());
            JsonArray o = new JsonArray();
            for (FluidStack f : RefineryRecipeBuilder.this.outputs) {
                o.add((JsonElement)ModCraftingHelper.fluidStackToJson(f));
            }
            json.add("results", (JsonElement)o);
        }
    }
}

