/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.upgrade;

import com.google.common.primitives.Ints;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradesDBSetup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;

public enum ApplicableUpgradesDB {
    INSTANCE;

    private final Map<ResourceLocation, List<Integer>> TILE_ENTITIES = new HashMap<ResourceLocation, List<Integer>>();
    private final Map<ResourceLocation, List<Integer>> ENTITIES = new HashMap<ResourceLocation, List<Integer>>();
    private final Map<ResourceLocation, List<Integer>> ITEMS = new HashMap<ResourceLocation, List<Integer>>();
    private final List<Integer> NO_UPGRADES = Ints.asList((int[])new int[EnumUpgrade.values().length]);

    public static ApplicableUpgradesDB getInstance() {
        return INSTANCE;
    }

    public void addApplicableUpgrades(TileEntityType<?> type, UpgradesDBSetup.Builder builder) {
        this.addUpgrades(this.TILE_ENTITIES, type.getRegistryName(), builder);
    }

    public void addApplicableUpgrades(EntityType<?> type, UpgradesDBSetup.Builder builder) {
        this.addUpgrades(this.ENTITIES, type.getRegistryName(), builder);
    }

    public void addApplicableUpgrades(Item item, UpgradesDBSetup.Builder builder) {
        this.addUpgrades(this.ITEMS, item.getRegistryName(), builder);
    }

    public int getMaxUpgrades(TileEntity te, EnumUpgrade upgrade) {
        if (te == null || upgrade == null) {
            return 0;
        }
        return this.TILE_ENTITIES.getOrDefault(te.func_200662_C().getRegistryName(), this.NO_UPGRADES).get(upgrade.ordinal());
    }

    public int getMaxUpgrades(Entity e, EnumUpgrade upgrade) {
        if (e == null || upgrade == null) {
            return 0;
        }
        return this.ENTITIES.getOrDefault(e.func_200600_R().getRegistryName(), this.NO_UPGRADES).get(upgrade.ordinal());
    }

    public int getMaxUpgrades(Item item, EnumUpgrade upgrade) {
        if (item == null || upgrade == null) {
            return 0;
        }
        return this.ITEMS.getOrDefault(item.getRegistryName(), this.NO_UPGRADES).get(upgrade.ordinal());
    }

    public Map<EnumUpgrade, Integer> getApplicableUpgrades(TileEntity te) {
        return this.getApplicableUpgrades(this.TILE_ENTITIES.getOrDefault(te.func_200662_C().getRegistryName(), this.NO_UPGRADES));
    }

    public Map<EnumUpgrade, Integer> getApplicableUpgrades(Entity e) {
        return this.getApplicableUpgrades(this.ENTITIES.getOrDefault(e.func_200600_R().getRegistryName(), this.NO_UPGRADES));
    }

    public Map<EnumUpgrade, Integer> getApplicableUpgrades(Item item) {
        return this.getApplicableUpgrades(this.ITEMS.getOrDefault(item.getRegistryName(), this.NO_UPGRADES));
    }

    private Map<EnumUpgrade, Integer> getApplicableUpgrades(List<Integer> l) {
        EnumMap<EnumUpgrade, Integer> res = new EnumMap<EnumUpgrade, Integer>(EnumUpgrade.class);
        for (EnumUpgrade upgrade : EnumUpgrade.values()) {
            int n = l.get(upgrade.ordinal());
            if (n <= 0) continue;
            res.put(upgrade, n);
        }
        return res;
    }

    private void addUpgrades(Map<ResourceLocation, List<Integer>> l, ResourceLocation key, UpgradesDBSetup.Builder builder) {
        List u = l.computeIfAbsent(key, k -> this.createArrayList());
        for (int i = 0; i < EnumUpgrade.values().length; ++i) {
            u.set(i, (Integer)u.get(i) + builder.upgrades().get(i));
        }
    }

    private List<Integer> createArrayList() {
        return Ints.asList((int[])new int[EnumUpgrade.values().length]);
    }
}

