/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SizeLimitedItemHandlerWrapper
implements IItemHandler {
    private final IItemHandler wrapped;
    private final int size;

    public SizeLimitedItemHandlerWrapper(IItemHandler wrapped) {
        this.wrapped = wrapped;
        this.size = this.findLastNonEmptySlot(wrapped) + 1;
    }

    private int findLastNonEmptySlot(IItemHandler h) {
        for (int i = h.getSlots() - 1; i >= 0; --i) {
            if (h.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int getSlots() {
        return this.size;
    }

    private void validateSlot(int slot) {
        if (slot >= this.size) {
            throw new IndexOutOfBoundsException("slot " + slot + " should be less than " + this.size);
        }
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlot(slot);
        return this.wrapped.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.validateSlot(slot);
        return this.wrapped.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlot(slot);
        return this.wrapped.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        this.validateSlot(slot);
        return this.wrapped.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        this.validateSlot(slot);
        return this.wrapped.isItemValid(slot, stack);
    }
}

