/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RayTraceUtils {
    public static RayTraceResult getEntityLookedObject(LivingEntity entity, double maxDistance) {
        Pair<Vector3d, Vector3d> vecs = RayTraceUtils.getStartAndEndLookVec(entity, maxDistance);
        RayTraceContext ctx = new RayTraceContext((Vector3d)vecs.getLeft(), (Vector3d)vecs.getRight(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity);
        return entity.field_70170_p.func_217299_a(ctx);
    }

    public static Pair<Vector3d, Vector3d> getStartAndEndLookVec(LivingEntity entity, double maxDistance) {
        Vector3d entityVec = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vector3d maxDistVec = entityVec.func_178787_e(entity.func_70676_i(1.0f).func_186678_a(maxDistance));
        return new ImmutablePair((Object)entity.func_174824_e(1.0f), (Object)maxDistVec);
    }

    public static RayTraceResult getMouseOverServer(LivingEntity lookingEntity, double range) {
        RayTraceResult result = RayTraceUtils.raytraceEntityBlocks(lookingEntity, range);
        double rangeSq = range * range;
        Pair<Vector3d, Vector3d> startAndEnd = RayTraceUtils.getStartAndEndLookVec(lookingEntity, (float)range);
        Vector3d eyePos = (Vector3d)startAndEnd.getLeft();
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            rangeSq = result.func_216347_e().func_72436_e(eyePos);
        }
        double rangeSq2 = rangeSq;
        Vector3d hitVec = null;
        Entity focusedEntity = null;
        Vector3d lookVec = lookingEntity.func_70040_Z().func_186678_a(range + 1.0);
        AxisAlignedBB box = lookingEntity.func_174813_aQ().func_72314_b(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
        for (Entity entity : lookingEntity.field_70170_p.func_175674_a((Entity)lookingEntity, box, Entity::func_70067_L)) {
            double rangeSq3;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            Optional vec = aabb.func_216365_b(eyePos, (Vector3d)startAndEnd.getRight());
            if (aabb.func_72318_a(eyePos)) {
                if (!(rangeSq2 >= 0.0)) continue;
                focusedEntity = entity;
                hitVec = vec.orElse(eyePos);
                rangeSq2 = 0.0;
                continue;
            }
            if (!vec.isPresent() || !((rangeSq3 = eyePos.func_72436_e((Vector3d)vec.get())) < rangeSq2) && rangeSq2 != 0.0) continue;
            if (entity == entity.func_184187_bx() && !entity.canRiderInteract()) {
                if (rangeSq2 != 0.0) continue;
                focusedEntity = entity;
                hitVec = (Vector3d)vec.get();
                continue;
            }
            focusedEntity = entity;
            hitVec = (Vector3d)vec.get();
            rangeSq2 = rangeSq3;
        }
        return focusedEntity != null && rangeSq2 < rangeSq ? new EntityRayTraceResult(focusedEntity, hitVec) : result;
    }

    private static RayTraceResult raytraceEntityBlocks(LivingEntity entity, double range) {
        Pair<Vector3d, Vector3d> startAndEnd = RayTraceUtils.getStartAndEndLookVec(entity, (float)range);
        RayTraceContext ctx = new RayTraceContext((Vector3d)startAndEnd.getLeft(), (Vector3d)startAndEnd.getRight(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity);
        return entity.field_70170_p.func_217299_a(ctx);
    }
}

