/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class IOHelper {
    public static LazyOptional<IItemHandler> getInventoryForTE(TileEntity te, Direction facing) {
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    public static LazyOptional<IItemHandler> getInventoryForTE(TileEntity te) {
        return IOHelper.getInventoryForTE(te, null);
    }

    public static LazyOptional<IFluidHandler> getFluidHandlerForTE(TileEntity te, Direction facing) {
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    public static LazyOptional<IFluidHandler> getFluidHandlerForTE(TileEntity te) {
        return IOHelper.getFluidHandlerForTE(te, null);
    }

    public static ItemStack extract(IItemHandler handler, ItemStack requestedStack, ExtractCount countType, boolean simulate, boolean matchNBT) {
        if (requestedStack.func_190926_b()) {
            return requestedStack;
        }
        if (handler != null) {
            int itemsFound = 0;
            ArrayList slotsOfInterest = Lists.newArrayList();
            for (int slot = 0; slot < handler.getSlots() && itemsFound < requestedStack.func_190916_E(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.func_190926_b() || !IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                if (countType == ExtractCount.FIRST_MATCHING) {
                    return handler.extractItem(slot, Math.min(requestedStack.func_190916_E(), stack.func_190916_E()), simulate);
                }
                itemsFound += stack.func_190916_E();
                slotsOfInterest.add(slot);
            }
            if (countType == ExtractCount.UP_TO || itemsFound >= requestedStack.func_190916_E()) {
                ItemStack exportedStack = ItemStack.field_190927_a;
                int itemsNeeded = requestedStack.func_190916_E();
                int totalExtracted = 0;
                Iterator iterator = slotsOfInterest.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                    int itemsSubtracted = Math.min(itemsNeeded, stack.func_190916_E());
                    if (itemsSubtracted > 0) {
                        exportedStack = stack;
                    }
                    itemsNeeded -= itemsSubtracted;
                    ItemStack extracted = handler.extractItem(slot, itemsSubtracted, simulate);
                    totalExtracted += extracted.func_190916_E();
                }
                exportedStack = exportedStack.func_77946_l();
                exportedStack.func_190920_e(totalExtracted);
                return exportedStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static boolean matchStacks(ItemStack stack1, ItemStack stack2, boolean matchNBT) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && (!matchNBT || ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2));
    }

    @Nonnull
    public static ItemStack insert(TileEntity tile, ItemStack itemStack, boolean simulate) {
        for (Direction side : Direction.values()) {
            ItemStack inserted = IOHelper.getInventoryForTE(tile, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack.func_77946_l(), (boolean)simulate)).orElse(ItemStack.field_190927_a);
            if (inserted.func_190916_E() >= itemStack.func_190916_E()) continue;
            return inserted;
        }
        return itemStack;
    }

    @Nonnull
    public static ItemStack insert(TileEntity tile, ItemStack itemStack, Direction side, boolean simulate) {
        return IOHelper.getInventoryForTE(tile, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack, (boolean)simulate)).orElse(itemStack);
    }

    @Nonnull
    public static ItemStack insert(ICapabilityProvider provider, ItemStack itemStack, Direction side, boolean simulate) {
        return provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack, (boolean)simulate)).orElse(itemStack);
    }

    public static boolean transferOneItem(IItemHandler input, IItemHandler output) {
        if (input == null || output == null) {
            return false;
        }
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack extracted = input.extractItem(i, 1, true);
            if (extracted.func_190926_b() || !ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)extracted, (boolean)false).func_190926_b()) continue;
            input.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static void insertOrDrop(World world, ItemStack stack, IItemHandler handler, Vector3d dropPos, boolean simulate) {
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        if (!remainder.func_190926_b() && !simulate) {
            ItemEntity item = new ItemEntity(world, dropPos.func_82615_a(), dropPos.func_82617_b(), dropPos.func_82616_c(), remainder);
            world.func_217376_c((Entity)item);
        }
    }

    public static int countItems(LazyOptional<IItemHandler> cap, Predicate<ItemStack> pred) {
        return cap.map(handler -> IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(pred).mapToInt(ItemStack::func_190916_E).sum()).orElse(0);
    }

    public static enum ExtractCount {
        EXACT,
        FIRST_MATCHING,
        UP_TO;

    }
}

