/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.inventory.ContainerVacuumTrap;
import me.desht.pneumaticcraft.common.item.ItemSpawnerCore;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRangedTE;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.RangeManager;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityVacuumTrap
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
INamedContainerProvider,
ISerializableTanks,
IRangedTE {
    static final String DEFENDER_TAG = "pneumaticcraft:defender";
    public static final int MEMORY_ESSENCE_AMOUNT = 100;
    private static final Set<EntityType<?>> entityBlacklist = new ObjectOpenHashSet();
    private static boolean needBlacklistRebuild = true;
    private final ItemSpawnerCore.SpawnerCoreItemHandler inv = new ItemSpawnerCore.SpawnerCoreItemHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inv);
    private final List<MobEntity> targetEntities = new ArrayList<MobEntity>();
    private final RangeManager rangeManager = new RangeManager(this, 0x60600060);
    @GuiSynced
    private final SmartSyncTank xpTank = new XPTank();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.xpTank);
    @DescSynced
    private boolean isCoreLoaded;
    @DescSynced
    public Problems problem = Problems.OK;

    public TileEntityVacuumTrap() {
        super((TileEntityType)ModTileEntities.VACUUM_TRAP.get(), 5.0f, 7.0f, 10000, 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.xpTank.tick();
        this.rangeManager.setRange(3 + this.getUpgrades(EnumUpgrade.RANGE));
        if (!this.field_145850_b.field_72995_K) {
            boolean bl = this.isCoreLoaded = this.inv.getStats() != null;
            if (this.isOpen() && this.isCoreLoaded && this.inv.getStats().getUnusedPercentage() > 0 && this.getPressure() <= this.getMinWorkingPressure()) {
                if ((this.field_145850_b.func_82737_E() & 0xFL) == 0L) {
                    this.scanForEntities();
                }
                Vector3d trapVec = Vector3d.func_237489_a_((Vector3i)this.field_174879_c);
                double min = this.field_145850_b.func_204610_c(this.field_174879_c).func_206886_c() == Fluids.field_204546_a ? 2.5 : 1.75;
                for (MobEntity e : this.targetEntities) {
                    if (!e.func_70089_S() || e.func_184216_O().contains(DEFENDER_TAG)) continue;
                    if (e.func_195048_a(trapVec) <= min) {
                        this.absorbEntity(e);
                        this.addAir((int)(10.0f * e.func_110143_aJ()));
                        continue;
                    }
                    e.func_70661_as().func_75492_a(trapVec.func_82615_a(), trapVec.func_82617_b(), trapVec.func_82616_c(), 1.2);
                }
            }
            this.problem = !this.isCoreLoaded ? Problems.NO_CORE : (this.inv.getStats().getUnusedPercentage() == 0 ? Problems.CORE_FULL : (!this.isOpen() ? Problems.TRAP_CLOSED : Problems.OK));
        } else if (this.isOpen() && this.isCoreLoaded && this.field_145850_b.field_73012_v.nextBoolean()) {
            ClientUtils.emitParticles(this.field_145850_b, this.field_174879_c, (IParticleData)ParticleTypes.field_197599_J);
        }
    }

    private void absorbEntity(MobEntity e) {
        int toAdd = 1;
        if (this.xpTank.getFluid().getAmount() >= 100) {
            toAdd += e.field_70170_p.field_73012_v.nextInt(3) + 1;
        }
        if (this.inv.getStats().addAmount(e.func_200600_R(), toAdd)) {
            e.func_70106_y();
            if (toAdd > 1) {
                this.xpTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
            }
            this.inv.getStats().serialize(this.inv.getStackInSlot(0));
            e.field_70170_p.func_184133_a(null, this.field_174879_c, SoundEvents.field_187814_ei, SoundCategory.BLOCKS, 1.0f, 2.0f);
            if (this.field_145850_b instanceof ServerWorld) {
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197613_f, e.func_226277_ct_(), e.func_226278_cu_() + 0.5, e.func_226281_cx_(), 5, 0.0, 1.0, 0.0, 0.0);
            }
        }
    }

    private void scanForEntities() {
        this.targetEntities.clear();
        this.targetEntities.addAll(this.field_145850_b.func_175647_a(MobEntity.class, this.rangeManager.getExtents(), this::isApplicable));
    }

    private boolean isApplicable(LivingEntity e) {
        return e.func_184222_aU() && !(e instanceof EntityDrone) && (!(e instanceof TameableEntity) || !((TameableEntity)e).func_70909_n()) && !TileEntityVacuumTrap.isEntityBlacklisted(e.func_200600_R());
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public IFluidTank getFluidTank() {
        return this.xpTank;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.xpTank);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inv;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == Direction.DOWN || side.func_176740_k() == this.getRotation().func_176740_k();
    }

    @Override
    public float getMinWorkingPressure() {
        return -0.5f;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerVacuumTrap(windowId, inv, this.func_174877_v());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inv.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inv.serializeNBT());
        return tag;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        if (!this.shouldPreserveStateOnBreak()) {
            super.getContentsToDrop(drops);
        }
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        if (preserveState) {
            blockEntityTag.func_218657_a("Items", (INBT)this.inv.serializeNBT());
        }
    }

    public boolean isOpen() {
        return this.func_195044_w().func_177230_c() == ModBlocks.VACUUM_TRAP.get() && (Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208193_t) != false;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.rangeManager.getExtents() : super.getRenderBoundingBox();
    }

    private static boolean isEntityBlacklisted(EntityType<?> type) {
        if (needBlacklistRebuild) {
            for (String id : (List)ConfigHelper.common().general.vacuumTrapBlacklist.get()) {
                try {
                    if (id.startsWith("#")) {
                        ITag tag = EntityTypeTags.func_219762_a().func_199910_a(new ResourceLocation(id.substring(1)));
                        if (tag != null) {
                            entityBlacklist.addAll(tag.func_230236_b_());
                            continue;
                        }
                        Log.warning("unknown entity type tag '%s' in pneumaticcraft-common.toml / vacuum_trap_blacklist", id);
                        continue;
                    }
                    ResourceLocation rl = new ResourceLocation(id);
                    if (ForgeRegistries.ENTITIES.containsKey(rl)) {
                        entityBlacklist.add((EntityType<?>)ForgeRegistries.ENTITIES.getValue(rl));
                        continue;
                    }
                    Log.warning("unknown entity type '%s' in pneumaticcraft-common.toml / vacuum_trap_blacklist", id);
                }
                catch (ResourceLocationException e) {
                    Log.error("bad resource location '%s' in pneumaticcraft-common.toml / vacuum_trap_blacklist", id);
                }
            }
            needBlacklistRebuild = false;
        }
        return entityBlacklist.contains(type);
    }

    public static void clearBlacklistCache() {
        needBlacklistRebuild = true;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onMobSpawn(LivingSpawnEvent.SpecialSpawn event) {
            if (!event.isCanceled() && event.getSpawner() != null) {
                event.getEntity().func_184211_a(TileEntityVacuumTrap.DEFENDER_TAG);
            }
        }
    }

    private class XPTank
    extends SmartSyncTank {
        public XPTank() {
            super(TileEntityVacuumTrap.this, 16000);
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().func_207185_a(PneumaticCraftTags.Fluids.EXPERIENCE);
        }
    }

    public static enum Problems implements ITranslatableEnum
    {
        OK,
        NO_CORE,
        CORE_FULL,
        TRAP_CLOSED;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.vacuum_trap." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

