/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.block.BlockUVLightBox;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerUVLightBox;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemEmptyPCB;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class TileEntityUVLightBox
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl<TileEntityUVLightBox>,
INamedContainerProvider {
    private static final String NBT_EXPOSURE = "pneumaticcraft:uv_exposure";
    public static final int INVENTORY_SIZE = 1;
    public static final int PCB_SLOT = 0;
    private static final List<RedstoneController.RedstoneMode<TileEntityUVLightBox>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<TileEntityUVLightBox>("standard.always", new ItemStack((IItemProvider)Items.field_151016_H), te -> true), new RedstoneController.ReceivingRedstoneMode<TileEntityUVLightBox>("standard.high_signal", new ItemStack((IItemProvider)Items.field_151137_ax), te -> te.getCurrentRedstonePower() > 0), new RedstoneController.ReceivingRedstoneMode<TileEntityUVLightBox>("standard.low_signal", new ItemStack((IItemProvider)Items.field_221764_cr), te -> te.getCurrentRedstonePower() == 0), new RedstoneController.ReceivingRedstoneMode<TileEntityUVLightBox>("uvLightBox.interpolate", new ItemStack((IItemProvider)Items.field_222029_iU), te -> te.getCurrentRedstonePower() > 0));
    public static final int RS_MODE_INTERPOLATE = 3;
    private long lastStateUpdate = 0L;
    private BlockState pendingState;
    @GuiSynced
    public final RedstoneController<TileEntityUVLightBox> rsController = new RedstoneController<TileEntityUVLightBox>(this, REDSTONE_MODES);
    @GuiSynced
    public int threshold = 100;
    private final UVInputHandler inputHandler = new UVInputHandler();
    private final ItemStackHandler outputHandler = new BaseItemStackHandler(this, 1);
    private final UVInvWrapper inventoryExt = new UVInvWrapper();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventoryExt);
    private LazyOptional<IItemHandler> cachedEjectHandler = LazyOptional.empty();
    public int ticksExisted;

    public TileEntityUVLightBox() {
        super((TileEntityType)ModTileEntities.UV_LIGHT_BOX.get(), 5.0f, 7.0f, 2000, 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            ++this.ticksExisted;
            ItemStack stack = this.getLoadedPCB();
            boolean didWork = false;
            if (this.rsController.getCurrentMode() == 3) {
                this.threshold = Math.min(100, 25 + this.rsController.getCurrentRedstonePower() * 5);
            }
            if (!stack.func_190926_b() && this.rsController.shouldRun()) {
                int progress = TileEntityUVLightBox.getExposureProgress(stack);
                if (this.getPressure() >= 1.0f && progress < 100) {
                    this.addAir((int)(-2.0f * this.getSpeedUsageMultiplierFromUpgrades()));
                    if (this.ticksExisted % this.ticksPerProgress(progress) == 0) {
                        TileEntityUVLightBox.setExposureProgress(stack, ++progress);
                    }
                    if (progress >= this.threshold && this.outputHandler.insertItem(0, this.inputHandler.getStackInSlot(0), true).func_190926_b()) {
                        ItemStack toMove = this.inputHandler.extractItem(0, 1, false);
                        this.outputHandler.insertItem(0, toMove, false);
                    }
                    didWork = true;
                }
            }
            if (this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
                this.tryEject();
            }
            this.checkStateUpdates(stack, didWork);
        }
    }

    private void checkStateUpdates(ItemStack loadedStack, boolean didWork) {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() == ModBlocks.UV_LIGHT_BOX.get()) {
            boolean loaded = (Boolean)state.func_177229_b((Property)BlockUVLightBox.LOADED);
            boolean update = false;
            if (loaded == loadedStack.func_190926_b()) {
                state = (BlockState)state.func_206870_a((Property)BlockUVLightBox.LOADED, (Comparable)Boolean.valueOf(!loadedStack.func_190926_b()));
                update = true;
            }
            if (didWork != (Boolean)this.func_195044_w().func_177229_b((Property)BlockUVLightBox.LIT)) {
                state = (BlockState)state.func_206870_a((Property)BlockUVLightBox.LIT, (Comparable)Boolean.valueOf(didWork));
                update = true;
            }
            long now = this.field_145850_b.func_82737_E();
            if (update) {
                if (now - this.lastStateUpdate > 10L) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, state);
                    this.pendingState = null;
                    this.lastStateUpdate = now;
                } else {
                    this.pendingState = state;
                }
            } else if (this.pendingState != null && now - this.lastStateUpdate > 10L) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.pendingState);
                this.pendingState = null;
                this.lastStateUpdate = now;
            }
        }
    }

    private void tryEject() {
        Direction dir = this.getUpgradeCache().getEjectDirection();
        if (dir != null) {
            this.getEjectionHandler().ifPresent(handler -> {
                ItemStack stack = this.outputHandler.extractItem(0, 1, true);
                if (!stack.func_190926_b() && ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false).func_190926_b()) {
                    this.outputHandler.extractItem(0, 1, false);
                }
            });
        }
    }

    private LazyOptional<IItemHandler> getEjectionHandler() {
        if (!this.cachedEjectHandler.isPresent()) {
            Direction dir = this.getUpgradeCache().getEjectDirection();
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            this.cachedEjectHandler = IOHelper.getInventoryForTE(te, dir.func_176734_d());
            if (this.cachedEjectHandler.isPresent()) {
                this.cachedEjectHandler.addListener(l -> {
                    this.cachedEjectHandler = LazyOptional.empty();
                });
            }
        }
        return this.cachedEjectHandler;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.threshold = tag.func_74762_e("threshold");
        this.inputHandler.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("threshold", this.threshold);
        nbt.func_218657_a("Items", (INBT)this.inputHandler.serializeNBT());
        return nbt;
    }

    public static int getExposureProgress(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e(NBT_EXPOSURE) : 0;
    }

    public static void setExposureProgress(ItemStack stack, int progress) {
        Validate.isTrue((progress >= 0 && progress <= 100 ? 1 : 0) != 0);
        stack.func_196082_o().func_74768_a(NBT_EXPOSURE, progress);
    }

    private int ticksPerProgress(int progress) {
        int ticks = progress < 20 ? 20 : (progress < 40 ? 40 : (progress < 60 ? 80 : (progress < 80 ? 160 : 300)));
        return Math.max(1, (int)((float)ticks / this.getSpeedMultiplierFromUpgrades()));
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onDescUpdate() {
        this.func_145831_w().func_72863_F().func_212863_j_().func_215568_a(this.func_174877_v());
        super.onDescUpdate();
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.threshold = MathHelper.func_76125_a((int)Integer.parseInt(tag), (int)1, (int)100);
            this.func_70296_d();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inputHandler;
    }

    public IItemHandler getOutputInventory() {
        return this.outputHandler;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public RedstoneController<TileEntityUVLightBox> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 1.0f;
    }

    private ItemStack getLoadedPCB() {
        return this.inputHandler.getStackInSlot(0);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerUVLightBox(i, playerInventory, this.func_174877_v());
    }

    public int getThreshold() {
        return this.threshold;
    }

    private class UVInvWrapper
    implements IItemHandler {
        UVInvWrapper() {
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? TileEntityUVLightBox.this.inputHandler.getStackInSlot(0) : TileEntityUVLightBox.this.outputHandler.getStackInSlot(0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? TileEntityUVLightBox.this.inputHandler.insertItem(0, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 1 ? TileEntityUVLightBox.this.outputHandler.extractItem(0, amount, simulate) : ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? TileEntityUVLightBox.this.inputHandler.getSlotLimit(0) : TileEntityUVLightBox.this.outputHandler.getSlotLimit(0);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? TileEntityUVLightBox.this.inputHandler.isItemValid(0, stack) : TileEntityUVLightBox.this.outputHandler.isItemValid(0, stack);
        }
    }

    private class UVInputHandler
    extends BaseItemStackHandler {
        UVInputHandler() {
            super(TileEntityUVLightBox.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemEmptyPCB && ItemEmptyPCB.getEtchProgress(itemStack) == 0;
        }
    }
}

