/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.debug.DroneDebugger;
import me.desht.pneumaticcraft.common.entity.EntityProgrammableController;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.inventory.ContainerProgrammableController;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityProgrammableController
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IDroneBase,
ISideConfigurable,
INamedContainerProvider {
    private static final int INVENTORY_SIZE = 1;
    private static final String FALLBACK_NAME = "[ProgController]";
    private static final UUID FALLBACK_UUID = UUID.nameUUIDFromBytes("[ProgController]".getBytes());
    private static final int MAX_ENERGY = 100000;
    public static final Set<ResourceLocation> BLACKLISTED_WIDGETS = ImmutableSet.of((Object)PneumaticRegistry.RL("computer_control"), (Object)PneumaticRegistry.RL("entity_attack"), (Object)PneumaticRegistry.RL("drone_condition_entity"), (Object)PneumaticRegistry.RL("standby"), (Object)PneumaticRegistry.RL("teleport"), (Object)PneumaticRegistry.RL("entity_export"), (Object[])new ResourceLocation[]{PneumaticRegistry.RL("entity_import")});
    private static final double SPEED_PER_UPGRADE = 0.05;
    private static final double BASE_SPEED = 0.15;
    private final ProgrammableItemStackHandler inventory = new ProgrammableItemStackHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    private final FluidTank tank = new FluidTank(16000);
    private final LazyOptional<IFluidHandler> tankCap = LazyOptional.of(() -> this.tank);
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final DroneItemHandler droneItemHandler = new DroneItemHandler(this, 1);
    private EntityProgrammableController drone;
    private DroneAIManager aiManager;
    private DroneFakePlayer fakePlayer;
    private final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final int[] redstoneLevels = new int[6];
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private CompoundNBT variablesNBT = null;
    @DescSynced
    private double targetX;
    @DescSynced
    private double targetY;
    @DescSynced
    private double targetZ;
    @DescSynced
    @LazySynced
    private double curX;
    @DescSynced
    @LazySynced
    private double curY;
    @DescSynced
    @LazySynced
    private double curZ;
    @DescSynced
    private int diggingX;
    @DescSynced
    private int diggingY;
    @DescSynced
    private int diggingZ;
    @DescSynced
    private int speedUpgrades;
    @DescSynced
    public boolean isIdle;
    @GuiSynced
    public boolean shouldChargeHeldItem;
    @DescSynced
    public String label = "";
    @DescSynced
    public String ownerNameClient = "";
    @GuiSynced
    private boolean chunkloadSelf = false;
    @GuiSynced
    private boolean chunkloadWorkingChunk = false;
    @GuiSynced
    private boolean chunkloadWorkingChunk3x3 = false;
    private ChunkPos prevChunkPos = null;
    private final Set<ChunkPos> loadedChunks = new HashSet<ChunkPos>();
    private UUID ownerID;
    private ITextComponent ownerName;
    private boolean updateNeighbours;
    private LogisticsManager logisticsManager;
    private final DroneDebugger debugger = new DroneDebugger(this);
    @DescSynced
    private int activeWidgetIndex;

    public TileEntityProgrammableController() {
        super((TileEntityType)ModTileEntities.PROGRAMMABLE_CONTROLLER.get(), 20.0f, 25.0f, 10000, 4);
        MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent(this));
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("droneInv", new ItemStack((IItemProvider)ModItems.DRONE.get()), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.droneItemHandler), SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("programmableInv", new ItemStack((IItemProvider)ModItems.NETWORK_API.get()), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.inventory), SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.setNullFaceHandler("droneInv");
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().field_72995_K && event.getWorld() == this.func_145831_w() && event.getSemiblock() instanceof EntityLogisticsFrame) {
            this.logisticsManager = null;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.updateNeighbours) {
            this.updateNeighbours();
            this.updateNeighbours = false;
        }
        double speed = 0.15 + (double)this.speedUpgrades * 0.05;
        if (PneumaticCraftUtils.distBetweenSq((Vector3i)this.func_174877_v(), this.targetX, this.targetY, this.targetZ) <= 1.0 && this.isIdle) {
            this.curX = this.targetX;
            this.curY = this.targetY;
            this.curZ = this.targetZ;
        } else if (PneumaticCraftUtils.distBetweenSq(this.curX, this.curY, this.curZ, this.targetX, this.targetY, this.targetZ) > 0.25) {
            Vector3d vec = new Vector3d(this.targetX - this.curX, this.targetY - this.curY, this.targetZ - this.curZ).func_72432_b().func_186678_a(speed);
            this.curX += vec.field_72450_a;
            this.curY += vec.field_72448_b;
            this.curZ += vec.field_72449_c;
        }
        if (!this.func_145831_w().field_72995_K) {
            DroneFakePlayer fp = this.getFakePlayer();
            for (int i = 0; i < 4; ++i) {
                fp.field_71134_c.func_73075_a();
            }
            fp.func_70107_b(this.curX, this.curY, this.curZ);
            ChunkPos newChunkPos = new ChunkPos((int)this.curX >> 4, (int)this.curZ >> 4);
            if (this.prevChunkPos == null || !this.prevChunkPos.equals((Object)newChunkPos)) {
                this.handleDynamicChunkloading(this.prevChunkPos, newChunkPos);
            }
            this.prevChunkPos = newChunkPos;
            fp.func_70071_h_();
            if (this.getPressure() >= this.getMinWorkingPressure()) {
                if (!this.isIdle) {
                    this.addAir(-10);
                    if (this.chunkloadWorkingChunk3x3) {
                        this.addAir(-30);
                    } else if (this.chunkloadWorkingChunk) {
                        this.addAir(-10);
                    }
                }
                if (this.chunkloadSelf) {
                    this.addAir(-10);
                }
                this.aiManager.onUpdateTasks();
                this.maybeChargeHeldItem();
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.debugger.updateDebuggingPlayers();
            }
        } else {
            if ((this.drone == null || !this.drone.func_70089_S()) && this.func_145831_w().isAreaLoaded(new BlockPos(this.curX, this.curY, this.curZ), 1)) {
                this.drone = (EntityProgrammableController)((EntityType)ModEntities.PROGRAMMABLE_CONTROLLER.get()).func_200721_a(this.func_145831_w());
                if (this.drone != null) {
                    this.drone.setController(this);
                    this.drone.func_70107_b(this.curX, this.curY, this.curZ);
                    ClientUtils.spawnEntityClientside((Entity)this.drone);
                }
            }
            this.drone.func_70107_b(this.curX, this.curY, this.curZ);
        }
    }

    private void handleDynamicChunkloading(ChunkPos oldPos, ChunkPos newPos) {
        for (int cx = newPos.field_77276_a - 1; cx <= newPos.field_77276_a + 1; ++cx) {
            for (int cz = newPos.field_77275_b - 1; cz <= newPos.field_77275_b + 1; ++cz) {
                ChunkPos cp = new ChunkPos(cx, cz);
                if (!this.shouldLoadChunk(cp)) continue;
                this.loadedChunks.add(cp);
            }
        }
        Iterator<ChunkPos> iter = this.loadedChunks.iterator();
        while (iter.hasNext()) {
            ChunkPos cp = iter.next();
            boolean load = this.shouldLoadChunk(cp);
            ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)this.field_145850_b), (String)"pneumaticcraft", (BlockPos)this.field_174879_c, (int)cp.field_77276_a, (int)cp.field_77275_b, (boolean)load, (boolean)false);
            if (load) continue;
            iter.remove();
        }
    }

    private boolean shouldLoadChunk(ChunkPos cp) {
        int cx = (int)this.curX >> 4;
        int cz = (int)this.curZ >> 4;
        return this.chunkloadSelf && cp.field_77276_a == this.field_174879_c.func_177958_n() >> 4 && cp.field_77275_b == this.field_174879_c.func_177952_p() >> 4 || this.chunkloadWorkingChunk && !this.isIdle && cp.field_77276_a == cx && cp.field_77275_b == cz || this.chunkloadWorkingChunk3x3 && !this.isIdle && cp.field_77276_a >= cx - 1 && cp.field_77276_a <= cx + 1 && cp.field_77275_b >= cz - 1 && cp.field_77275_b <= cz + 1;
    }

    private void maybeChargeHeldItem() {
        if (!this.shouldChargeHeldItem) {
            return;
        }
        ItemStack held = this.droneItemHandler.getStackInSlot(0);
        if (this.energy.getEnergyStored() > 100) {
            held.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
                if (handler.getMaxEnergyStored() - handler.getEnergyStored() > 250) {
                    handler.receiveEnergy(this.energy.extractEnergy(250, false), false);
                }
            });
        }
        held.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
            if (this.getPressure() > handler.getPressure() && handler.getPressure() < handler.maxPressure()) {
                int maxAir = (int)(handler.maxPressure() * (float)handler.getVolume());
                int toAdd = Math.min(250, maxAir - handler.getAir());
                handler.addAir(toAdd);
                this.airHandler.addAir(-toAdd);
            }
        });
    }

    @Override
    public void onVariableChanged(String varname, boolean isCoordinate) {
        this.func_70296_d();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b instanceof ServerWorld) {
            this.loadedChunks.forEach(cp -> ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)this.field_145850_b), (String)"pneumaticcraft", (BlockPos)this.field_174879_c, (int)cp.field_77276_a, (int)cp.field_77275_b, (boolean)false, (boolean)false));
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.itemHandlerSideConfigurator.invalidateCaps();
    }

    @Override
    public UUID getOwnerUUID() {
        if (this.ownerID == null) {
            this.ownerID = UUID.randomUUID();
            this.ownerName = new StringTextComponent("[Programmable Controller]");
            Log.warning(String.format("Programmable controller with owner '%s' has no UUID! Substituting a random UUID (%s).", this.ownerName, this.ownerID), new Object[0]);
        }
        return this.ownerID;
    }

    @Override
    public BlockPos getDeployPos() {
        return this.func_174877_v();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (tag.equals("charging")) {
            this.shouldChargeHeldItem = !this.shouldChargeHeldItem;
        } else if (tag.equals("chunkload_self")) {
            this.chunkloadSelf = !this.chunkloadSelf;
        } else if (tag.equals("chunkload_work")) {
            this.chunkloadWorkingChunk = !this.chunkloadWorkingChunk;
        } else if (tag.equals("chunkload_work_3x3")) {
            this.chunkloadWorkingChunk3x3 = !this.chunkloadWorkingChunk3x3;
        } else if (this.itemHandlerSideConfigurator.handleButtonPress(tag)) {
            this.updateNeighbours = true;
        }
        this.func_70296_d();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    public void setOwner(PlayerEntity ownerID) {
        this.ownerID = ownerID.func_110124_au();
        this.ownerName = ownerID.func_200200_C_();
        this.ownerNameClient = this.ownerName.getString();
    }

    @Override
    public List<SideConfigurator<?>> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerProgrammableController(i, playerInventory, this.func_174877_v());
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.calculateUpgrades();
        }
    }

    private void calculateUpgrades() {
        int newInvUpgrades;
        int oldInvUpgrades = this.droneItemHandler.getSlots() - 1;
        if (oldInvUpgrades != (newInvUpgrades = Math.min(35, this.getUpgrades(EnumUpgrade.INVENTORY)))) {
            this.resizeDroneInventory(oldInvUpgrades + 1, newInvUpgrades + 1);
            this.tank.setCapacity((newInvUpgrades + 1) * 16000);
            if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
                this.tank.getFluid().setAmount(this.tank.getCapacity());
            }
        }
        this.speedUpgrades = this.getUpgrades(EnumUpgrade.SPEED);
    }

    private void resizeDroneInventory(int oldSize, int newSize) {
        for (int i = newSize; i < oldSize; ++i) {
            ItemStack stack = this.droneItemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            this.droneItemHandler.setStackInSlot(i, ItemStack.field_190927_a);
            PneumaticCraftUtils.dropItemOnGround(stack, this.func_145831_w(), this.func_174877_v().func_177984_a());
        }
        this.droneItemHandler.setUseableSlots(newSize);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.tank.setCapacity((this.getUpgrades(EnumUpgrade.INVENTORY) + 1) * 16000);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.ownerID = tag.func_74764_b("ownerID") ? UUID.fromString(tag.func_74779_i("ownerID")) : FALLBACK_UUID;
        this.ownerName = tag.func_74764_b("ownerName") ? new StringTextComponent(tag.func_74779_i("ownerName")) : new StringTextComponent(FALLBACK_NAME);
        this.ownerNameClient = this.ownerName.getString();
        this.droneItemHandler.setUseableSlots(this.getUpgrades(EnumUpgrade.INVENTORY) + 1);
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT(tag.func_74775_l("droneItems"));
        for (int i = 0; i < Math.min(tmpInv.getSlots(), this.droneItemHandler.getSlots()); ++i) {
            this.droneItemHandler.setStackInSlot(i, tmpInv.getStackInSlot(i).func_77946_l());
        }
        this.energy.readFromNBT(tag);
        this.itemHandlerSideConfigurator.updateHandler("droneInv", (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.droneItemHandler));
        this.shouldChargeHeldItem = tag.func_74767_n("chargeHeld");
        this.variablesNBT = tag.func_74775_l("variables");
        this.chunkloadSelf = tag.func_74767_n("chunkload_self");
        this.chunkloadWorkingChunk = tag.func_74767_n("chunkload_work");
        this.chunkloadWorkingChunk3x3 = tag.func_74767_n("chunkload_work_3x3");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        CompoundNBT tankTag = new CompoundNBT();
        this.tank.writeToNBT(tankTag);
        tag.func_218657_a("tank", (INBT)tankTag);
        ItemStackHandler handler = new ItemStackHandler(this.droneItemHandler.getSlots());
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            handler.setStackInSlot(i, this.droneItemHandler.getStackInSlot(i));
        }
        tag.func_218657_a("droneItems", (INBT)handler.serializeNBT());
        if (this.ownerID != null) {
            tag.func_74778_a("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            tag.func_74778_a("ownerName", this.ownerName.getString());
        }
        this.energy.writeToNBT(tag);
        tag.func_74757_a("chargeHeld", this.shouldChargeHeldItem);
        if (this.aiManager != null) {
            tag.func_218657_a("variables", (INBT)this.aiManager.writeToNBT(new CompoundNBT()));
        }
        tag.func_74757_a("chunkload_self", this.chunkloadSelf);
        tag.func_74757_a("chunkload_work", this.chunkloadWorkingChunk);
        tag.func_74757_a("chunkload_work_3x3", this.chunkloadWorkingChunk3x3);
        return tag;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.tankCap);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemHandlerSideConfigurator.getHandler(side));
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.energyCap);
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.droneItemHandler.setFakePlayerReady();
        this.calculateUpgrades();
        this.inventory.onContentsChanged(0);
        this.curX = this.targetX = (double)this.func_174877_v().func_177958_n() + 0.5;
        this.curY = this.targetY = (double)this.func_174877_v().func_177956_o() + 1.0;
        this.curZ = this.targetZ = (double)this.func_174877_v().func_177952_p() + 0.5;
        if (this.chunkloadSelf) {
            ChunkPos cp = new ChunkPos(this.field_174879_c);
            ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)this.field_145850_b), (String)"pneumaticcraft", (BlockPos)this.field_174879_c, (int)cp.field_77276_a, (int)cp.field_77275_b, (boolean)true, (boolean)false);
            this.loadedChunks.add(cp);
        }
    }

    private static boolean isProgrammableAndValidForDrone(IDroneBase drone, ItemStack programmable) {
        if (programmable.func_77973_b() instanceof IProgrammable && ((IProgrammable)programmable.func_77973_b()).canProgram(programmable) && ((IProgrammable)programmable.func_77973_b()).usesPieces(programmable)) {
            List<IProgWidget> widgets = TileEntityProgrammer.getProgWidgets(programmable);
            return widgets.stream().allMatch(widget -> drone.isProgramApplicable(widget.getType()));
        }
        return false;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public IFluidTank getFluidTank() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.droneItemHandler;
    }

    @Override
    public Vector3d getDronePos() {
        if (this.curX == 0.0 && this.curY == 0.0 && this.curZ == 0.0) {
            this.curX = (double)this.func_174877_v().func_177958_n() + 0.5;
            this.curY = (double)this.func_174877_v().func_177956_o() + 1.0;
            this.curZ = (double)this.func_174877_v().func_177952_p() + 0.5;
            this.targetX = this.curX;
            this.targetY = this.curY;
            this.targetZ = this.curZ;
        }
        return new Vector3d(this.curX, this.curY, this.curZ);
    }

    public BlockPos getTargetPos() {
        return new BlockPos(this.targetX, this.targetY, this.targetZ);
    }

    @Override
    public BlockPos getControllerPos() {
        return this.field_174879_c;
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return new IPathNavigator(){

            @Override
            public boolean moveToXYZ(double x, double y, double z) {
                if (TileEntityProgrammableController.this.isBlockValidPathfindBlock(new BlockPos(x, y, z))) {
                    TileEntityProgrammableController.this.targetX = x + 0.5;
                    TileEntityProgrammableController.this.targetY = y - 0.3;
                    TileEntityProgrammableController.this.targetZ = z + 0.5;
                    return true;
                }
                return false;
            }

            @Override
            public boolean moveToEntity(Entity entity) {
                return this.moveToXYZ(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.3, entity.func_226281_cx_());
            }

            @Override
            public boolean hasNoPath() {
                return PneumaticCraftUtils.distBetweenSq(TileEntityProgrammableController.this.curX, TileEntityProgrammableController.this.curY, TileEntityProgrammableController.this.curZ, TileEntityProgrammableController.this.targetX, TileEntityProgrammableController.this.targetY, TileEntityProgrammableController.this.targetZ) < 0.5;
            }

            @Override
            public boolean isGoingToTeleport() {
                return false;
            }
        };
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
    }

    @Override
    public DroneFakePlayer getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = new DroneFakePlayer((ServerWorld)this.func_145831_w(), new GameProfile(this.getOwnerUUID(), this.ownerName.getString()), this);
            this.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(ServerLifecycleHooks.getCurrentServer(), (ServerPlayerEntity)this.fakePlayer);
        }
        return this.fakePlayer;
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        return !this.func_145831_w().func_180495_p(pos).func_215685_b((IBlockReader)this.func_145831_w(), pos, ISelectionContext.func_216377_a()).equals(VoxelShapes.func_197868_b());
    }

    @Override
    public void dropItem(ItemStack stack) {
        Vector3d pos = this.getDronePos();
        this.func_145831_w().func_217376_c((Entity)new ItemEntity(this.func_145831_w(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack));
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        super.getContentsToDrop(drops);
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            if (this.fakePlayer.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            drops.add((Object)this.fakePlayer.field_71071_by.func_70301_a(i).func_77946_l());
        }
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        if (pos != null) {
            this.diggingX = pos.func_177958_n();
            this.diggingY = pos.func_177956_o();
            this.diggingZ = pos.func_177952_p();
        } else {
            this.diggingZ = 0;
            this.diggingY = 0;
            this.diggingX = 0;
        }
    }

    public BlockPos getDugPosition() {
        return this.diggingX != 0 || this.diggingY != 0 || this.diggingZ != 0 ? new BlockPos(this.diggingX, this.diggingY, this.diggingZ) : null;
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.activeWidgetIndex = this.progWidgets.indexOf(widget);
    }

    public boolean isProgramApplicable(ProgWidgetType widgetType) {
        return !BLACKLISTED_WIDGETS.contains(widgetType.getRegistryName());
    }

    @Override
    public GoalSelector getTargetAI() {
        return null;
    }

    @Override
    public void setEmittingRedstone(Direction orientation, int emittingRedstone) {
        this.redstoneLevels[orientation.func_176745_a()] = emittingRedstone;
        this.updateNeighbours();
    }

    public int getEmittingRedstone(Direction direction) {
        return this.redstoneLevels[direction.func_176745_a()];
    }

    @Override
    public void setName(ITextComponent name) {
        ItemStack stack;
        if (this.drone != null) {
            this.drone.func_200203_b(name);
        }
        if (!(stack = this.inventory.getStackInSlot(0).func_77946_l()).func_190926_b()) {
            stack.func_200302_a(name);
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        Log.warning("Drone AI setting carrying entity. However a Programmable Controller can't carry entities!", new Object[0]);
        new Throwable().printStackTrace();
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAIOverridden() {
        return false;
    }

    @Override
    public void onItemPickupEvent(ItemEntity curPickingUpEntity, int stackSize) {
    }

    @Override
    public PlayerEntity getOwner() {
        if (this.ownerID == null) {
            return null;
        }
        if (this.func_145831_w().field_72995_K) {
            return ClientUtils.getClientPlayer();
        }
        return PneumaticCraftUtils.getPlayerFromId(this.ownerID);
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        ItemStack stack = this.inventory.extractItem(0, 1, false);
        if (stack.func_190916_E() == 1) {
            boolean inserted = this.findEjectionDest().map(h -> ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false).func_190926_b()).orElse(false);
            if (!inserted) {
                PneumaticCraftUtils.dropItemOnGround(stack, this.field_145850_b, this.field_174879_c.func_177984_a());
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)ModSounds.DRONE_DEATH.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((IParticleData)ParticleTypes.field_197601_L, (double)this.func_174877_v().func_177958_n() - 0.5, this.func_174877_v().func_177956_o() + 1, (double)this.func_174877_v().func_177952_p() - 0.5, 0.0, 0.0, 0.0, 10, 1.0, 1.0, 1.0), this);
    }

    @Override
    public DroneAIManager getAIManager() {
        if (!this.func_145831_w().field_72995_K && this.aiManager == null) {
            this.aiManager = new DroneAIManager(this, new ArrayList<IProgWidget>());
            this.aiManager.dontStopWhenEndReached();
            if (this.variablesNBT != null) {
                this.aiManager.readFromNBT(this.variablesNBT);
                this.variablesNBT = null;
            }
        }
        return this.aiManager;
    }

    @Override
    public void updateLabel() {
        this.label = this.aiManager != null ? this.getAIManager().getLabel() : "Main";
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    @Override
    public void playSound(SoundEvent soundEvent, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public void addAirToDrone(int air) {
        this.airHandler.addAir(air);
    }

    @Override
    public boolean canMoveIntoFluid(Fluid fluid) {
        return true;
    }

    @Override
    public DroneItemHandler getDroneItemHandler() {
        return this.droneItemHandler;
    }

    @Override
    public int getActiveWidgetIndex() {
        return this.activeWidgetIndex;
    }

    @Override
    public DroneDebugger getDebugger() {
        return this.debugger;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public ITextComponent getDroneName() {
        return this.func_145748_c_();
    }

    @Override
    public void storeTrackerData(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_218657_a("debuggingPC", (INBT)NBTUtil.func_186859_a((BlockPos)this.func_174877_v()));
        tag.func_82580_o("debuggingDrone");
    }

    @Override
    public boolean isDroneStillValid() {
        return !this.field_145846_f;
    }

    public boolean chunkloadSelf() {
        return this.chunkloadSelf;
    }

    public boolean chunkloadWorkingChunk() {
        return this.chunkloadWorkingChunk;
    }

    public boolean chunkloadWorkingChunk3x3() {
        return this.chunkloadWorkingChunk3x3;
    }

    private LazyOptional<IItemHandler> findEjectionDest() {
        Direction dir = null;
        for (Direction d : DirectionUtil.VALUES) {
            if (!this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d).map(h -> h == this.inventory).orElse(false).booleanValue()) continue;
            dir = d;
            break;
        }
        if (dir != null) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            return IOHelper.getInventoryForTE(te, dir.func_176734_d());
        }
        return LazyOptional.empty();
    }

    private class ProgrammableItemStackHandler
    extends BaseItemStackHandler {
        ProgrammableItemStackHandler(TileEntity te) {
            super(te, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemStack stack = this.getStackInSlot(slot);
            TileEntityProgrammableController.this.progWidgets.clear();
            if (!stack.func_190926_b() && TileEntityProgrammableController.isProgrammableAndValidForDrone(TileEntityProgrammableController.this, stack)) {
                TileEntityProgrammableController.this.progWidgets.addAll(TileEntityProgrammer.getProgWidgets(stack));
                TileEntityProgrammer.updatePuzzleConnections(TileEntityProgrammableController.this.progWidgets);
                TileEntityProgrammableController.this.isIdle = false;
            } else {
                TileEntityProgrammableController.this.setDugBlock(null);
                TileEntityProgrammableController.this.targetX = (double)TileEntityProgrammableController.this.func_174877_v().func_177958_n() + 0.5;
                TileEntityProgrammableController.this.targetY = (double)TileEntityProgrammableController.this.func_174877_v().func_177956_o() + 1.0;
                TileEntityProgrammableController.this.targetZ = (double)TileEntityProgrammableController.this.func_174877_v().func_177952_p() + 0.5;
                boolean updateNeighbours = false;
                for (int i = 0; i < TileEntityProgrammableController.this.redstoneLevels.length; ++i) {
                    if (TileEntityProgrammableController.this.redstoneLevels[i] <= 0) continue;
                    ((TileEntityProgrammableController)TileEntityProgrammableController.this).redstoneLevels[i] = 0;
                    updateNeighbours = true;
                }
                if (updateNeighbours) {
                    TileEntityProgrammableController.this.updateNeighbours();
                }
                TileEntityProgrammableController.this.isIdle = true;
            }
            if (TileEntityProgrammableController.this.func_145831_w() != null && !TileEntityProgrammableController.this.func_145831_w().field_72995_K) {
                TileEntityProgrammableController.this.aiManager = null;
                TileEntityProgrammableController.this.aiManager = TileEntityProgrammableController.this.getAIManager();
                TileEntityProgrammableController.this.aiManager.setWidgets(TileEntityProgrammableController.this.progWidgets);
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || TileEntityProgrammableController.isProgrammableAndValidForDrone(TileEntityProgrammableController.this, itemStack);
        }
    }
}

